/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.parser.TrainingParameters;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParseSampleStream;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.lang.en.HeadRules;
import opennlp.tools.parser.treeinsert.Parser;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParserTrainerTool
implements CmdLineTool {
    @Override
    public String getName() {
        return "ParserTrainer";
    }

    @Override
    public String getShortDescription() {
        return "trains the learnable parser";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + TrainingParameters.getParameterUsage() + " -head-rules head_rules -data trainingData -model model\n" + TrainingParameters.getDescription();
    }

    static ObjectStream<Parse> openTrainingData(File trainingDataFile, Charset encoding) {
        FileInputStream trainingDataIn;
        CmdLineUtil.checkInputFile("Training data", trainingDataFile);
        System.err.print("Opening training data ... ");
        try {
            trainingDataIn = new FileInputStream(trainingDataFile);
        }
        catch (FileNotFoundException e) {
            System.err.println("failed");
            System.err.println("File not found: " + e.getMessage());
            throw new TerminateToolException(-1);
        }
        System.err.println("done");
        return new ParseSampleStream(new PlainTextByLineStream(trainingDataIn.getChannel(), encoding));
    }

    static Dictionary buildDictionary(ObjectStream<Parse> parseSamples, opennlp.tools.parser.HeadRules headRules, int cutoff) {
        Dictionary mdict;
        System.err.print("Building dictionary ...");
        try {
            mdict = opennlp.tools.parser.chunking.Parser.buildDictionary(parseSamples, headRules, cutoff);
        }
        catch (IOException e) {
            System.err.println("Error while building dictionary: " + e.getMessage());
            mdict = null;
        }
        System.err.println("done");
        return mdict;
    }

    @Override
    public void run(String[] args) {
        ParserModel model;
        File modelOutFile;
        block13: {
            if (args.length < 10) {
                System.out.println(this.getHelp());
                throw new TerminateToolException(1);
            }
            TrainingParameters parameters = new TrainingParameters(args);
            if (!parameters.isValid()) {
                System.out.println(this.getHelp());
                throw new TerminateToolException(1);
            }
            ObjectStream<Parse> sampleStream = ParserTrainerTool.openTrainingData(new File(CmdLineUtil.getParameter("-data", args)), parameters.getEncoding());
            modelOutFile = new File(CmdLineUtil.getParameter("-model", args));
            CmdLineUtil.checkOutputFile("parser model", modelOutFile);
            try {
                HeadRules rules = new HeadRules(new InputStreamReader((InputStream)new FileInputStream(new File(CmdLineUtil.getParameter("-head-rules", args))), parameters.getEncoding()));
                if (ParserType.CHUNKING.equals((Object)parameters.getParserType())) {
                    model = opennlp.tools.parser.chunking.Parser.train(parameters.getLanguage(), sampleStream, rules, parameters.getNumberOfIterations(), parameters.getCutoff());
                    break block13;
                }
                if (ParserType.TREEINSERT.equals((Object)parameters.getParserType())) {
                    model = Parser.train(parameters.getLanguage(), sampleStream, rules, parameters.getNumberOfIterations(), parameters.getCutoff());
                    break block13;
                }
                throw new IllegalStateException();
            }
            catch (IOException e) {
                CmdLineUtil.printTrainingIoError(e);
                throw new TerminateToolException(-1);
            }
            finally {
                try {
                    sampleStream.close();
                }
                catch (IOException e) {}
            }
        }
        CmdLineUtil.writeModel("parser", modelOutFile, model);
    }
}

