/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import opennlp.tools.cmdline.sentdetect.TrainingParameters;
import opennlp.tools.sentdetect.SDCrossValidator;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.FMeasure;

public final class SentenceDetectorCrossValidatorTool
implements CmdLineTool {
    public String getName() {
        return "SentenceDetectorCrossValidator";
    }

    public String getShortDescription() {
        return "10-fold cross validator for the learnable sentence detector";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + TrainingParameters.getParameterUsage() + " -data trainData\n" + TrainingParameters.getDescription();
    }

    public void run(String[] args) {
        if (args.length < 5) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        TrainingParameters parameters = new TrainingParameters(args);
        if (!parameters.isValid()) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        File trainingDataInFile = new File(CmdLineUtil.getParameter("-data", args));
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        ObjectStream<SentenceSample> sampleStream = SentenceDetectorTrainerTool.openSampleData("Training Data", trainingDataInFile, parameters.getEncoding());
        SDCrossValidator validator = new SDCrossValidator(parameters.getLanguage(), parameters.getCutoff(), parameters.getNumberOfIterations());
        try {
            validator.evaluate(sampleStream, 10);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        FMeasure result = validator.getFMeasure();
        System.out.println(result.toString());
    }
}

