/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.tokenizer;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.CmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.tokenizer.TokenizerTrainerTool;
import opennlp.tools.cmdline.tokenizer.TrainingParameters;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenizerCrossValidator;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.eval.FMeasure;

public final class TokenizerCrossValidatorTool
implements CmdLineTool {
    public String getName() {
        return "TokenizerCrossValidator";
    }

    public String getShortDescription() {
        return "10-fold cross validator for the learnable tokenizer";
    }

    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " " + TrainingParameters.getParameterUsage() + " -data trainData\n" + TrainingParameters.getDescription() + "\n" + "-data trainingData      training data used for cross validation";
    }

    public void run(String[] args) {
        if (args.length < 6) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        TrainingParameters parameters = new TrainingParameters(args);
        if (!parameters.isValid()) {
            System.out.println(this.getHelp());
            throw new TerminateToolException(1);
        }
        File trainingDataInFile = new File(CmdLineUtil.getParameter("-data", args));
        CmdLineUtil.checkInputFile("Training Data", trainingDataInFile);
        ObjectStream<TokenSample> sampleStream = TokenizerTrainerTool.openSampleData("Training Data", trainingDataInFile, parameters.getEncoding());
        TokenizerCrossValidator validator = new TokenizerCrossValidator(parameters.getLanguage(), parameters.isAlphaNumericOptimizationEnabled());
        try {
            validator.evaluate(sampleStream, 10);
        }
        catch (IOException e) {
            CmdLineUtil.printTrainingIoError(e);
            throw new TerminateToolException(-1);
        }
        finally {
            try {
                sampleStream.close();
            }
            catch (IOException e) {}
        }
        FMeasure result = validator.getFMeasure();
        System.out.println(result.toString());
    }
}

