/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;

public class DiscourseModel {
    private List<DiscourseEntity> entities = new ArrayList<DiscourseEntity>();
    int nextEntityId = 1;

    public void mentionEntity(DiscourseEntity e) {
        if (this.entities.remove(e)) {
            this.entities.add(0, e);
        } else {
            System.err.println("DiscourseModel.mentionEntity: failed to remove " + e);
        }
    }

    public int getNumEntities() {
        return this.entities.size();
    }

    public DiscourseEntity getEntity(int i) {
        return this.entities.get(i);
    }

    public void addEntity(DiscourseEntity e) {
        e.setId(this.nextEntityId);
        ++this.nextEntityId;
        this.entities.add(0, e);
    }

    public void mergeEntities(DiscourseEntity e1, DiscourseEntity e2, float confidence) {
        Iterator<MentionContext> ei = e2.getMentions();
        while (ei.hasNext()) {
            e1.addMention(ei.next());
        }
        this.entities.remove(e2);
    }

    public DiscourseEntity[] getEntities() {
        DiscourseEntity[] des = new DiscourseEntity[this.entities.size()];
        this.entities.toArray(des);
        return des;
    }

    public void clear() {
        this.entities.clear();
    }
}

