/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.mention.Parse;
import opennlp.tools.coref.sim.GenderEnum;
import opennlp.tools.coref.sim.NumberEnum;
import opennlp.tools.coref.sim.TestSimilarityModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverUtils {
    private static final Pattern ENDS_WITH_PERIOD = Pattern.compile("\\.$");
    private static final Pattern initialCaps = Pattern.compile("^[A-Z]");
    public static final Pattern singularThirdPersonPronounPattern = Pattern.compile("^(he|she|it|him|her|his|hers|its|himself|herself|itself)$", 2);
    public static final Pattern pluralThirdPersonPronounPattern = Pattern.compile("^(they|their|theirs|them|themselves)$", 2);
    public static final Pattern speechPronounPattern = Pattern.compile("^(I|me|my|you|your|you|we|us|our|ours)$", 2);
    public static final Pattern femalePronounPattern = Pattern.compile("^(she|her|hers|herself)$", 2);
    public static final Pattern neuterPronounPattern = Pattern.compile("^(it|its|itself)$", 2);
    public static final Pattern firstPersonPronounPattern = Pattern.compile("^(I|me|my|we|our|us|ours)$", 2);
    public static final Pattern secondPersonPronounPattern = Pattern.compile("^(you|your|yours)$", 2);
    public static final Pattern thirdPersonPronounPattern = Pattern.compile("^(he|she|it|him|her|his|hers|its|himself|herself|itself|they|their|theirs|them|themselves)$", 2);
    public static final Pattern singularPronounPattern = Pattern.compile("^(I|me|my|he|she|it|him|her|his|hers|its|himself|herself|itself)$", 2);
    public static final Pattern pluralPronounPattern = Pattern.compile("^(we|us|our|ours|they|their|theirs|them|themselves)$", 2);
    public static final Pattern malePronounPattern = Pattern.compile("^(he|him|his|himself)$", 2);
    public static final Pattern honorificsPattern = Pattern.compile("[A-Z][a-z]+\\.$|^[A-Z][b-df-hj-np-tv-xz]+$");
    public static final Pattern designatorsPattern = Pattern.compile("[a-z]\\.$|^[A-Z][b-df-hj-np-tv-xz]+$|^Co(rp)?$");
    private static final String NUM_COMPATIBLE = "num.compatible";
    private static final String NUM_INCOMPATIBLE = "num.incompatible";
    private static final String NUM_UNKNOWN = "num.unknown";
    private static final String GEN_COMPATIBLE = "gen.compatible";
    private static final String GEN_INCOMPATIBLE = "gen.incompatible";
    private static final String GEN_UNKNOWN = "gen.unknown";
    private static final String SIM_COMPATIBLE = "sim.compatible";
    private static final String SIM_INCOMPATIBLE = "sim.incompatible";
    private static final String SIM_UNKNOWN = "sim.unknown";
    private static final double MIN_SIM_PROB = 0.6;

    public static List<String> getContextFeatures(MentionContext mention) {
        ArrayList<String> features = new ArrayList<String>();
        if (mention.getPreviousToken() != null) {
            features.add("pt=" + mention.getPreviousToken().getSyntacticType());
            features.add("pw=" + ((Object)mention.getPreviousToken()).toString());
        } else {
            features.add("pt=BOS");
            features.add("pw=BOS");
        }
        if (mention.getNextToken() != null) {
            features.add("nt=" + mention.getNextToken().getSyntacticType());
            features.add("nw=" + ((Object)mention.getNextToken()).toString());
        } else {
            features.add("nt=EOS");
            features.add("nw=EOS");
        }
        if (mention.getNextTokenBasal() != null) {
            features.add("bnt=" + mention.getNextTokenBasal().getSyntacticType());
            features.add("bnw=" + ((Object)mention.getNextTokenBasal()).toString());
        } else {
            features.add("bnt=EOS");
            features.add("bnw=EOS");
        }
        return features;
    }

    public static List<String> getWordFeatures(Parse token) {
        ArrayList<String> wordFeatures = new ArrayList<String>();
        String word = ((Object)token).toString().toLowerCase();
        String wf = "";
        if (ENDS_WITH_PERIOD.matcher(word).find()) {
            wf = ",endWithPeriod";
        }
        String tokTag = token.getSyntacticType();
        wordFeatures.add("w=" + word + ",t=" + tokTag + wf);
        wordFeatures.add("t=" + tokTag + wf);
        return wordFeatures;
    }

    public static Set<String> constructModifierSet(Parse[] tokens, int headIndex) {
        HashSet<String> modSet = new HashSet<String>();
        for (int ti = 0; ti < headIndex; ++ti) {
            Parse tok = tokens[ti];
            modSet.add(((Object)tok).toString().toLowerCase());
        }
        return modSet;
    }

    public static String excludedDeterminerMentionString(MentionContext ec) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Parse token : ec.getTokenParses()) {
            String tag = token.getSyntacticType();
            if (tag.equals("DT")) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(((Object)token).toString());
            first = false;
        }
        return sb.toString();
    }

    public static String excludedHonorificMentionString(MentionContext ec) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Object[] mtokens = ec.getTokens();
        int tl = mtokens.length;
        for (int ti = 0; ti < tl; ++ti) {
            String token = mtokens[ti].toString();
            if (honorificsPattern.matcher(token).matches()) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(token);
            first = false;
        }
        return sb.toString();
    }

    public static String excludedTheMentionString(MentionContext ec) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        Object[] mtokens = ec.getTokens();
        int tl = mtokens.length;
        for (int ti = 0; ti < tl; ++ti) {
            String token = mtokens[ti].toString();
            if (token.equals("the") || token.equals("The") || token.equals("THE")) continue;
            if (!first) {
                sb.append(" ");
            }
            sb.append(token);
            first = false;
        }
        return sb.toString();
    }

    public static String getExactMatchFeature(MentionContext ec, MentionContext xec) {
        if (ResolverUtils.mentionString(ec).equals(ResolverUtils.mentionString(xec))) {
            return "exactMatch";
        }
        if (ResolverUtils.excludedHonorificMentionString(ec).equals(ResolverUtils.excludedHonorificMentionString(xec))) {
            return "exactMatchNoHonor";
        }
        if (ResolverUtils.excludedTheMentionString(ec).equals(ResolverUtils.excludedTheMentionString(xec))) {
            return "exactMatchNoThe";
        }
        if (ResolverUtils.excludedDeterminerMentionString(ec).equals(ResolverUtils.excludedDeterminerMentionString(xec))) {
            return "exactMatchNoDT";
        }
        return null;
    }

    public static List<String> getStringMatchFeatures(MentionContext mention, DiscourseEntity entity) {
        boolean sameHead = false;
        boolean modsMatch = false;
        boolean titleMatch = false;
        boolean nonTheModsMatch = false;
        ArrayList<String> features = new ArrayList<String>();
        Parse[] mtokens = mention.getTokenParses();
        Set<String> ecModSet = ResolverUtils.constructModifierSet(mtokens, mention.getHeadTokenIndex());
        String mentionHeadString = mention.getHeadTokenText().toLowerCase();
        HashSet<String> featureSet = new HashSet<String>();
        Iterator<MentionContext> ei = entity.getMentions();
        while (ei.hasNext()) {
            Set<String> descModSet;
            MentionContext entityMention = ei.next();
            String exactMatchFeature = ResolverUtils.getExactMatchFeature(entityMention, mention);
            if (exactMatchFeature != null) {
                featureSet.add(exactMatchFeature);
            } else if (entityMention.getParse().isCoordinatedNounPhrase() && !mention.getParse().isCoordinatedNounPhrase()) {
                featureSet.add("cmix");
            } else {
                String mentionStrip = ResolverUtils.stripNp(mention);
                String entityMentionStrip = ResolverUtils.stripNp(entityMention);
                if (mentionStrip != null && entityMentionStrip != null && ResolverUtils.isSubstring(mentionStrip, entityMentionStrip)) {
                    featureSet.add("substring");
                }
            }
            Parse[] xtoks = entityMention.getTokenParses();
            int headIndex = entityMention.getHeadTokenIndex();
            String entityMentionHeadString = entityMention.getHeadTokenText().toLowerCase();
            if (mentionHeadString.equals(entityMentionHeadString)) {
                sameHead = true;
                featureSet.add("hds=" + mentionHeadString);
                if (!modsMatch || !nonTheModsMatch) {
                    modsMatch = true;
                    nonTheModsMatch = true;
                    Set<String> entityMentionModifierSet = ResolverUtils.constructModifierSet(xtoks, headIndex);
                    for (String mw : ecModSet) {
                        if (entityMentionModifierSet.contains(mw)) continue;
                        modsMatch = false;
                        if (mw.equals("the")) continue;
                        nonTheModsMatch = false;
                        featureSet.add("mmw=" + mw);
                    }
                }
            }
            if (!(descModSet = ResolverUtils.constructModifierSet(xtoks, entityMention.getNonDescriptorStart())).contains(mentionHeadString)) continue;
            titleMatch = true;
        }
        if (!featureSet.isEmpty()) {
            features.addAll(featureSet);
        }
        if (sameHead) {
            features.add("sameHead");
            if (modsMatch) {
                features.add("modsMatch");
            } else if (nonTheModsMatch) {
                features.add("nonTheModsMatch");
            } else {
                features.add("modsMisMatch");
            }
        }
        if (titleMatch) {
            features.add("titleMatch");
        }
        return features;
    }

    public static boolean isSubstring(String ecStrip, String xecStrip) {
        int io = xecStrip.indexOf(ecStrip);
        if (io != -1) {
            if (io != 0 && xecStrip.charAt(io - 1) != ' ') {
                return false;
            }
            int end = io + ecStrip.length();
            return end == xecStrip.length() || xecStrip.charAt(end) == ' ';
        }
        return false;
    }

    public static String mentionString(MentionContext ec) {
        StringBuffer sb = new StringBuffer();
        Object[] mtokens = ec.getTokens();
        sb.append(mtokens[0].toString());
        int tl = mtokens.length;
        for (int ti = 1; ti < tl; ++ti) {
            String token = mtokens[ti].toString();
            sb.append(" ").append(token);
        }
        return sb.toString();
    }

    public static String stripNp(MentionContext mention) {
        String type;
        int start = mention.getNonDescriptorStart();
        Parse[] mtokens = mention.getTokenParses();
        int end = mention.getHeadTokenIndex() + 1;
        if (start == end) {
            return null;
        }
        if (mtokens[start].getSyntacticType().equals("DT")) {
            ++start;
        }
        if (start == end) {
            return null;
        }
        for (int i = start; i < end && !(type = mtokens[start].getSyntacticType()).startsWith("NNP"); ++i) {
            ++start;
        }
        if (start == end) {
            return null;
        }
        if (start + 1 != end) {
            if (honorificsPattern.matcher(((Object)mtokens[start]).toString()).find()) {
                ++start;
            }
            if (start == end) {
                return null;
            }
            if (designatorsPattern.matcher(((Object)mtokens[mtokens.length - 1]).toString()).find()) {
                --end;
            }
        }
        if (start == end) {
            return null;
        }
        String strip = "";
        for (int i = start; i < end; ++i) {
            strip = strip + ((Object)mtokens[i]).toString() + ' ';
        }
        return strip.trim();
    }

    public static MentionContext getProperNounExtent(DiscourseEntity de) {
        Iterator<MentionContext> ei = de.getMentions();
        while (ei.hasNext()) {
            MentionContext xec = ei.next();
            String xecHeadTag = xec.getHeadTokenTag();
            if (!xecHeadTag.startsWith("NNP") && !initialCaps.matcher(xec.getHeadTokenText()).find()) continue;
            return xec;
        }
        return null;
    }

    private static Map<String, String> getPronounFeatureMap(String pronoun) {
        HashMap<String, String> pronounMap = new HashMap<String, String>();
        if (malePronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("gender", "male");
        } else if (femalePronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("gender", "female");
        } else if (neuterPronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("gender", "neuter");
        }
        if (singularPronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("number", "singular");
        } else if (pluralPronounPattern.matcher(pronoun).matches()) {
            pronounMap.put("number", "plural");
        }
        return pronounMap;
    }

    public static List<String> getPronounMatchFeatures(MentionContext mention, DiscourseEntity entity) {
        boolean foundCompatiblePronoun = false;
        boolean foundIncompatiblePronoun = false;
        if (mention.getHeadTokenTag().startsWith("PRP")) {
            Map<String, String> pronounMap = ResolverUtils.getPronounFeatureMap(mention.getHeadTokenText());
            Iterator<MentionContext> mi = entity.getMentions();
            while (mi.hasNext()) {
                MentionContext candidateMention = mi.next();
                if (!candidateMention.getHeadTokenTag().startsWith("PRP")) continue;
                if (mention.getHeadTokenText().equalsIgnoreCase(candidateMention.getHeadTokenText())) {
                    foundCompatiblePronoun = true;
                    break;
                }
                Map<String, String> candidatePronounMap = ResolverUtils.getPronounFeatureMap(candidateMention.getHeadTokenText());
                boolean allKeysMatch = true;
                for (String key : pronounMap.keySet()) {
                    String cfv = candidatePronounMap.get(key);
                    if (cfv != null) {
                        if (pronounMap.get(key).equals(cfv)) continue;
                        foundIncompatiblePronoun = true;
                        allKeysMatch = false;
                        continue;
                    }
                    allKeysMatch = false;
                }
                if (!allKeysMatch) continue;
                foundCompatiblePronoun = true;
            }
        }
        ArrayList<String> pronounFeatures = new ArrayList<String>();
        if (foundCompatiblePronoun) {
            pronounFeatures.add("compatiblePronoun");
        }
        if (foundIncompatiblePronoun) {
            pronounFeatures.add("incompatiblePronoun");
        }
        return pronounFeatures;
    }

    public static List<String> getDistanceFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        MentionContext cec = entity.getLastExtent();
        int entityDistance = mention.getNounPhraseDocumentIndex() - cec.getNounPhraseDocumentIndex();
        int sentenceDistance = mention.getSentenceNumber() - cec.getSentenceNumber();
        int hobbsEntityDistance = sentenceDistance == 0 ? cec.getNounPhraseSentenceIndex() : entityDistance + 2 * cec.getNounPhraseSentenceIndex() - cec.getMaxNounPhraseSentenceIndex();
        features.add("hd=" + hobbsEntityDistance);
        features.add("de=" + entityDistance);
        features.add("ds=" + sentenceDistance);
        return features;
    }

    public static boolean definiteArticle(String tok, String tag) {
        return (tok = tok.toLowerCase()).equals("the") || tok.equals("these") || tok.equals("these") || tag.equals("PRP$");
    }

    public static String getNumberCompatibilityFeature(MentionContext ec, DiscourseEntity de) {
        NumberEnum en = de.getNumber();
        if (en == NumberEnum.UNKNOWN || ec.getNumber() == NumberEnum.UNKNOWN) {
            return NUM_UNKNOWN;
        }
        if (ec.getNumber() == en) {
            return NUM_COMPATIBLE;
        }
        return NUM_INCOMPATIBLE;
    }

    public static List<String> getCompatibilityFeatures(MentionContext mention, DiscourseEntity entity, TestSimilarityModel simModel) {
        ArrayList<String> compatFeatures = new ArrayList<String>();
        String semCompatible = ResolverUtils.getSemanticCompatibilityFeature(mention, entity, simModel);
        compatFeatures.add(semCompatible);
        String genCompatible = ResolverUtils.getGenderCompatibilityFeature(mention, entity);
        compatFeatures.add(genCompatible);
        String numCompatible = ResolverUtils.getNumberCompatibilityFeature(mention, entity);
        compatFeatures.add(numCompatible);
        if (semCompatible.equals(SIM_COMPATIBLE) && genCompatible.equals(GEN_COMPATIBLE) && numCompatible.equals(NUM_COMPATIBLE)) {
            compatFeatures.add("all.compatible");
        } else if (semCompatible.equals(SIM_INCOMPATIBLE) || genCompatible.equals(GEN_INCOMPATIBLE) || numCompatible.equals(NUM_INCOMPATIBLE)) {
            compatFeatures.add("some.incompatible");
        }
        return compatFeatures;
    }

    public static String getGenderCompatibilityFeature(MentionContext ec, DiscourseEntity de) {
        GenderEnum eg = de.getGender();
        if (eg == GenderEnum.UNKNOWN || ec.getGender() == GenderEnum.UNKNOWN) {
            return GEN_UNKNOWN;
        }
        if (ec.getGender() == eg) {
            return GEN_COMPATIBLE;
        }
        return GEN_INCOMPATIBLE;
    }

    public static String getSemanticCompatibilityFeature(MentionContext ec, DiscourseEntity de, TestSimilarityModel simModel) {
        if (simModel != null) {
            double best = 0.0;
            Iterator<MentionContext> xi = de.getMentions();
            while (xi.hasNext()) {
                MentionContext ec2 = xi.next();
                double sim = simModel.compatible(ec, ec2);
                if (!(sim > best)) continue;
                best = sim;
            }
            if (best > 0.6) {
                return SIM_COMPATIBLE;
            }
            if (best > 0.4) {
                return SIM_UNKNOWN;
            }
            return SIM_INCOMPATIBLE;
        }
        System.err.println("MaxentResolver: Uninitialized Semantic Model");
        return SIM_UNKNOWN;
    }

    public static String getMentionCountFeature(DiscourseEntity de) {
        if (de.getNumMentions() >= 5) {
            return "mc=5+";
        }
        return "mc=" + de.getNumMentions();
    }

    public static String getPronounGender(String pronoun) {
        if (malePronounPattern.matcher(pronoun).matches()) {
            return "m";
        }
        if (femalePronounPattern.matcher(pronoun).matches()) {
            return "f";
        }
        if (neuterPronounPattern.matcher(pronoun).matches()) {
            return "n";
        }
        return "u";
    }
}

