/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.File;
import java.nio.charset.Charset;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.formats.ad.ADChunkSampleStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADChunkSampleStreamFactory
implements ObjectStreamFactory<ChunkSample> {
    @Override
    public String getUsage() {
        return ArgumentParser.createUsage(Parameters.class);
    }

    @Override
    public boolean validateArguments(String[] args) {
        return ArgumentParser.validateArguments(args, Parameters.class);
    }

    @Override
    public ObjectStream<ChunkSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        Charset encoding = CmdLineUtil.getEncodingParameter(args);
        if (encoding == null) {
            throw new TerminateToolException(1);
        }
        ADChunkSampleStream sampleStream = new ADChunkSampleStream(CmdLineUtil.openInFile(new File(params.getData())), encoding.name());
        if (params.getStart() != null && params.getStart() > -1) {
            sampleStream.setStart(params.getStart());
        }
        if (params.getEnd() != null && params.getEnd() > -1) {
            sampleStream.setEnd(params.getEnd());
        }
        return sampleStream;
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="encoding")
        public String getEncoding();

        @ArgumentParser.ParameterDescription(valueName="sampleData")
        public String getData();

        @ArgumentParser.ParameterDescription(valueName="start", description="index of first sentence")
        @ArgumentParser.OptionalParameter
        public Integer getStart();

        @ArgumentParser.ParameterDescription(valueName="end", description="index of last sentence")
        @ArgumentParser.OptionalParameter
        public Integer getEnd();
    }
}

