/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.Span;

public class NameSample {
    private final List<String> sentence;
    private final List<Span> names;
    private final String[][] additionalContext;
    private final boolean isClearAdaptiveData;

    public NameSample(String[] sentence, Span[] names, String[][] additionalContext, boolean clearAdaptiveData) {
        if (sentence == null) {
            throw new IllegalArgumentException("sentence must not be null!");
        }
        if (names == null) {
            names = new Span[]{};
        }
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(sentence)));
        this.names = Collections.unmodifiableList(new ArrayList<Span>(Arrays.asList(names)));
        if (additionalContext != null) {
            this.additionalContext = new String[additionalContext.length][];
            for (int i = 0; i < additionalContext.length; ++i) {
                this.additionalContext[i] = new String[additionalContext[i].length];
                System.arraycopy(additionalContext[i], 0, this.additionalContext[i], 0, additionalContext[i].length);
            }
        } else {
            this.additionalContext = null;
        }
        this.isClearAdaptiveData = clearAdaptiveData;
    }

    public NameSample(String[] sentence, Span[] names, boolean clearAdaptiveData) {
        this(sentence, names, null, clearAdaptiveData);
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public Span[] getNames() {
        return this.names.toArray(new Span[this.names.size()]);
    }

    public String[][] getAdditionalContext() {
        return this.additionalContext;
    }

    public boolean isClearAdaptiveDataSet() {
        return this.isClearAdaptiveData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NameSample) {
            NameSample a = (NameSample)obj;
            return Arrays.equals(this.getSentence(), a.getSentence()) && Arrays.equals(this.getNames(), a.getNames()) && Arrays.equals((Object[])this.getAdditionalContext(), (Object[])a.getAdditionalContext()) && this.isClearAdaptiveDataSet() == a.isClearAdaptiveDataSet();
        }
        return true;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isClearAdaptiveDataSet()) {
            result.append("\n");
        }
        for (int tokenIndex = 0; tokenIndex < this.sentence.size(); ++tokenIndex) {
            for (int nameIndex = 0; nameIndex < this.names.size(); ++nameIndex) {
                if (this.names.get(nameIndex).getStart() == tokenIndex) {
                    if (this.names.get(nameIndex).getType() == null) {
                        result.append("<START>").append(' ');
                    } else {
                        result.append("<START:").append(this.names.get(nameIndex).getType()).append("> ");
                    }
                }
                if (this.names.get(nameIndex).getEnd() != tokenIndex) continue;
                result.append("<END>").append(' ');
            }
            result.append(this.sentence.get(tokenIndex) + ' ');
        }
        if (this.sentence.size() > 1) {
            result.setLength(result.length() - 1);
        }
        for (int nameIndex = 0; nameIndex < this.names.size(); ++nameIndex) {
            if (this.names.get(nameIndex).getEnd() != this.sentence.size()) continue;
            result.append(' ').append("<END>");
        }
        return result.toString();
    }

    public static NameSample parse(String taggedTokens, boolean isClearAdaptiveData) throws IOException {
        String[] parts = WhitespaceTokenizer.INSTANCE.tokenize(taggedTokens);
        ArrayList<String> tokenList = new ArrayList<String>(parts.length);
        ArrayList<Span> nameList = new ArrayList<Span>();
        String nameType = null;
        int startIndex = -1;
        int wordIndex = 0;
        boolean catchingName = false;
        Pattern startTagPattern = Pattern.compile("<START(:(\\w*))?>");
        for (int pi = 0; pi < parts.length; ++pi) {
            Matcher startMatcher = startTagPattern.matcher(parts[pi]);
            if (startMatcher.matches()) {
                if (catchingName) {
                    throw new IOException("Found unexpected annotation " + parts[pi] + " while handling a name sequence.");
                }
                catchingName = true;
                startIndex = wordIndex;
                nameType = startMatcher.group(2);
                if (nameType == null || nameType.length() != 0) continue;
                throw new IOException("Missing a name type: " + parts[pi]);
            }
            if (parts[pi].equals("<END>")) {
                if (!catchingName) {
                    throw new IOException("Found unexpected annotation " + parts[pi] + ".");
                }
                catchingName = false;
                nameList.add(new Span(startIndex, wordIndex, nameType));
                continue;
            }
            tokenList.add(parts[pi]);
            ++wordIndex;
        }
        String[] sentence = tokenList.toArray(new String[tokenList.size()]);
        Span[] names = nameList.toArray(new Span[nameList.size()]);
        return new NameSample(sentence, names, isClearAdaptiveData);
    }
}

