/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.formats.ad.ADSentenceStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADChunkSampleStream
implements ObjectStream<ChunkSample> {
    private final ObjectStream<ADSentenceStream.Sentence> adSentenceStream;
    private int start = -1;
    private int end = -1;
    private int index = 0;

    public ADChunkSampleStream(ObjectStream<String> lineStream) {
        this.adSentenceStream = new ADSentenceStream(lineStream);
    }

    public ADChunkSampleStream(InputStream in, String charsetName) {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream(in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ChunkSample read() throws IOException {
        ADSentenceStream.Sentence paragraph;
        while ((paragraph = this.adSentenceStream.read()) != null) {
            if (this.end > -1 && this.index >= this.end) {
                return null;
            }
            if (this.start > -1 && this.index < this.start) {
                ++this.index;
                continue;
            }
            ADSentenceStream.SentenceParser.Node root = paragraph.getRoot();
            ArrayList<String> sentence = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            ArrayList<String> target = new ArrayList<String>();
            this.processRoot(root, sentence, tags, target);
            if (sentence.size() <= 0) continue;
            ++this.index;
            return new ChunkSample(sentence, tags, target);
        }
        return null;
    }

    private void processRoot(ADSentenceStream.SentenceParser.Node root, List<String> sentence, List<String> tags, List<String> target) {
        if (root != null) {
            ADSentenceStream.SentenceParser.TreeElement[] elements = root.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i].isLeaf()) {
                    this.processLeaf((ADSentenceStream.SentenceParser.Leaf)elements[i], false, "O", sentence, tags, target);
                    continue;
                }
                this.processNode((ADSentenceStream.SentenceParser.Node)elements[i], sentence, tags, target);
            }
        }
    }

    private void processNode(ADSentenceStream.SentenceParser.Node node, List<String> sentence, List<String> tags, List<String> target) {
        String phraseTag = this.getChunkTag(node.getSyntacticTag());
        ADSentenceStream.SentenceParser.TreeElement[] elements = node.getElements();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].isLeaf()) {
                boolean isIntermediate = false;
                if (i > 0 && elements[i - 1].isLeaf() && phraseTag != null && !phraseTag.equals("O")) {
                    isIntermediate = true;
                }
                this.processLeaf((ADSentenceStream.SentenceParser.Leaf)elements[i], isIntermediate, phraseTag, sentence, tags, target);
                continue;
            }
            this.processNode((ADSentenceStream.SentenceParser.Node)elements[i], sentence, tags, target);
        }
    }

    private void processLeaf(ADSentenceStream.SentenceParser.Leaf leaf, boolean isIntermediate, String phraseTag, List<String> sentence, List<String> tags, List<String> target) {
        if (leaf.getSyntacticTag() != null && phraseTag.equals("O")) {
            if (leaf.getSyntacticTag().endsWith("v-fin")) {
                phraseTag = "VP";
            } else if (leaf.getSyntacticTag().endsWith(":n")) {
                phraseTag = "NP";
            }
        }
        String chunkTag = !phraseTag.equals("O") ? (isIntermediate ? "I-" + phraseTag : "B-" + phraseTag) : phraseTag;
        sentence.add(leaf.getLexeme());
        if (leaf.getSyntacticTag() == null) {
            tags.add(leaf.getLexeme());
        } else {
            tags.add(this.getMorphologicalTag(leaf.getSyntacticTag()));
        }
        target.add(chunkTag);
    }

    private String getMorphologicalTag(String tag) {
        return tag.substring(tag.lastIndexOf(":") + 1);
    }

    private String getChunkTag(String tag) {
        String phraseTag = tag.substring(tag.lastIndexOf(":") + 1);
        phraseTag = phraseTag.equals("np") || phraseTag.equals("vp") || phraseTag.equals("pp") || phraseTag.equals("ap") || phraseTag.equals("advp") ? phraseTag.toUpperCase() : "O";
        return phraseTag;
    }

    public void setStart(int aStart) {
        this.start = aStart;
    }

    public void setEnd(int aEnd) {
        this.end = aEnd;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.adSentenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.adSentenceStream.close();
    }
}

