/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.formats.ad.ADSentenceStream;
import opennlp.tools.formats.ad.PortugueseContractionUtility;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADNameSampleStream
implements ObjectStream<NameSample> {
    private static final Pattern tagPattern = Pattern.compile("<(NER:)?(.*?)>");
    private static final Map<String, String> HAREM;
    private final ObjectStream<ADSentenceStream.Sentence> adSentenceStream;
    private String leftContractionPart = null;

    public ADNameSampleStream(ObjectStream<String> lineStream) {
        this.adSentenceStream = new ADSentenceStream(lineStream);
    }

    public ADNameSampleStream(InputStream in, String charsetName) {
        try {
            this.adSentenceStream = new ADSentenceStream(new PlainTextByLineStream(in, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public NameSample read() throws IOException {
        ADSentenceStream.Sentence paragraph = this.adSentenceStream.read();
        if (paragraph != null) {
            ADSentenceStream.SentenceParser.Node root = paragraph.getRoot();
            ArrayList<String> sentence = new ArrayList<String>();
            ArrayList<Span> names = new ArrayList<Span>();
            this.process(root, sentence, names);
            return new NameSample(sentence.toArray(new String[sentence.size()]), names.toArray(new Span[names.size()]), true);
        }
        return null;
    }

    private void process(ADSentenceStream.SentenceParser.Node node, List<String> sentence, List<Span> names) {
        if (node != null) {
            for (ADSentenceStream.SentenceParser.TreeElement element : node.getElements()) {
                if (element.isLeaf()) {
                    this.processLeaf((ADSentenceStream.SentenceParser.Leaf)element, sentence, names);
                    continue;
                }
                this.process((ADSentenceStream.SentenceParser.Node)element, sentence, names);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processLeaf(ADSentenceStream.SentenceParser.Leaf leaf, List<String> sentence, List<Span> names) {
        if (leaf != null && this.leftContractionPart == null) {
            String namedEntityTag = null;
            int startOfNamedEntity = -1;
            String leafTag = leaf.getMorphologicalTag();
            boolean expandLastNER = false;
            if (leafTag != null) {
                if (leafTag.contains("<sam->")) {
                    String[] lexemes = leaf.getLexeme().split("_");
                    if (lexemes.length > 1) {
                        for (int i = 0; i < lexemes.length - 1; ++i) {
                            sentence.add(lexemes[i]);
                        }
                    }
                    this.leftContractionPart = lexemes[lexemes.length - 1];
                    return;
                }
                if (leafTag.contains("<NER2>")) {
                    expandLastNER = true;
                }
                namedEntityTag = ADNameSampleStream.getNER(leafTag);
            }
            if (namedEntityTag != null) {
                startOfNamedEntity = sentence.size();
            }
            sentence.addAll(Arrays.asList(leaf.getLexeme().split("_")));
            if (namedEntityTag != null) {
                names.add(new Span(startOfNamedEntity, sentence.size(), namedEntityTag));
            }
            if (!expandLastNER) return;
            int lastIndex = names.size() - 1;
            Span last = null;
            boolean error = false;
            if (names.size() <= 0) return;
            last = names.get(lastIndex);
            if (last.getEnd() != sentence.size() - 1) return;
            names.set(lastIndex, new Span(last.getStart(), sentence.size(), last.getType()));
            if (!error) return;
        }
        String tag = leaf.getMorphologicalTag();
        String right = leaf.getLexeme();
        if (tag != null && tag.contains("<-sam>")) {
            right = leaf.getLexeme();
            String c = PortugueseContractionUtility.toContraction(this.leftContractionPart, right);
            if (c != null) {
                sentence.add(c);
            } else {
                System.err.println("missing " + this.leftContractionPart + " + " + right);
                sentence.add(this.leftContractionPart);
                sentence.add(right);
            }
        } else {
            System.err.println("unmatch" + this.leftContractionPart + " + " + right);
        }
        this.leftContractionPart = null;
    }

    private static String getNER(String tags) {
        String[] tag;
        for (String t : tag = tags.split("\\s+")) {
            String ner;
            Matcher matcher = tagPattern.matcher(t);
            if (!matcher.matches() || !HAREM.containsKey(ner = matcher.group(2))) continue;
            return HAREM.get(ner);
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.adSentenceStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.adSentenceStream.close();
    }

    static {
        HashMap<String, String> harem = new HashMap<String, String>();
        String person = "person";
        harem.put("hum", "person");
        harem.put("official", "person");
        harem.put("member", "person");
        String organization = "organization";
        harem.put("admin", "organization");
        harem.put("org", "organization");
        harem.put("inst", "organization");
        harem.put("media", "organization");
        harem.put("party", "organization");
        harem.put("suborg", "organization");
        String group = "group";
        harem.put("groupind", "group");
        harem.put("groupofficial", "group");
        String place = "place";
        harem.put("top", "place");
        harem.put("civ", "place");
        harem.put("address", "place");
        harem.put("site", "place");
        harem.put("virtual", "place");
        harem.put("astro", "place");
        String event = "event";
        harem.put("occ", "event");
        harem.put("event", "event");
        harem.put("history", "event");
        String artprod = "artprod";
        harem.put("tit", "artprod");
        harem.put("pub", "artprod");
        harem.put("product", "artprod");
        harem.put("V", "artprod");
        harem.put("artwork", "artprod");
        String _abstract = "abstract";
        harem.put("brand", "abstract");
        harem.put("genre", "abstract");
        harem.put("school", "abstract");
        harem.put("idea", "abstract");
        harem.put("plan", "abstract");
        harem.put("author", "abstract");
        harem.put("absname", "abstract");
        harem.put("disease", "abstract");
        String thing = "thing";
        harem.put("object", "thing");
        harem.put("common", "thing");
        harem.put("mat", "thing");
        harem.put("class", "thing");
        harem.put("plant", "thing");
        harem.put("currency", "thing");
        String time = "time";
        harem.put("date", "time");
        harem.put("hour", "time");
        harem.put("period", "time");
        harem.put("cyclic", "time");
        String numeric = "numeric";
        harem.put("quantity", "numeric");
        harem.put("prednum", "numeric");
        harem.put("currency", "numeric");
        HAREM = Collections.unmodifiableMap(harem);
    }
}

