/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.LinkedList;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.dictionary.Index;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringList;

public class DictionaryNameFinder
implements TokenNameFinder {
    private Dictionary mDictionary;
    private Index mMetaDictionary;

    public DictionaryNameFinder(Dictionary dictionary) {
        this.mDictionary = dictionary;
        this.mMetaDictionary = new Index(dictionary.iterator());
    }

    public Span[] find(String[] tokenStrings) {
        LinkedList<Span> foundNames = new LinkedList<Span>();
        for (int startToken = 0; startToken < tokenStrings.length; ++startToken) {
            Span foundName = null;
            String[] tokens = new String[]{};
            for (int endToken = startToken; endToken < tokenStrings.length; ++endToken) {
                String token = tokenStrings[endToken];
                String[] newTokens = new String[tokens.length + 1];
                System.arraycopy(tokens, 0, newTokens, 0, tokens.length);
                newTokens[newTokens.length - 1] = token;
                tokens = newTokens;
                if (!this.mMetaDictionary.contains(token)) break;
                StringList tokenList = new StringList(tokens);
                if (!this.mDictionary.contains(tokenList)) continue;
                foundName = new Span(startToken, endToken + 1);
            }
            if (foundName == null) continue;
            foundNames.add(foundName);
        }
        return foundNames.toArray(new Span[foundNames.size()]);
    }

    public void clearAdaptiveData() {
    }
}

