/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import opennlp.model.AbstractModel;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;
import opennlp.model.SequenceStream;
import opennlp.model.TrainUtil;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ngram.NGramModel;
import opennlp.tools.postag.DefaultPOSContextGenerator;
import opennlp.tools.postag.POSContextGenerator;
import opennlp.tools.postag.POSDictionary;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSSampleEventStream;
import opennlp.tools.postag.POSSampleSequenceStream;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.TagDictionary;
import opennlp.tools.util.BeamSearch;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Sequence;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.StringList;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSTaggerME
implements POSTagger {
    protected AbstractModel posModel;
    protected POSContextGenerator contextGen;
    protected TagDictionary tagDictionary;
    protected Dictionary ngramDictionary;
    protected boolean useClosedClassTagsFilter = false;
    public static final int DEFAULT_BEAM_SIZE = 3;
    protected int size;
    private Sequence bestSequence;
    protected BeamSearch<String> beam;

    public POSTaggerME(POSModel model, int beamSize, int cacheSize, SequenceValidator<String> sequenceValidator) {
        this.posModel = model.getPosModel();
        this.contextGen = new DefaultPOSContextGenerator(beamSize, model.getNgramDictionary());
        this.tagDictionary = model.getTagDictionary();
        this.size = beamSize;
        this.beam = new BeamSearch<String>(this.size, this.contextGen, (MaxentModel)this.posModel, sequenceValidator, cacheSize);
    }

    public POSTaggerME(POSModel model, int beamSize, int cacheSize) {
        this(model, beamSize, cacheSize, new PosSequenceValidator(model.getTagDictionary()));
    }

    public POSTaggerME(POSModel model) {
        this(model, 3, 0);
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, TagDictionary tagdict) {
        this(model, new DefaultPOSContextGenerator(null), tagdict);
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, Dictionary dict) {
        this(model, new DefaultPOSContextGenerator(dict));
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, Dictionary dict, TagDictionary tagdict) {
        this(3, model, new DefaultPOSContextGenerator(dict), tagdict);
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, POSContextGenerator cg) {
        this(3, model, cg, null);
    }

    @Deprecated
    public POSTaggerME(AbstractModel model, POSContextGenerator cg, TagDictionary tagdict) {
        this(3, model, cg, tagdict);
    }

    @Deprecated
    public POSTaggerME(int beamSize, AbstractModel model, POSContextGenerator cg, TagDictionary tagdict) {
        this.size = beamSize;
        this.posModel = model;
        this.contextGen = cg;
        this.beam = new BeamSearch<String>(this.size, cg, (MaxentModel)model);
        this.tagDictionary = tagdict;
    }

    public int getNumTags() {
        return this.posModel.getNumOutcomes();
    }

    @Override
    @Deprecated
    public List<String> tag(List<String> sentence) {
        this.bestSequence = this.beam.bestSequence((String[])sentence.toArray(new String[sentence.size()]), null);
        return this.bestSequence.getOutcomes();
    }

    @Override
    public String[] tag(String[] sentence) {
        this.bestSequence = this.beam.bestSequence((String[])sentence, null);
        List<String> t = this.bestSequence.getOutcomes();
        return t.toArray(new String[t.size()]);
    }

    public String[][] tag(int numTaggings, String[] sentence) {
        Sequence[] bestSequences = this.beam.bestSequences(numTaggings, (String[])sentence, null);
        String[][] tags = new String[bestSequences.length][];
        for (int si = 0; si < tags.length; ++si) {
            List<String> t = bestSequences[si].getOutcomes();
            tags[si] = t.toArray(new String[t.size()]);
        }
        return tags;
    }

    @Override
    @Deprecated
    public Sequence[] topKSequences(List<String> sentence) {
        return this.beam.bestSequences(this.size, (String[])sentence.toArray(new String[sentence.size()]), null);
    }

    @Override
    public Sequence[] topKSequences(String[] sentence) {
        return this.beam.bestSequences(this.size, (String[])sentence, null);
    }

    public void probs(double[] probs) {
        this.bestSequence.getProbs(probs);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    @Override
    @Deprecated
    public String tag(String sentence) {
        ArrayList<String> toks = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(sentence);
        while (st.hasMoreTokens()) {
            toks.add(st.nextToken());
        }
        List<String> tags = this.tag(toks);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tags.size(); ++i) {
            sb.append((String)toks.get(i) + "/" + tags.get(i) + " ");
        }
        return sb.toString().trim();
    }

    public String[] getOrderedTags(List<String> words, List<String> tags, int index) {
        return this.getOrderedTags(words, tags, index, null);
    }

    public String[] getOrderedTags(List<String> words, List<String> tags, int index, double[] tprobs) {
        double[] probs = this.posModel.eval(this.contextGen.getContext(index, words.toArray(new String[words.size()]), tags.toArray(new String[tags.size()]), (Object[])null));
        String[] orderedTags = new String[probs.length];
        for (int i = 0; i < probs.length; ++i) {
            int max = 0;
            for (int ti = 1; ti < probs.length; ++ti) {
                if (!(probs[ti] > probs[max])) continue;
                max = ti;
            }
            orderedTags[i] = this.posModel.getOutcome(max);
            if (tprobs != null) {
                tprobs[i] = probs[max];
            }
            probs[max] = 0.0;
        }
        return orderedTags;
    }

    public static POSModel train(String languageCode, ObjectStream<POSSample> samples, TrainingParameters trainParams, POSDictionary tagDictionary, Dictionary ngramDictionary) throws IOException {
        AbstractModel posModel;
        DefaultPOSContextGenerator contextGenerator = new DefaultPOSContextGenerator(ngramDictionary);
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        if (!TrainUtil.isSequenceTraining(trainParams.getSettings())) {
            POSSampleEventStream es = new POSSampleEventStream(samples, contextGenerator);
            posModel = TrainUtil.train((EventStream)es, trainParams.getSettings(), manifestInfoEntries);
        } else {
            POSSampleSequenceStream ss = new POSSampleSequenceStream(samples, contextGenerator);
            posModel = TrainUtil.train((SequenceStream)ss, trainParams.getSettings(), manifestInfoEntries);
        }
        return new POSModel(languageCode, posModel, tagDictionary, ngramDictionary, manifestInfoEntries);
    }

    @Deprecated
    public static POSModel train(String languageCode, ObjectStream<POSSample> samples, ModelType modelType, POSDictionary tagDictionary, Dictionary ngramDictionary, int cutoff, int iterations) throws IOException {
        TrainingParameters params = new TrainingParameters();
        params.put("Algorithm", modelType.toString());
        params.put("Iterations", Integer.toString(iterations));
        params.put("Cutoff", Integer.toString(cutoff));
        return POSTaggerME.train(languageCode, samples, params, tagDictionary, ngramDictionary);
    }

    public static Dictionary buildNGramDictionary(ObjectStream<POSSample> samples, int cutoff) throws IOException {
        POSSample sample;
        NGramModel ngramModel = new NGramModel();
        while ((sample = samples.read()) != null) {
            String[] words = sample.getSentence();
            if (words.length <= 0) continue;
            ngramModel.add(new StringList(words), 1, 1);
        }
        ngramModel.cutoff(cutoff, Integer.MAX_VALUE);
        return ngramModel.toDictionary(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PosSequenceValidator
    implements SequenceValidator<String> {
        private POSDictionary tagDictionary;

        PosSequenceValidator(POSDictionary tagDictionary) {
            this.tagDictionary = tagDictionary;
        }

        public boolean validSequence(int i, String[] inputSequence, String[] outcomesSequence, String outcome) {
            if (this.tagDictionary == null) {
                return true;
            }
            String[] tags = this.tagDictionary.getTags(inputSequence[i].toString());
            if (tags == null) {
                return true;
            }
            return Arrays.asList(tags).contains(outcome);
        }
    }
}

