/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import opennlp.model.AbstractModel;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;
import opennlp.model.TrainUtil;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.SDEventStream;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.lang.Factory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.model.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceDetectorME
implements SentenceDetector {
    public static final String SPLIT = "s";
    public static final String NO_SPLIT = "n";
    private static final Double ONE = new Double(1.0);
    private MaxentModel model;
    private final SDContextGenerator cgen;
    private final EndOfSentenceScanner scanner;
    private List<Double> sentProbs = new ArrayList<Double>();
    protected boolean useTokenEnd;

    public SentenceDetectorME(SentenceModel model) {
        this(model, new Factory());
    }

    public SentenceDetectorME(SentenceModel model, Factory factory) {
        this.model = model.getMaxentModel();
        this.cgen = factory.createSentenceContextGenerator(model.getLanguage(), SentenceDetectorME.getAbbreviations(model.getAbbreviations()));
        this.scanner = factory.createEndOfSentenceScanner(model.getLanguage());
        this.useTokenEnd = model.useTokenEnd();
    }

    private static Set<String> getAbbreviations(Dictionary abbreviations) {
        if (abbreviations == null) {
            return Collections.emptySet();
        }
        return abbreviations.asStringSet();
    }

    @Override
    public String[] sentDetect(String s) {
        String[] sentences;
        Span[] spans = this.sentPosDetect(s);
        if (spans.length != 0) {
            sentences = new String[spans.length];
            for (int si = 0; si < spans.length; ++si) {
                sentences[si] = ((Object)spans[si].getCoveredText(s)).toString();
            }
        } else {
            sentences = new String[]{};
        }
        return sentences;
    }

    private int getFirstWS(String s, int pos) {
        while (pos < s.length() && !StringUtil.isWhitespace(s.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private int getFirstNonWS(String s, int pos) {
        while (pos < s.length() && StringUtil.isWhitespace(s.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    @Override
    public Span[] sentPosDetect(String s) {
        this.sentProbs.clear();
        StringBuffer sb = new StringBuffer(s);
        List<Integer> enders = this.scanner.getPositions(s);
        ArrayList<Integer> positions = new ArrayList<Integer>(enders.size());
        int end = enders.size();
        int index = 0;
        for (int i = 0; i < end; ++i) {
            double[] probs;
            String bestOutcome;
            Integer candidate = enders.get(i);
            int cint = candidate;
            int fws = this.getFirstWS(s, cint + 1);
            if (i + 1 < end && enders.get(i + 1) < fws || !(bestOutcome = this.model.getBestOutcome(probs = this.model.eval(this.cgen.getContext(sb, cint)))).equals(SPLIT) || !this.isAcceptableBreak(s, index, cint)) continue;
            if (index != cint) {
                if (this.useTokenEnd) {
                    positions.add(this.getFirstNonWS(s, this.getFirstWS(s, cint + 1)));
                } else {
                    positions.add(this.getFirstNonWS(s, cint));
                }
                this.sentProbs.add(new Double(probs[this.model.getIndex(bestOutcome)]));
            }
            index = cint + 1;
        }
        int[] starts = new int[positions.size()];
        for (int i = 0; i < starts.length; ++i) {
            starts[i] = (Integer)positions.get(i);
        }
        if (starts.length == 0) {
            int start;
            int end2 = s.length();
            for (start = 0; start < s.length() && StringUtil.isWhitespace(s.charAt(start)); ++start) {
            }
            while (end2 > 0 && StringUtil.isWhitespace(s.charAt(end2 - 1))) {
                --end2;
            }
            if (end2 - start > 0) {
                this.sentProbs.add(1.0);
                return new Span[]{new Span(start, end2)};
            }
            return new Span[0];
        }
        boolean leftover = starts[starts.length - 1] != s.length();
        Span[] spans = new Span[leftover ? starts.length + 1 : starts.length];
        for (int si = 0; si < starts.length; ++si) {
            int end3;
            int start;
            if (si == 0) {
                start = 0;
                while (si < starts.length && StringUtil.isWhitespace(s.charAt(start))) {
                    ++start;
                }
            } else {
                start = starts[si - 1];
            }
            for (end3 = starts[si]; end3 > 0 && StringUtil.isWhitespace(s.charAt(end3 - 1)); --end3) {
            }
            spans[si] = new Span(start, end3);
        }
        if (leftover) {
            spans[spans.length - 1] = new Span(starts[starts.length - 1], s.length());
            this.sentProbs.add(ONE);
        }
        return spans;
    }

    public double[] getSentenceProbabilities() {
        double[] sentProbArray = new double[this.sentProbs.size()];
        for (int i = 0; i < sentProbArray.length; ++i) {
            sentProbArray[i] = this.sentProbs.get(i);
        }
        return sentProbArray;
    }

    protected boolean isAcceptableBreak(String s, int fromIndex, int candidateIndex) {
        return true;
    }

    public static SentenceModel train(String languageCode, ObjectStream<SentenceSample> samples, boolean useTokenEnd, Dictionary abbreviations, TrainingParameters mlParams) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        Factory factory = new Factory();
        SDEventStream eventStream = new SDEventStream(samples, factory.createSentenceContextGenerator(languageCode, SentenceDetectorME.getAbbreviations(abbreviations)), factory.createEndOfSentenceScanner(languageCode));
        AbstractModel sentModel = TrainUtil.train((EventStream)eventStream, mlParams.getSettings(), manifestInfoEntries);
        return new SentenceModel(languageCode, sentModel, useTokenEnd, abbreviations, manifestInfoEntries);
    }

    @Deprecated
    public static SentenceModel train(String languageCode, ObjectStream<SentenceSample> samples, boolean useTokenEnd, Dictionary abbreviations, int cutoff, int iterations) throws IOException {
        return SentenceDetectorME.train(languageCode, samples, useTokenEnd, abbreviations, ModelUtil.createTrainingParameters(iterations, cutoff));
    }

    public static SentenceModel train(String languageCode, ObjectStream<SentenceSample> samples, boolean useTokenEnd, Dictionary abbreviations) throws IOException {
        return SentenceDetectorME.train(languageCode, samples, useTokenEnd, abbreviations, 5, 100);
    }
}

