/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.HashSet;
import opennlp.tools.tokenize.DetokenizationDictionary;
import opennlp.tools.tokenize.Detokenizer;

public class DictionaryDetokenizer
implements Detokenizer {
    private final DetokenizationDictionary dict;

    public DictionaryDetokenizer(DetokenizationDictionary dict) {
        this.dict = dict;
    }

    public Detokenizer.DetokenizationOperation[] detokenize(String[] tokens) {
        Detokenizer.DetokenizationOperation[] operations = new Detokenizer.DetokenizationOperation[tokens.length];
        HashSet<String> matchingTokens = new HashSet<String>();
        for (int i = 0; i < tokens.length; ++i) {
            DetokenizationDictionary.Operation dictOperation = this.dict.getOperation(tokens[i]);
            if (dictOperation == null) {
                operations[i] = Detokenizer.DetokenizationOperation.NO_OPERATION;
                continue;
            }
            if (DetokenizationDictionary.Operation.MOVE_LEFT.equals((Object)dictOperation)) {
                operations[i] = Detokenizer.DetokenizationOperation.MERGE_TO_LEFT;
                continue;
            }
            if (DetokenizationDictionary.Operation.MOVE_RIGHT.equals((Object)dictOperation)) {
                operations[i] = Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT;
                continue;
            }
            if (DetokenizationDictionary.Operation.RIGHT_LEFT_MATCHING.equals((Object)dictOperation)) {
                if (matchingTokens.contains(tokens[i])) {
                    operations[i] = Detokenizer.DetokenizationOperation.MERGE_TO_LEFT;
                    matchingTokens.remove(tokens[i]);
                    continue;
                }
                operations[i] = Detokenizer.DetokenizationOperation.MERGE_TO_RIGHT;
                matchingTokens.add(tokens[i]);
                continue;
            }
            throw new IllegalStateException("Unkown operation: " + (Object)((Object)dictOperation));
        }
        return operations;
    }
}

