/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.Iterator;
import opennlp.model.Event;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.DocumentCategorizerContextGenerator;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.util.AbstractEventStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentCategorizerEventStream
extends AbstractEventStream<DocumentSample> {
    private DocumentCategorizerContextGenerator mContextGenerator;

    public DocumentCategorizerEventStream(ObjectStream<DocumentSample> data, FeatureGenerator ... featureGenerators) {
        super(data);
        this.mContextGenerator = new DocumentCategorizerContextGenerator(featureGenerators);
    }

    public DocumentCategorizerEventStream(ObjectStream<DocumentSample> samples) {
        super(samples);
        this.mContextGenerator = new DocumentCategorizerContextGenerator(new BagOfWordsFeatureGenerator());
    }

    @Override
    protected Iterator<Event> createEvents(final DocumentSample sample) {
        return new Iterator<Event>(){
            private boolean isVirgin = true;

            @Override
            public boolean hasNext() {
                return this.isVirgin;
            }

            @Override
            public Event next() {
                this.isVirgin = false;
                return new Event(sample.getCategory(), DocumentCategorizerEventStream.this.mContextGenerator.getContext(sample.getText()));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

