/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.spanish;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.model.MaxentModel;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.util.Span;

public class TokenChunker {
    private NameFinderME nameFinder;

    public TokenChunker(String modelName) throws IOException {
        this.nameFinder = new NameFinderME((MaxentModel)new SuffixSensitiveGISModelReader(new File(modelName)).getModel());
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: java opennlp.tools.spanish.TokenChunker model < tokenized_sentences");
            System.exit(1);
        }
        TokenChunker chunker = new TokenChunker(args[0]);
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in, "ISO-8859-1"));
        PrintStream out = new PrintStream((OutputStream)System.out, true, "ISO-8859-1");
        String line = inReader.readLine();
        while (line != null) {
            if (line.equals("")) {
                out.println();
            } else {
                String[] tokens = line.split(" ");
                Span[] spans = chunker.nameFinder.find(tokens);
                String[] outcomes = NameFinderEventStream.generateOutcomes(spans, null, tokens.length);
                int cn = outcomes.length;
                for (int ci = 0; ci < cn; ++ci) {
                    if (ci == 0) {
                        out.print(tokens[ci]);
                        continue;
                    }
                    if (outcomes[ci].equals("cont")) {
                        out.print("_" + tokens[ci]);
                        continue;
                    }
                    out.print(" " + tokens[ci]);
                }
                out.println();
            }
            line = inReader.readLine();
        }
    }
}

