/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.IOException;
import java.util.List;
import opennlp.tools.formats.masc.MascDocument;
import opennlp.tools.formats.masc.MascSentence;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class MascNamedEntitySampleStream
extends FilterObjectStream<MascDocument, NameSample> {
    MascDocument buffer;

    public MascNamedEntitySampleStream(ObjectStream<MascDocument> samples) throws IOException {
        super(samples);
        try {
            do {
                this.buffer = samples.read();
            } while (!this.buffer.hasNamedEntities());
        }
        catch (Exception e) {
            throw new IOException("None of the documents has named entity labels" + e.getMessage());
        }
    }

    @Override
    public NameSample read() throws IOException {
        try {
            MascSentence sentence = this.buffer.read();
            while (sentence == null) {
                this.buffer = (MascDocument)this.samples.read();
                if (this.buffer == null) {
                    return null;
                }
                if (!this.buffer.hasNamedEntities()) continue;
                sentence = this.buffer.read();
            }
            List<String> tokens = sentence.getTokenStrings();
            String[] tokensArray = new String[tokens.size()];
            tokens.toArray(tokensArray);
            List<Span> namedEntities = sentence.getNamedEntities();
            Span[] namedEntitiesArray = new Span[namedEntities.size()];
            namedEntities.toArray(namedEntitiesArray);
            return new NameSample(tokensArray, namedEntitiesArray, true);
        }
        catch (IOException e) {
            throw new IOException("Could not get a sample of named entities from the data.");
        }
    }

    @Override
    public void close() throws IOException {
        this.samples.close();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.samples.reset();
        this.buffer = (MascDocument)this.samples.read();
    }
}

