/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.FileFilter;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.masc.MascDocumentStream;
import opennlp.tools.formats.masc.MascSentenceSampleStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;

public class MascSentenceSampleStreamFactory
extends AbstractSampleStreamFactory<SentenceSample> {
    public static final String MASC_FORMAT = "masc";

    protected <P> MascSentenceSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, MASC_FORMAT, new MascSentenceSampleStreamFactory(Parameters.class));
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        try {
            FileFilter fileFilter = pathname -> pathname.getName().contains(params.getFileFilter());
            return new MascSentenceSampleStream(new MascDocumentStream(params.getData(), params.getRecurrentSearch(), fileFilter), Integer.parseInt(params.getSentencesPerSample()));
        }
        catch (IOException e) {
            CmdLineUtil.handleCreateObjectStreamError(e);
            return null;
        }
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="sentencesPerSample", description="number of sentences per sample")
        public String getSentencesPerSample();

        @ArgumentParser.ParameterDescription(valueName="recurrentSearch", description="search through files recursively")
        public boolean getRecurrentSearch();

        @ArgumentParser.ParameterDescription(valueName="fileFilterString", description="only include files which contain a given string in their name")
        public String getFileFilter();
    }
}

