/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.InsufficientTrainingDataException;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractDataIndexer
implements DataIndexer {
    public static final String CUTOFF_PARAM = "Cutoff";
    public static final int CUTOFF_DEFAULT = 5;
    public static final String SORT_PARAM = "sort";
    public static final boolean SORT_DEFAULT = true;
    protected TrainingParameters trainingParameters;
    protected Map<String, String> reportMap;
    protected boolean printMessages;
    private int numEvents;
    protected int[][] contexts;
    protected int[] outcomeList;
    protected int[] numTimesEventsSeen;
    protected String[] predLabels;
    protected String[] outcomeLabels;
    protected int[] predCounts;

    @Override
    public void init(TrainingParameters indexingParameters, Map<String, String> reportMap) {
        this.reportMap = reportMap;
        if (this.reportMap == null) {
            reportMap = new HashMap<String, String>();
        }
        this.trainingParameters = indexingParameters;
        this.printMessages = this.trainingParameters.getBooleanParameter("PrintMessages", true);
    }

    @Override
    public int[][] getContexts() {
        return this.contexts;
    }

    @Override
    public int[] getNumTimesEventsSeen() {
        return this.numTimesEventsSeen;
    }

    @Override
    public int[] getOutcomeList() {
        return this.outcomeList;
    }

    @Override
    public String[] getPredLabels() {
        return this.predLabels;
    }

    @Override
    public String[] getOutcomeLabels() {
        return this.outcomeLabels;
    }

    @Override
    public int[] getPredCounts() {
        return this.predCounts;
    }

    @Override
    public int getNumEvents() {
        return this.numEvents;
    }

    protected int sortAndMerge(List<ComparableEvent> eventsToCompare, boolean sort) throws InsufficientTrainingDataException {
        int numUniqueEvents = 1;
        this.numEvents = eventsToCompare.size();
        if (sort && eventsToCompare.size() > 0) {
            Collections.sort(eventsToCompare);
            ComparableEvent ce = eventsToCompare.get(0);
            for (int i = 1; i < this.numEvents; ++i) {
                ComparableEvent ce2 = eventsToCompare.get(i);
                if (ce.compareTo(ce2) == 0) {
                    ++ce.seen;
                    eventsToCompare.set(i, null);
                    continue;
                }
                ce = ce2;
                ++numUniqueEvents;
            }
        } else {
            numUniqueEvents = eventsToCompare.size();
        }
        if (numUniqueEvents == 0) {
            throw new InsufficientTrainingDataException("Insufficient training data to create model.");
        }
        if (sort) {
            this.display("done. Reduced " + this.numEvents + " events to " + numUniqueEvents + ".\n");
        }
        this.contexts = new int[numUniqueEvents][];
        this.outcomeList = new int[numUniqueEvents];
        this.numTimesEventsSeen = new int[numUniqueEvents];
        int j = 0;
        for (int i = 0; i < this.numEvents; ++i) {
            ComparableEvent evt = eventsToCompare.get(i);
            if (null == evt) continue;
            this.numTimesEventsSeen[j] = evt.seen;
            this.outcomeList[j] = evt.outcome;
            this.contexts[j] = evt.predIndexes;
            ++j;
        }
        return numUniqueEvents;
    }

    protected List<ComparableEvent> index(ObjectStream<Event> events, Map<String, Integer> predicateIndex) throws IOException {
        Event ev;
        HashMap<String, Integer> omap = new HashMap<String, Integer>();
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>();
        while ((ev = events.read()) != null) {
            omap.putIfAbsent(ev.getOutcome(), omap.size());
            int[] cons = Arrays.stream(ev.getContext()).map(predicateIndex::get).filter(Objects::nonNull).mapToInt(i -> i).toArray();
            if (cons.length > 0) {
                int ocID = (Integer)omap.get(ev.getOutcome());
                eventsToCompare.add(new ComparableEvent(ocID, cons, ev.getValues()));
                continue;
            }
            this.display("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()) + "\n");
        }
        this.outcomeLabels = AbstractDataIndexer.toIndexedStringArray(omap);
        this.predLabels = AbstractDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }

    protected static void update(String[] ec, Map<String, Integer> counter) {
        for (String s : ec) {
            counter.merge(s, 1, (value, one) -> value + one);
        }
    }

    protected static String[] toIndexedStringArray(Map<String, Integer> labelToIndexMap) {
        return (String[])labelToIndexMap.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).toArray(String[]::new);
    }

    @Override
    public float[][] getValues() {
        return null;
    }

    protected void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }
}

