/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.util.ArrayList;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.util.Span;

public class NewlineSentenceDetector
implements SentenceDetector {
    @Override
    public String[] sentDetect(CharSequence s) {
        return Span.spansToStrings(this.sentPosDetect(s), s);
    }

    @Override
    public Span[] sentPosDetect(CharSequence s) {
        Span span;
        ArrayList<Span> sentences = new ArrayList<Span>();
        int start = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\n' && c != '\r' || i - start <= 0) continue;
            Span span2 = new Span(start, i).trim(s);
            if (span2.length() > 0) {
                sentences.add(span2);
            }
            start = i + 1;
        }
        if (s.length() - start > 0 && (span = new Span(start, s.length()).trim(s)).length() > 0) {
            sentences.add(span);
        }
        return sentences.toArray(new Span[sentences.size()]);
    }
}

