/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ADSentenceStream
extends FilterObjectStream<String, Sentence> {
    private static final Pattern SENT_START = Pattern.compile("<s[^>]*>");
    private static final Pattern SENT_END = Pattern.compile("</s>");
    private static final Pattern EXT_END = Pattern.compile("</ext>");
    private static final Pattern TITLE_START = Pattern.compile("<t[^>]*>");
    private static final Pattern TITLE_END = Pattern.compile("</t>");
    private static final Pattern BOX_START = Pattern.compile("<caixa[^>]*>");
    private static final Pattern BOX_END = Pattern.compile("</caixa>");
    private static final Pattern PARA_START = Pattern.compile("<p[^>]*>");
    private static final Pattern TEXT_START = Pattern.compile("<ext[^>]*>");
    private final SentenceParser parser = new SentenceParser();
    private int paraID = 0;
    private boolean isTitle = false;
    private boolean isBox = false;

    public ADSentenceStream(ObjectStream<String> lineStream) {
        super(lineStream);
    }

    @Override
    public Sentence read() throws IOException {
        block20: {
            StringBuilder sentence = new StringBuilder();
            boolean sentenceStarted = false;
            while (true) {
                String line;
                if ((line = (String)this.samples.read()) != null) {
                    if (sentenceStarted) {
                        if (SENT_END.matcher(line).matches() || EXT_END.matcher(line).matches()) {
                            sentenceStarted = false;
                        } else if (!line.startsWith("A1")) {
                            sentence.append(line).append('\n');
                        }
                    } else if (SENT_START.matcher(line).matches()) {
                        sentenceStarted = true;
                    } else if (PARA_START.matcher(line).matches()) {
                        ++this.paraID;
                    } else if (TITLE_START.matcher(line).matches()) {
                        this.isTitle = true;
                    } else if (TITLE_END.matcher(line).matches()) {
                        this.isTitle = false;
                    } else if (TEXT_START.matcher(line).matches()) {
                        this.paraID = 0;
                    } else if (BOX_START.matcher(line).matches()) {
                        this.isBox = true;
                    } else if (BOX_END.matcher(line).matches()) {
                        this.isBox = false;
                    }
                    if (sentenceStarted || sentence.length() <= 0) continue;
                    return this.parser.parse(sentence.toString(), this.paraID, this.isTitle, this.isBox);
                }
                if (!sentenceStarted) break block20;
                if (sentence.length() > 0) break;
            }
            return this.parser.parse(sentence.toString(), this.paraID, this.isTitle, this.isBox);
        }
        return null;
    }

    public static class SentenceParser {
        private static final Logger logger = LoggerFactory.getLogger(SentenceParser.class);
        private static final Pattern NODE_PATTERN = Pattern.compile("([=-]*)([^:=]+:[^\\(\\s]+)(\\(([^\\)]+)\\))?\\s*(?:(\\((<.+>)\\))*)\\s*$");
        private static final Pattern LEAF_PATTERN = Pattern.compile("^([=-]*)([^:=]+):([^\\(\\s]+)\\([\"'](.+)[\"']\\s*((?:<.+>)*)\\s*([^\\)]+)?\\)\\s+(.+)");
        private static final Pattern BIZARRE_LEAF_PATTERN = Pattern.compile("^([=-]*)([^:=]+=[^\\(\\s]+)\\(([\"'].+[\"'])?\\s*([^\\)]+)?\\)\\s+(.+)");
        private static final Pattern PUNCTUATION_PATTERN = Pattern.compile("^(=*)(\\W+)$");
        private static final Pattern PUNCTUATION_DOT_PATTERN = Pattern.compile("\\\u00bb\\s+\\.");
        private static final Pattern PUNCTUATION_COMMA_PATTERN = Pattern.compile("\\\u00bb\\s+\\,");
        private String text;
        private String meta;

        /*
         * Enabled aggressive exception aggregation
         */
        public Sentence parse(String sentenceString, int para, boolean isTitle, boolean isBox) {
            Sentence sentence = new Sentence();
            Node root = new Node();
            try (BufferedReader reader = new BufferedReader(new StringReader(sentenceString));){
                Object titleTag;
                String line = reader.readLine();
                boolean useSameTextAndMeta = false;
                while (!line.startsWith("SOURCE")) {
                    if (line.equals("&&")) {
                        useSameTextAndMeta = true;
                        break;
                    }
                    line = reader.readLine();
                    if (line != null) continue;
                    Sentence sentence2 = null;
                    return sentence2;
                }
                if (!useSameTextAndMeta) {
                    String metaFromSource = line.substring(7);
                    line = reader.readLine();
                    int start = line.indexOf(" ");
                    this.text = line.substring(start + 1).trim();
                    this.text = this.fixPunctuation(this.text);
                    titleTag = "";
                    if (isTitle) {
                        titleTag = " title";
                    }
                    String boxTag = "";
                    if (isBox) {
                        boxTag = " box";
                    }
                    if (start > 0) {
                        this.meta = line.substring(0, start) + " p=" + para + (String)titleTag + boxTag + metaFromSource;
                    }
                }
                sentence.setText(this.text);
                sentence.setMetadata(this.meta);
                line = reader.readLine();
                while (line != null && line.startsWith("###")) {
                    line = reader.readLine();
                }
                Stack<Node> nodeStack = new Stack<Node>();
                root.setSyntacticTag("ROOT");
                root.setLevel(0);
                nodeStack.add(root);
                while (line != null && line.length() != 0 && !line.startsWith("</s>") && !line.equals("&&")) {
                    TreeElement element = this.getElement(line);
                    if (element != null) {
                        while (!nodeStack.isEmpty() && element.getLevel() > 0 && element.getLevel() <= ((Node)nodeStack.peek()).getLevel()) {
                            titleTag = (Node)nodeStack.pop();
                        }
                        if (element.isLeaf()) {
                            if (nodeStack.isEmpty()) {
                                root.addElement(element);
                            } else {
                                Node peek = (Node)nodeStack.peek();
                                if (element.level == 0) {
                                    ((Node)nodeStack.firstElement()).addElement(element);
                                } else {
                                    Node parent = null;
                                    int index = nodeStack.size() - 1;
                                    while (parent == null) {
                                        if (peek.getLevel() < element.getLevel()) {
                                            parent = peek;
                                            continue;
                                        }
                                        if (--index > -1) {
                                            peek = (Node)nodeStack.get(index);
                                            continue;
                                        }
                                        parent = (Node)nodeStack.firstElement();
                                    }
                                    parent.addElement(element);
                                }
                            }
                        } else {
                            if (!nodeStack.isEmpty() && ((Node)nodeStack.peek()).getLevel() < element.getLevel()) {
                                ((Node)nodeStack.peek()).addElement(element);
                            } else {
                                logger.warn("should not happen!");
                            }
                            nodeStack.push((Node)element);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                logger.warn("Caught exception for the given sentence: '{}'", (Object)sentenceString, (Object)e);
                return sentence;
            }
            sentence.setRoot(root);
            return sentence;
        }

        private String fixPunctuation(String text) {
            text = PUNCTUATION_DOT_PATTERN.matcher(text).replaceAll("\u00bb.");
            text = PUNCTUATION_COMMA_PATTERN.matcher(text).replaceAll("\u00bb,");
            return text;
        }

        public TreeElement getElement(String line) {
            Matcher nodeMatcher = NODE_PATTERN.matcher(line);
            if (nodeMatcher.matches()) {
                int level = nodeMatcher.group(1).length() + 1;
                String syntacticTag = nodeMatcher.group(2);
                Node node = new Node();
                node.setLevel(level);
                node.setSyntacticTag(syntacticTag);
                return node;
            }
            Matcher leafMatcher = LEAF_PATTERN.matcher(line);
            if (leafMatcher.matches()) {
                int level = leafMatcher.group(1).length() + 1;
                String syntacticTag = leafMatcher.group(2);
                String funcTag = leafMatcher.group(3);
                String lemma = leafMatcher.group(4);
                String secondaryTag = leafMatcher.group(5);
                String morphologicalTag = leafMatcher.group(6);
                String lexeme = leafMatcher.group(7);
                Leaf leaf = new Leaf();
                leaf.setLevel(level);
                leaf.setSyntacticTag(syntacticTag);
                leaf.setFunctionalTag(funcTag);
                leaf.setSecondaryTag(secondaryTag);
                leaf.setMorphologicalTag(morphologicalTag);
                leaf.setLexeme(lexeme);
                leaf.setLemma(lemma);
                return leaf;
            }
            Matcher punctuationMatcher = PUNCTUATION_PATTERN.matcher(line);
            if (punctuationMatcher.matches()) {
                int level = punctuationMatcher.group(1).length() + 1;
                String lexeme = punctuationMatcher.group(2);
                Leaf leaf = new Leaf();
                leaf.setLevel(level);
                leaf.setLexeme(lexeme);
                return leaf;
            }
            if (line.equals("_") || line.startsWith("<lixo") || line.startsWith("pause")) {
                return null;
            }
            if (line.startsWith("=")) {
                Matcher bizarreLeafMatcher = BIZARRE_LEAF_PATTERN.matcher(line);
                if (bizarreLeafMatcher.matches()) {
                    int level = bizarreLeafMatcher.group(1).length() + 1;
                    String syntacticTag = bizarreLeafMatcher.group(2);
                    String lemma = bizarreLeafMatcher.group(3);
                    String morphologicalTag = bizarreLeafMatcher.group(4);
                    String lexeme = bizarreLeafMatcher.group(5);
                    Leaf leaf = new Leaf();
                    leaf.setLevel(level);
                    leaf.setSyntacticTag(syntacticTag);
                    leaf.setMorphologicalTag(morphologicalTag);
                    leaf.setLexeme(lexeme);
                    if (lemma != null) {
                        if (lemma.length() > 2) {
                            lemma = lemma.substring(1, lemma.length() - 1);
                        }
                        leaf.setLemma(lemma);
                    }
                    return leaf;
                }
                int level = line.lastIndexOf("=") + 1;
                String lexeme = line.substring(level + 1);
                if (lexeme.matches("\\w.*?[\\.<>].*")) {
                    return null;
                }
                Leaf leaf = new Leaf();
                leaf.setLevel(level + 1);
                leaf.setSyntacticTag("");
                leaf.setMorphologicalTag("");
                leaf.setFunctionalTag("");
                leaf.setLexeme(lexeme);
                return leaf;
            }
            logger.warn("Couldn't parse leaf: {}", (Object)line);
            Leaf leaf = new Leaf();
            leaf.setLevel(1);
            leaf.setSyntacticTag("");
            leaf.setMorphologicalTag("");
            leaf.setFunctionalTag("");
            leaf.setLexeme(line);
            return leaf;
        }

        public static class Node
        extends TreeElement {
            private final List<TreeElement> elems = new ArrayList<TreeElement>();

            public void addElement(TreeElement element) {
                this.elems.add(element);
            }

            public TreeElement[] getElements() {
                return this.elems.toArray(new TreeElement[0]);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("=".repeat(Math.max(0, this.getLevel())));
                sb.append(this.getSyntacticTag());
                if (this.getMorphologicalTag() != null) {
                    sb.append(this.getMorphologicalTag());
                }
                sb.append("\n");
                for (TreeElement element : this.elems) {
                    sb.append(element.toString());
                }
                return sb.toString();
            }
        }

        public static abstract class TreeElement {
            private String syntacticTag;
            private String morphologicalTag;
            private int level;

            public boolean isLeaf() {
                return false;
            }

            public void setSyntacticTag(String syntacticTag) {
                this.syntacticTag = syntacticTag;
            }

            public String getSyntacticTag() {
                return this.syntacticTag;
            }

            public void setLevel(int level) {
                this.level = level;
            }

            public int getLevel() {
                return this.level;
            }

            public void setMorphologicalTag(String morphologicalTag) {
                this.morphologicalTag = morphologicalTag;
            }

            public String getMorphologicalTag() {
                return this.morphologicalTag;
            }
        }

        public static class Leaf
        extends TreeElement {
            private String word;
            private String lemma;
            private String secondaryTag;
            private String functionalTag;

            @Override
            public boolean isLeaf() {
                return true;
            }

            public void setFunctionalTag(String funcTag) {
                this.functionalTag = funcTag;
            }

            public String getFunctionalTag() {
                return this.functionalTag;
            }

            public void setSecondaryTag(String secondaryTag) {
                this.secondaryTag = secondaryTag;
            }

            public String getSecondaryTag() {
                return this.secondaryTag;
            }

            public void setLexeme(String lexeme) {
                this.word = lexeme;
            }

            public String getLexeme() {
                return this.word;
            }

            private String emptyOrString(String value, String prefix, String suffix) {
                if (value == null) {
                    return "";
                }
                return prefix + value + suffix;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                sb.append("=".repeat(Math.max(0, this.getLevel())));
                if (this.getSyntacticTag() != null) {
                    sb.append(this.getSyntacticTag()).append(":").append(this.getFunctionalTag()).append("(").append(this.emptyOrString(this.getLemma(), "'", "' ")).append(this.emptyOrString(this.getSecondaryTag(), "", " ")).append(this.getMorphologicalTag()).append(") ");
                }
                sb.append(this.word).append("\n");
                return sb.toString();
            }

            public void setLemma(String lemma) {
                this.lemma = lemma;
            }

            public String getLemma() {
                return this.lemma;
            }
        }
    }

    public static class Sentence {
        private String text;
        private SentenceParser.Node root;
        private String metadata;
        public static final String META_LABEL_FINAL = "final";

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public SentenceParser.Node getRoot() {
            return this.root;
        }

        public void setRoot(SentenceParser.Node root) {
            this.root = root;
        }

        public void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        public String getMetadata() {
            return this.metadata;
        }
    }
}

