/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import net.hydromatic.optiq.AggregateFunction;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.ImplementableAggFunction;
import net.hydromatic.optiq.impl.ReflectiveFunctionBase;
import net.hydromatic.optiq.rules.java.AggImplementor;
import net.hydromatic.optiq.rules.java.RexImpTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.util.Static;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateFunctionImpl
implements AggregateFunction,
ImplementableAggFunction {
    public final boolean isStatic;
    public final Method initMethod;
    public final Method addMethod;
    public final Method mergeMethod;
    public final Method resultMethod;
    public final ImmutableList<Class<?>> valueTypes;
    private final List<FunctionParameter> parameters;
    public final Class<?> accumulatorType;
    public final Class<?> resultType;
    public final Class<?> declaringClass;

    private AggregateFunctionImpl(Class<?> declaringClass, List<Class<?>> valueTypes, Class<?> accumulatorType, Class<?> resultType, Method initMethod, Method addMethod, Method mergeMethod, Method resultMethod) {
        this.declaringClass = declaringClass;
        this.isStatic = Modifier.isStatic(initMethod.getModifiers());
        this.valueTypes = ImmutableList.copyOf(valueTypes);
        this.parameters = ReflectiveFunctionBase.toFunctionParameters(valueTypes);
        this.accumulatorType = accumulatorType;
        this.resultType = resultType;
        this.initMethod = initMethod;
        this.addMethod = addMethod;
        this.mergeMethod = mergeMethod;
        this.resultMethod = resultMethod;
        assert (initMethod != null);
        assert (addMethod != null);
        assert (resultMethod != null || accumulatorType == resultType);
    }

    public static AggregateFunction create(Class<?> clazz) {
        Method initMethod = ReflectiveFunctionBase.findMethod(clazz, "init");
        Method addMethod = ReflectiveFunctionBase.findMethod(clazz, "add");
        Method mergeMethod = null;
        Method resultMethod = ReflectiveFunctionBase.findMethod(clazz, "result");
        if (initMethod != null && addMethod != null) {
            Class<?> accumulatorType = initMethod.getReturnType();
            Class<?> resultType = resultMethod != null ? resultMethod.getReturnType() : accumulatorType;
            ImmutableList addParamTypes = ImmutableList.copyOf((Object[])addMethod.getParameterTypes());
            if (addParamTypes.isEmpty() || addParamTypes.get(0) != accumulatorType) {
                throw Static.RESOURCE.firstParameterOfAdd(clazz.getName()).ex();
            }
            List<Class<?>> valueTypes = Util.skip(addParamTypes, 1);
            return new AggregateFunctionImpl(clazz, valueTypes, accumulatorType, resultType, initMethod, addMethod, mergeMethod, resultMethod);
        }
        return null;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.resultType);
    }

    @Override
    public AggImplementor getImplementor(boolean windowContext) {
        return new RexImpTable.UserDefinedAggReflectiveImplementor(this);
    }
}

