/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.AbstractTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTable
extends AbstractTable {
    public final ImmutableList<Table> tables;
    public ImmutableIntList fieldCounts;

    public StarTable(List<Table> tables) {
        this.tables = ImmutableList.copyOf(tables);
    }

    public static StarTable of(List<Table> tables) {
        return new StarTable(tables);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Integer> fieldCounts = new ArrayList<Integer>();
        for (Table table : this.tables) {
            RelDataType rowType = table.getRowType(typeFactory);
            typeList.addAll(RelOptUtil.getFieldTypeList(rowType));
            nameList.addAll(rowType.getFieldNames());
            fieldCounts.add(rowType.getFieldCount());
        }
        if (this.fieldCounts == null) {
            this.fieldCounts = ImmutableIntList.copyOf(fieldCounts);
        }
        return typeFactory.createStructType(typeList, SqlValidatorUtil.uniquify(nameList));
    }

    public StarTable add(Table table) {
        ArrayList<Table> tables1 = new ArrayList<Table>((Collection<Table>)this.tables);
        tables1.add(table);
        return StarTable.of(tables1);
    }

    public int columnOffset(Table table) {
        int n = 0;
        for (Pair<Table, Integer> pair : Pair.zip(this.tables, this.fieldCounts)) {
            if (pair.left == table) {
                return n;
            }
            n += ((Integer)pair.right).intValue();
        }
        throw new IllegalArgumentException("star table " + this + " does not contain table " + table);
    }
}

