/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.jdbc;

import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.sql.DataSource;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.linq4j.function.Function1;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.util.IntList;
import org.eigenbase.util.Pair;

final class JdbcUtils {
    private JdbcUtils() {
        throw new AssertionError((Object)"no instances!");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectArrayRowBuilder
    implements Function0<Object[]> {
        private final ResultSet resultSet;
        private final int columnCount;
        private final Primitive[] primitives;
        private final int[] types;

        public ObjectArrayRowBuilder(ResultSet resultSet, Primitive[] primitives, int[] types) throws SQLException {
            this.resultSet = resultSet;
            this.primitives = primitives;
            this.types = types;
            this.columnCount = resultSet.getMetaData().getColumnCount();
        }

        public static Function1<ResultSet, Function0<Object[]>> factory(final List<Pair<Primitive, Integer>> list) {
            return new Function1<ResultSet, Function0<Object[]>>(){

                public Function0<Object[]> apply(ResultSet resultSet) {
                    try {
                        return new ObjectArrayRowBuilder(resultSet, Pair.left(list).toArray(new Primitive[list.size()]), IntList.toArray(Pair.right(list)));
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        public Object[] apply() {
            try {
                Object[] values = new Object[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    values[i] = this.value(i);
                }
                return values;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        private Object value(int i) throws SQLException {
            switch (this.types[i]) {
                case 93: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getTimestamp(i + 1));
                }
                case 92: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getTime(i + 1));
                }
                case 91: {
                    return ObjectArrayRowBuilder.shift(this.resultSet.getDate(i + 1));
                }
            }
            return this.primitives[i].jdbcGet(this.resultSet, i + 1);
        }

        private static Timestamp shift(Timestamp v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Timestamp(time + (long)offset);
        }

        private static Time shift(Time v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Time((time + (long)offset) % 86400000L);
        }

        private static Date shift(Date v) {
            if (v == null) {
                return null;
            }
            long time = v.getTime();
            int offset = TimeZone.getDefault().getOffset(time);
            return new Date(time + (long)offset);
        }
    }

    public static class DialectPool {
        final Map<List, SqlDialect> map = new HashMap<List, SqlDialect>();
        public static final DialectPool INSTANCE = new DialectPool();

        SqlDialect get(DataSource dataSource) {
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                String productName = metaData.getDatabaseProductName();
                String productVersion = metaData.getDatabaseProductVersion();
                ImmutableList key = ImmutableList.of((Object)productName, (Object)productVersion);
                SqlDialect dialect = this.map.get(key);
                if (dialect == null) {
                    SqlDialect.DatabaseProduct product = SqlDialect.getProduct(productName, productVersion);
                    dialect = new SqlDialect(product, productName, metaData.getIdentifierQuoteString());
                    this.map.put((List)key, dialect);
                }
                connection.close();
                connection = null;
                SqlDialect sqlDialect = dialect;
                return sqlDialect;
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
    }
}

