/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.AvaticaResultSet;
import net.hydromatic.avatica.AvaticaStatement;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.avatica.Cursor;
import net.hydromatic.avatica.Meta;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.linq4j.function.Predicate1;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.Driver;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqConnectionImpl;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqResultSet;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.jdbc.OptiqStatement;
import net.hydromatic.optiq.runtime.AbstractCursor;
import net.hydromatic.optiq.runtime.EnumeratorCursor;
import net.hydromatic.optiq.runtime.FlatLists;
import net.hydromatic.optiq.runtime.RecordEnumeratorCursor;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlJdbcFunctionCall;
import org.eigenbase.sql.parser.SqlParser;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaImpl
implements Meta {
    private static final Map<Class, Pair<Integer, String>> MAP = ImmutableMap.builder().put(Boolean.TYPE, Pair.of(16, "BOOLEAN")).put(Boolean.class, Pair.of(16, "BOOLEAN")).put(Byte.TYPE, Pair.of(-6, "TINYINT")).put(Byte.class, Pair.of(-6, "TINYINT")).put(Short.TYPE, Pair.of(5, "SMALLINT")).put(Short.class, Pair.of(5, "SMALLINT")).put(Integer.TYPE, Pair.of(4, "INTEGER")).put(Integer.class, Pair.of(4, "INTEGER")).put(Long.TYPE, Pair.of(-5, "BIGINT")).put(Long.class, Pair.of(-5, "BIGINT")).put(Float.TYPE, Pair.of(6, "FLOAT")).put(Float.class, Pair.of(6, "FLOAT")).put(Double.TYPE, Pair.of(8, "DOUBLE")).put(Double.class, Pair.of(8, "DOUBLE")).put(String.class, Pair.of(12, "VARCHAR")).put(Date.class, Pair.of(91, "DATE")).put(Time.class, Pair.of(92, "TIME")).put(Timestamp.class, Pair.of(93, "TIMESTAMP")).build();
    static final Driver DRIVER = new Driver();
    final OptiqConnectionImpl connection;

    public MetaImpl(OptiqConnectionImpl connection) {
        this.connection = connection;
    }

    static <T extends Named> Predicate1<T> namedMatcher(Meta.Pat pattern) {
        if (pattern.s == null || pattern.s.equals("%")) {
            return Functions.truePredicate1();
        }
        final Pattern regex = MetaImpl.likeToRegex(pattern);
        return new Predicate1<T>(){

            public boolean apply(T v1) {
                return regex.matcher(v1.getName()).matches();
            }
        };
    }

    static Predicate1<String> matcher(Meta.Pat pattern) {
        if (pattern.s == null || pattern.s.equals("%")) {
            return Functions.truePredicate1();
        }
        final Pattern regex = MetaImpl.likeToRegex(pattern);
        return new Predicate1<String>(){

            public boolean apply(String v1) {
                return regex.matcher(v1).matches();
            }
        };
    }

    public static Pattern likeToRegex(Meta.Pat pattern) {
        StringBuilder buf = new StringBuilder("^");
        char[] charArray = pattern.s.toCharArray();
        int slash = -2;
        block6: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (slash == i - 1) {
                buf.append('[').append(c).append(']');
                continue;
            }
            switch (c) {
                case '\\': {
                    slash = i;
                    continue block6;
                }
                case '%': {
                    buf.append(".*");
                    continue block6;
                }
                case '[': {
                    buf.append("\\[");
                    continue block6;
                }
                case ']': {
                    buf.append("\\]");
                    continue block6;
                }
                default: {
                    buf.append('[').append(c).append(']');
                }
            }
        }
        buf.append("$");
        return Pattern.compile(buf.toString());
    }

    static ColumnMetaData columnMetaData(String name, int index, Class<?> type) {
        Pair<Integer, String> pair = MAP.get(type);
        ColumnMetaData.Rep rep = (ColumnMetaData.Rep)ColumnMetaData.Rep.VALUE_MAP.get(type);
        ColumnMetaData.ScalarType scalarType = ColumnMetaData.scalar((int)((Integer)pair.left), (String)((String)pair.right), (ColumnMetaData.Rep)rep);
        return new ColumnMetaData(index, false, true, false, false, Primitive.is(type) ? 1 : 0, true, -1, name, name, null, 0, 0, null, null, (ColumnMetaData.AvaticaType)scalarType, true, false, false, null);
    }

    static ColumnMetaData.StructType fieldMetaData(Class clazz) {
        ArrayList<ColumnMetaData> list = new ArrayList<ColumnMetaData>();
        for (Field field : clazz.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            list.add(MetaImpl.columnMetaData(Util.camelToUpper(field.getName()), list.size() + 1, field.getType()));
        }
        return ColumnMetaData.struct(list);
    }

    public static <E> ResultSet createEmptyResultSet(OptiqConnectionImpl connection, Class<E> clazz) {
        return MetaImpl.createResultSet(connection, MetaImpl.fieldMetaData(clazz), new RecordEnumeratorCursor<E>(Linq4j.emptyEnumerator(), clazz));
    }

    private static <E> ResultSet createResultSet(OptiqConnectionImpl connection, ColumnMetaData.StructType structType, final Cursor cursor) {
        try {
            AvaticaResultSet resultSet = connection.getFactory().newResultSet(connection.createStatement(), (AvaticaPrepareResult)new OptiqPrepare.PrepareResult<E>("", (List)ImmutableList.of(), null, structType, -1, null, Object.class){

                @Override
                public Cursor createCursor(DataContext dataContext) {
                    return cursor;
                }
            }, connection.getTimeZone());
            return OptiqConnectionImpl.TROJAN.execute(resultSet);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static ResultSet createResultSet(OptiqConnectionImpl connection, Enumerable<?> enumerable, NamedFieldGetter columnGetter) {
        return MetaImpl.createResultSet(connection, columnGetter.structType, columnGetter.cursor((Enumerator<Object>)enumerable.enumerator()));
    }

    public String getSqlKeywords() {
        return SqlParser.create("").getMetadata().getJdbcKeywords();
    }

    public String getNumericFunctions() {
        return SqlJdbcFunctionCall.getNumericFunctions();
    }

    public String getStringFunctions() {
        return SqlJdbcFunctionCall.getStringFunctions();
    }

    public String getSystemFunctions() {
        return SqlJdbcFunctionCall.getSystemFunctions();
    }

    public String getTimeDateFunctions() {
        return SqlJdbcFunctionCall.getTimeDateFunctions();
    }

    public ResultSet getTables(String catalog, Meta.Pat schemaPattern, final Meta.Pat tableNamePattern, final List<String> typeList) {
        Object typeFilter = typeList == null ? Functions.truePredicate1() : new Predicate1<MetaTable>(){

            public boolean apply(MetaTable v1) {
                return typeList.contains(v1.tableType);
            }
        };
        Predicate1 schemaMatcher = MetaImpl.namedMatcher(schemaPattern);
        return MetaImpl.createResultSet(this.connection, this.schemas(catalog).where(schemaMatcher).selectMany((Function1)new Function1<MetaSchema, Enumerable<MetaTable>>(){

            public Enumerable<MetaTable> apply(MetaSchema schema) {
                return MetaImpl.this.tables(schema, MetaImpl.matcher(tableNamePattern));
            }
        }).where(typeFilter), new NamedFieldGetter(MetaTable.class, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"));
    }

    public ResultSet getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        final Predicate1<String> tableNameMatcher = MetaImpl.matcher(tableNamePattern);
        Predicate1 schemaMatcher = MetaImpl.namedMatcher(schemaPattern);
        Predicate1 columnMatcher = MetaImpl.namedMatcher(columnNamePattern);
        return MetaImpl.createResultSet(this.connection, this.schemas(catalog).where(schemaMatcher).selectMany((Function1)new Function1<MetaSchema, Enumerable<MetaTable>>(){

            public Enumerable<MetaTable> apply(MetaSchema schema) {
                return MetaImpl.this.tables(schema, (Predicate1<String>)tableNameMatcher);
            }
        }).selectMany((Function1)new Function1<MetaTable, Enumerable<MetaColumn>>(){

            public Enumerable<MetaColumn> apply(MetaTable schema) {
                return MetaImpl.this.columns(schema);
            }
        }).where(columnMatcher), new NamedFieldGetter(MetaColumn.class, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"));
    }

    Enumerable<MetaCatalog> catalogs() {
        return Linq4j.asEnumerable((List)ImmutableList.of((Object)new MetaCatalog(this.connection.getCatalog())));
    }

    Enumerable<MetaTableType> tableTypes() {
        return Linq4j.asEnumerable((List)ImmutableList.of((Object)new MetaTableType("TABLE"), (Object)new MetaTableType("VIEW")));
    }

    Enumerable<MetaSchema> schemas(String catalog) {
        return Linq4j.asEnumerable(this.connection.rootSchema.getSubSchemaMap().values()).select((Function1)new Function1<OptiqSchema, MetaSchema>(){

            public MetaSchema apply(OptiqSchema optiqSchema) {
                return new MetaSchema(optiqSchema, MetaImpl.this.connection.getCatalog(), optiqSchema.getName());
            }
        }).orderBy((Function1)new Function1<MetaSchema, Comparable>(){

            public Comparable apply(MetaSchema metaSchema) {
                return (Comparable)((Object)FlatLists.of(Util.first(metaSchema.tableCatalog, ""), metaSchema.tableSchem));
            }
        });
    }

    Enumerable<MetaTable> tables(String catalog) {
        return this.schemas(catalog).selectMany((Function1)new Function1<MetaSchema, Enumerable<MetaTable>>(){

            public Enumerable<MetaTable> apply(MetaSchema schema) {
                return MetaImpl.this.tables(schema, (Predicate1<String>)Functions.truePredicate1());
            }
        });
    }

    Enumerable<MetaTable> tables(final MetaSchema schema) {
        return Linq4j.asEnumerable(schema.optiqSchema.getTableNames()).select((Function1)new Function1<String, MetaTable>(){

            public MetaTable apply(String name) {
                Table table = schema.optiqSchema.getTable(name, true).getValue();
                return new MetaTable(table, schema.tableCatalog, schema.tableSchem, name);
            }
        }).concat(Linq4j.asEnumerable(schema.optiqSchema.getTablesBasedOnNullaryFunctions().entrySet()).select((Function1)new Function1<Map.Entry<String, Table>, MetaTable>(){

            public MetaTable apply(Map.Entry<String, Table> pair) {
                Table table = pair.getValue();
                return new MetaTable(table, schema.tableCatalog, schema.tableSchem, pair.getKey());
            }
        }));
    }

    Enumerable<MetaTable> tables(MetaSchema schema, final Predicate1<String> matcher) {
        return this.tables(schema).where((Predicate1)new Predicate1<MetaTable>(){

            public boolean apply(MetaTable v1) {
                return matcher.apply((Object)v1.getName());
            }
        });
    }

    public Enumerable<MetaColumn> columns(final MetaTable table) {
        RelDataType rowType = table.optiqTable.getRowType(this.connection.typeFactory);
        return Linq4j.asEnumerable(rowType.getFieldList()).select((Function1)new Function1<RelDataTypeField, MetaColumn>(){

            public MetaColumn apply(RelDataTypeField field) {
                int precision = field.getType().getSqlTypeName().allowsPrec() && !(field.getType() instanceof RelDataTypeFactoryImpl.JavaType) ? field.getType().getPrecision() : -1;
                return new MetaColumn(table.tableCat, table.tableSchem, table.tableName, field.getName(), field.getType().getSqlTypeName().getJdbcOrdinal(), field.getType().getFullTypeString(), precision, field.getType().getSqlTypeName().allowsScale() ? Integer.valueOf(field.getType().getScale()) : null, 10, field.getType().isNullable() ? 1 : 0, precision, field.getIndex() + 1, field.getType().isNullable() ? "YES" : "NO");
            }
        });
    }

    public ResultSet getSchemas(String catalog, Meta.Pat schemaPattern) {
        Predicate1 schemaMatcher = MetaImpl.namedMatcher(schemaPattern);
        return MetaImpl.createResultSet(this.connection, this.schemas(catalog).where(schemaMatcher), new NamedFieldGetter(MetaSchema.class, "TABLE_SCHEM", "TABLE_CATALOG"));
    }

    public ResultSet getCatalogs() {
        return MetaImpl.createResultSet(this.connection, this.catalogs(), new NamedFieldGetter(MetaCatalog.class, "TABLE_CATALOG"));
    }

    public ResultSet getTableTypes() {
        return MetaImpl.createResultSet(this.connection, this.tableTypes(), new NamedFieldGetter(MetaTableType.class, "TABLE_TYPE"));
    }

    public ResultSet getProcedures(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaProcedure.class);
    }

    public ResultSet getProcedureColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern, Meta.Pat columnNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaProcedureColumn.class);
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, Meta.Pat columnNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaColumnPrivilege.class);
    }

    public ResultSet getTablePrivileges(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaTablePrivilege.class);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaBestRowIdentifier.class);
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaVersionColumn.class);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaPrimaryKey.class);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaImportedKey.class);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaExportedKey.class);
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaCrossReference.class);
    }

    public ResultSet getTypeInfo() {
        return MetaImpl.createEmptyResultSet(this.connection, MetaTypeInfo.class);
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaIndexInfo.class);
    }

    public ResultSet getUDTs(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, int[] types) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaUdt.class);
    }

    public ResultSet getSuperTypes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaSuperType.class);
    }

    public ResultSet getSuperTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaSuperTable.class);
    }

    public ResultSet getAttributes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, Meta.Pat attributeNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaAttribute.class);
    }

    public ResultSet getClientInfoProperties() {
        return MetaImpl.createEmptyResultSet(this.connection, MetaClientInfoProperty.class);
    }

    public ResultSet getFunctions(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaFunction.class);
    }

    public ResultSet getFunctionColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern, Meta.Pat columnNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaFunctionColumn.class);
    }

    public ResultSet getPseudoColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return MetaImpl.createEmptyResultSet(this.connection, MetaPseudoColumn.class);
    }

    public Cursor createCursor(AvaticaResultSet resultSet_) {
        OptiqResultSet resultSet = (OptiqResultSet)resultSet_;
        DataContext dataContext = this.connection.createDataContext(OptiqConnectionImpl.TROJAN.getParameterValues(resultSet.getStatement()));
        OptiqPrepare.PrepareResult prepareResult = resultSet.getPrepareResult();
        return prepareResult.createCursor(dataContext);
    }

    public AvaticaPrepareResult prepare(AvaticaStatement statement_, String sql) {
        OptiqStatement statement = (OptiqStatement)statement_;
        int maxRowCount = statement.getMaxRows();
        return this.connection.parseQuery(sql, statement.createPrepareContext(), maxRowCount <= 0 ? -1 : maxRowCount);
    }

    @VisibleForTesting
    public static DataContext createDataContext(OptiqConnection connection) {
        return ((OptiqConnectionImpl)connection).createDataContext((List<Object>)ImmutableList.of());
    }

    @VisibleForTesting
    public static OptiqConnection connect(OptiqRootSchema schema, JavaTypeFactory typeFactory) {
        return DRIVER.connect(schema, typeFactory);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class MetadataTable<E>
    extends AbstractQueryableTable {
        public MetadataTable(Class<E> clazz) {
            super(clazz);
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ((JavaTypeFactory)typeFactory).createType(this.elementType);
        }

        @Override
        public Schema.TableType getJdbcTableType() {
            return Schema.TableType.SYSTEM_TABLE;
        }

        @Override
        public Class<E> getElementType() {
            return (Class)this.elementType;
        }

        protected abstract Enumerator<E> enumerator(MetaImpl var1);

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

                public Enumerator<T> enumerator() {
                    return MetadataTable.this.enumerator(((OptiqConnectionImpl)this.queryProvider).meta());
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NamedFieldGetter {
        private final List<Field> fields = new ArrayList<Field>();
        private final ColumnMetaData.StructType structType;

        public NamedFieldGetter(Class clazz, String ... names) {
            ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
            NamedFieldGetter.init(clazz, names, columns, this.fields);
            this.structType = ColumnMetaData.struct(columns);
        }

        private static void init(Class clazz, String[] names, List<ColumnMetaData> columns, List<Field> fields) {
            for (String name : names) {
                Field field;
                int index = fields.size();
                String fieldName = Util.toCamelCase(name);
                try {
                    field = clazz.getField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                columns.add(MetaImpl.columnMetaData(name, index, field.getType()));
                fields.add(field);
            }
        }

        Object get(Object o, int columnIndex) {
            try {
                return this.fields.get(columnIndex).get(o);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Cursor cursor(Enumerator<Object> enumerator) {
            return new EnumeratorCursor(enumerator){

                protected AbstractCursor.Getter createGetter(final int ordinal) {
                    return new AbstractCursor.Getter(){

                        public Object getObject() {
                            return NamedFieldGetter.this.get(this.current(), ordinal);
                        }

                        public boolean wasNull() {
                            return this.getObject() == null;
                        }
                    };
                }
            };
        }
    }

    public static class MetaSuperTable {
    }

    public static class MetaPseudoColumn {
    }

    public static class MetaFunctionColumn {
    }

    public static class MetaFunction {
    }

    public static class MetaClientInfoProperty {
    }

    public static class MetaAttribute {
    }

    public static class MetaSuperType {
    }

    public static class MetaUdt {
    }

    public static class MetaIndexInfo {
    }

    public static class MetaTypeInfo {
    }

    public static class MetaCrossReference {
    }

    public static class MetaExportedKey {
    }

    public static class MetaImportedKey {
    }

    public static class MetaPrimaryKey {
        public final String tableCat;
        public final String tableSchem;
        public final String tableName;
        public final String columnName;
        public final short keySeq;
        public final String pkName;

        MetaPrimaryKey(String tableCat, String tableSchem, String tableName, String columnName, short keySeq, String pkName) {
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.keySeq = keySeq;
            this.pkName = pkName;
        }
    }

    public static class MetaVersionColumn {
        public final short scope;
        public final String columnName;
        public final int dataType;
        public final String typeName;
        public final int columnSize;
        public final int bufferLength;
        public final short decimalDigits;
        public final short pseudoColumn;

        MetaVersionColumn(short scope, String columnName, int dataType, String typeName, int columnSize, int bufferLength, short decimalDigits, short pseudoColumn) {
            this.scope = scope;
            this.columnName = columnName;
            this.dataType = dataType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.bufferLength = bufferLength;
            this.decimalDigits = decimalDigits;
            this.pseudoColumn = pseudoColumn;
        }
    }

    public static class MetaBestRowIdentifier {
    }

    public static class MetaTablePrivilege {
    }

    public static class MetaColumnPrivilege {
    }

    public static class MetaProcedureColumn {
    }

    public static class MetaProcedure {
    }

    public static class MetaTableType {
        public final String tableType;

        public MetaTableType(String tableType) {
            this.tableType = tableType;
        }
    }

    public static class MetaCatalog
    implements Named {
        public final String tableCatalog;

        public MetaCatalog(String tableCatalog) {
            this.tableCatalog = tableCatalog;
        }

        public String getName() {
            return this.tableCatalog;
        }
    }

    public static class MetaSchema
    implements Named {
        private final OptiqSchema optiqSchema;
        public final String tableCatalog;
        public final String tableSchem;

        public MetaSchema(OptiqSchema optiqSchema, String tableCatalog, String tableSchem) {
            this.optiqSchema = optiqSchema;
            this.tableCatalog = tableCatalog;
            this.tableSchem = tableSchem;
        }

        public String getName() {
            return this.tableSchem;
        }
    }

    public static class MetaTable
    implements Named {
        private final Table optiqTable;
        public final String tableCat;
        public final String tableSchem;
        public final String tableName;
        public final String tableType;
        public final String remarks;
        public final String typeCat;
        public final String typeSchem;
        public final String typeName;
        public final String selfReferencingColName;
        public final String refGeneration;

        public MetaTable(Table optiqTable, String tableCat, String tableSchem, String tableName) {
            this.remarks = null;
            this.typeCat = null;
            this.typeSchem = null;
            this.typeName = null;
            this.selfReferencingColName = null;
            this.refGeneration = null;
            this.optiqTable = optiqTable;
            assert (optiqTable != null);
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.tableType = optiqTable.getJdbcTableType().name();
        }

        public String getName() {
            return this.tableName;
        }
    }

    public static class MetaColumn
    implements Named {
        public final String tableCat;
        public final String tableSchem;
        public final String tableName;
        public final String columnName;
        public final int dataType;
        public final String typeName;
        public final int columnSize;
        public final String bufferLength;
        public final Integer decimalDigits;
        public final int numPrecRadix;
        public final int nullable;
        public final String remarks;
        public final String columnDef;
        public final String sqlDataType;
        public final String sqlDatetimeSub;
        public final int charOctetLength;
        public final int ordinalPosition;
        public final String isNullable;
        public final String scopeCatalog;
        public final String scopeTable;
        public final String sourceDataType;
        public final String isAutoincrement;
        public final String isGeneratedcolumn;

        MetaColumn(String tableCat, String tableSchem, String tableName, String columnName, int dataType, String typeName, int columnSize, Integer decimalDigits, int numPrecRadix, int nullable, int charOctetLength, int ordinalPosition, String isNullable) {
            this.bufferLength = null;
            this.remarks = null;
            this.columnDef = null;
            this.sqlDataType = null;
            this.sqlDatetimeSub = null;
            this.scopeCatalog = null;
            this.scopeTable = null;
            this.sourceDataType = null;
            this.isAutoincrement = null;
            this.isGeneratedcolumn = null;
            this.tableCat = tableCat;
            this.tableSchem = tableSchem;
            this.tableName = tableName;
            this.columnName = columnName;
            this.dataType = dataType;
            this.typeName = typeName;
            this.columnSize = columnSize;
            this.decimalDigits = decimalDigits;
            this.numPrecRadix = numPrecRadix;
            this.nullable = nullable;
            this.charOctetLength = charOctetLength;
            this.ordinalPosition = ordinalPosition;
            this.isNullable = isNullable;
        }

        public String getName() {
            return this.columnName;
        }
    }

    static interface Named {
        public String getName();
    }
}

