/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.collect.ImmutableList;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.TimeZone;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.AvaticaResultSet;
import net.hydromatic.avatica.AvaticaStatement;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.avatica.Cursor;
import net.hydromatic.avatica.Handler;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.optiq.jdbc.OptiqConnectionImpl;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.runtime.ArrayEnumeratorCursor;
import net.hydromatic.optiq.runtime.ObjectEnumeratorCursor;

public class OptiqResultSet
extends AvaticaResultSet {
    OptiqResultSet(AvaticaStatement statement, OptiqPrepare.PrepareResult prepareResult, ResultSetMetaData resultSetMetaData, TimeZone timeZone) {
        super(statement, (AvaticaPrepareResult)prepareResult, resultSetMetaData, timeZone);
    }

    protected OptiqResultSet execute() throws SQLException {
        OptiqConnectionImpl connection = this.getOptiqConnection();
        boolean autoTemp = connection.config().autoTemp();
        Handler.ResultSink resultSink = null;
        if (autoTemp) {
            resultSink = new Handler.ResultSink(){

                public void toBeCompleted() {
                }
            };
        }
        connection.getDriver().handler.onStatementExecute(this.statement, resultSink);
        super.execute();
        return this;
    }

    public ResultSet create(ColumnMetaData.AvaticaType elementType, Iterable iterable) {
        OptiqResultSet resultSet = new OptiqResultSet(this.statement, (OptiqPrepare.PrepareResult)this.prepareResult, this.resultSetMetaData, this.localCalendar.getTimeZone());
        Cursor cursor = resultSet.createCursor(elementType, iterable);
        List columnMetaDataList = elementType instanceof ColumnMetaData.StructType ? ((ColumnMetaData.StructType)elementType).columns : ImmutableList.of((Object)ColumnMetaData.dummy((ColumnMetaData.AvaticaType)elementType, (boolean)false));
        return resultSet.execute2(cursor, columnMetaDataList);
    }

    private Cursor createCursor(ColumnMetaData.AvaticaType elementType, Iterable iterable) {
        Enumerator enumerator = Linq4j.iterableEnumerator((Iterable)iterable);
        return !(elementType instanceof ColumnMetaData.StructType) || ((ColumnMetaData.StructType)elementType).columns.size() == 1 ? new ObjectEnumeratorCursor((Enumerator<Object>)enumerator) : new ArrayEnumeratorCursor((Enumerator<Object[]>)enumerator);
    }

    OptiqPrepare.PrepareResult getPrepareResult() {
        return (OptiqPrepare.PrepareResult)this.prepareResult;
    }

    OptiqConnectionImpl getOptiqConnection() {
        return (OptiqConnectionImpl)this.statement.getConnection();
    }
}

