/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.hydromatic.optiq.AggregateFunction;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.ScalarFunction;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaFactory;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableFactory;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.AggregateFunctionImpl;
import net.hydromatic.optiq.impl.MaterializedViewTable;
import net.hydromatic.optiq.impl.ScalarFunctionImpl;
import net.hydromatic.optiq.impl.StarTable;
import net.hydromatic.optiq.impl.TableFunctionImpl;
import net.hydromatic.optiq.impl.TableMacroImpl;
import net.hydromatic.optiq.impl.ViewTable;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.model.JsonCustomSchema;
import net.hydromatic.optiq.model.JsonCustomTable;
import net.hydromatic.optiq.model.JsonFunction;
import net.hydromatic.optiq.model.JsonJdbcSchema;
import net.hydromatic.optiq.model.JsonMapSchema;
import net.hydromatic.optiq.model.JsonMaterialization;
import net.hydromatic.optiq.model.JsonRoot;
import net.hydromatic.optiq.model.JsonSchema;
import net.hydromatic.optiq.model.JsonView;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Stacks;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelHandler {
    private final OptiqConnection connection;
    private final List<Pair<String, SchemaPlus>> schemaStack = new ArrayList<Pair<String, SchemaPlus>>();

    public ModelHandler(OptiqConnection connection, String uri) throws IOException {
        this.connection = connection;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        JsonRoot root = uri.startsWith("inline:") ? (JsonRoot)mapper.readValue(uri.substring("inline:".length()), JsonRoot.class) : (JsonRoot)mapper.readValue(new File(uri), JsonRoot.class);
        this.visit(root);
    }

    public static void create(SchemaPlus schema, String functionName, List<String> path, String className, String methodName) {
        AggregateFunction aggFunction;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("UDF class '" + className + "' not found");
        }
        TableFunction tableFunction = TableFunctionImpl.create(clazz);
        if (tableFunction != null) {
            schema.add(functionName, tableFunction);
            return;
        }
        TableMacro macro = TableMacroImpl.create(clazz);
        if (macro != null) {
            schema.add(functionName, macro);
            return;
        }
        if (methodName != null && methodName.equals("*")) {
            for (Map.Entry entry : ScalarFunctionImpl.createAll(clazz).entries()) {
                schema.add((String)entry.getKey(), (Function)entry.getValue());
            }
            return;
        }
        ScalarFunction function = ScalarFunctionImpl.create(clazz, Util.first(methodName, "eval"));
        if (function != null) {
            schema.add(Util.first(functionName, methodName), function);
            return;
        }
        if (methodName == null && (aggFunction = AggregateFunctionImpl.create(clazz)) != null) {
            schema.add(functionName, aggFunction);
            return;
        }
        throw new RuntimeException("Not a valid function class: " + clazz + ". Scalar functions and table macros have an 'eval' method; " + "aggregate functions have 'init' and 'add' methods, and optionally " + "'initAdd', 'merge' and 'result' methods.");
    }

    public void visit(JsonRoot root) {
        Pair<Object, SchemaPlus> pair = Pair.of(null, this.connection.getRootSchema());
        Stacks.push(this.schemaStack, pair);
        for (JsonSchema schema : root.schemas) {
            schema.accept(this);
        }
        Stacks.pop(this.schemaStack, pair);
        if (root.defaultSchema != null) {
            try {
                this.connection.setSchema(root.defaultSchema);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void visit(JsonMapSchema jsonSchema) {
        SchemaPlus parentSchema = this.currentMutableSchema("schema");
        SchemaPlus schema = parentSchema.add(jsonSchema.name, new AbstractSchema());
        if (jsonSchema.path != null) {
            schema.setPath(ModelHandler.stringListList(jsonSchema.path));
        }
        this.populateSchema(jsonSchema, schema);
        if (schema.getName().equals("mat")) {
            ArrayList<Table> tables = new ArrayList<Table>();
            String[] tableNames = new String[]{"sales_fact_1997", "time_by_day", "product", "product_class"};
            SchemaPlus schema2 = parentSchema.getSubSchema("foodmart");
            for (String tableName : tableNames) {
                tables.add(schema2.getTable(tableName));
            }
            String tableName = "star";
            schema.add("star", StarTable.of(tables));
        }
    }

    private static ImmutableList<ImmutableList<String>> stringListList(List path) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object s : path) {
            builder.add(ModelHandler.stringList(s));
        }
        return builder.build();
    }

    private static ImmutableList<String> stringList(Object s) {
        if (s instanceof String) {
            return ImmutableList.of((Object)((String)s));
        }
        if (s instanceof List) {
            ImmutableList.Builder builder2 = ImmutableList.builder();
            for (Object o : (List)s) {
                if (o instanceof String) {
                    builder2.add((Object)((String)o));
                    continue;
                }
                throw new RuntimeException("Invalid path element " + o + "; was expecting string");
            }
            return builder2.build();
        }
        throw new RuntimeException("Invalid path element " + s + "; was expecting string or list of string");
    }

    private void populateSchema(JsonSchema jsonSchema, SchemaPlus schema) {
        boolean cache = jsonSchema.cache == null || jsonSchema.cache != false;
        schema.setCacheEnabled(cache);
        Pair<String, SchemaPlus> pair = Pair.of(jsonSchema.name, schema);
        Stacks.push(this.schemaStack, pair);
        jsonSchema.visitChildren(this);
        Stacks.pop(this.schemaStack, pair);
    }

    public void visit(JsonCustomSchema jsonSchema) {
        try {
            SchemaPlus parentSchema = this.currentMutableSchema("sub-schema");
            Class<?> clazz = Class.forName(jsonSchema.factory);
            SchemaFactory schemaFactory = (SchemaFactory)clazz.newInstance();
            Schema schema = schemaFactory.create(parentSchema, jsonSchema.name, jsonSchema.operand);
            SchemaPlus optiqSchema = parentSchema.add(jsonSchema.name, schema);
            this.populateSchema(jsonSchema, optiqSchema);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonSchema, e);
        }
    }

    public void visit(JsonJdbcSchema jsonSchema) {
        SchemaPlus parentSchema = this.currentMutableSchema("jdbc schema");
        DataSource dataSource = JdbcSchema.dataSource(jsonSchema.jdbcUrl, jsonSchema.jdbcDriver, jsonSchema.jdbcUser, jsonSchema.jdbcPassword);
        JdbcSchema schema = JdbcSchema.create(parentSchema, jsonSchema.name, dataSource, jsonSchema.jdbcCatalog, jsonSchema.jdbcSchema);
        SchemaPlus optiqSchema = parentSchema.add(jsonSchema.name, schema);
        this.populateSchema(jsonSchema, optiqSchema);
    }

    public void visit(JsonMaterialization jsonMaterialization) {
        try {
            SchemaPlus schema = this.currentSchema();
            if (!schema.isMutable()) {
                throw new RuntimeException("Cannot define materialization; parent schema '" + this.currentSchemaName() + "' is not a SemiMutableSchema");
            }
            OptiqSchema optiqSchema = OptiqSchema.from(schema);
            schema.add(jsonMaterialization.view, MaterializedViewTable.create(optiqSchema, jsonMaterialization.sql, null, jsonMaterialization.table));
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonMaterialization, e);
        }
    }

    public void visit(JsonCustomTable jsonTable) {
        try {
            SchemaPlus schema = this.currentMutableSchema("table");
            Class<?> clazz = Class.forName(jsonTable.factory);
            TableFactory tableFactory = (TableFactory)clazz.newInstance();
            Object table = tableFactory.create(schema, jsonTable.name, jsonTable.operand, null);
            schema.add(jsonTable.name, (Table)table);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonTable, e);
        }
    }

    public void visit(JsonView jsonView) {
        try {
            SchemaPlus schema = this.currentMutableSchema("view");
            List<String> path = Util.first(jsonView.path, this.currentSchemaPath());
            schema.add(jsonView.name, ViewTable.viewMacro(schema, jsonView.sql, path));
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonView, e);
        }
    }

    private List<String> currentSchemaPath() {
        return Collections.singletonList(Stacks.peek(this.schemaStack).left);
    }

    private SchemaPlus currentSchema() {
        return (SchemaPlus)Stacks.peek(this.schemaStack).right;
    }

    private String currentSchemaName() {
        return (String)Stacks.peek(this.schemaStack).left;
    }

    private SchemaPlus currentMutableSchema(String elementType) {
        SchemaPlus schema = this.currentSchema();
        if (!schema.isMutable()) {
            throw new RuntimeException("Cannot define " + elementType + "; parent schema '" + schema.getName() + "' is not mutable");
        }
        return schema;
    }

    public void visit(JsonFunction jsonFunction) {
        try {
            SchemaPlus schema = this.currentMutableSchema("function");
            List<String> path = Util.first(jsonFunction.path, this.currentSchemaPath());
            ModelHandler.create(schema, jsonFunction.name, path, jsonFunction.className, jsonFunction.methodName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating " + jsonFunction, e);
        }
    }
}

