/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.prepare;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import net.hydromatic.optiq.AggregateFunction;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.ScalarFunction;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.prepare.RelOptTableImpl;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.type.SqlReturnTypeInference;
import org.eigenbase.sql.type.SqlTypeFamily;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlMoniker;
import org.eigenbase.sql.validate.SqlMonikerImpl;
import org.eigenbase.sql.validate.SqlMonikerType;
import org.eigenbase.sql.validate.SqlUserDefinedAggFunction;
import org.eigenbase.sql.validate.SqlUserDefinedFunction;
import org.eigenbase.sql.validate.SqlUserDefinedTableFunction;
import org.eigenbase.sql.validate.SqlUserDefinedTableMacro;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptiqCatalogReader
implements Prepare.CatalogReader,
SqlOperatorTable {
    final OptiqSchema rootSchema;
    final JavaTypeFactory typeFactory;
    private final List<String> defaultSchema;
    private final boolean caseSensitive;

    public OptiqCatalogReader(OptiqSchema rootSchema, boolean caseSensitive, List<String> defaultSchema, JavaTypeFactory typeFactory) {
        assert (rootSchema != defaultSchema);
        this.rootSchema = rootSchema;
        this.caseSensitive = caseSensitive;
        this.defaultSchema = defaultSchema;
        this.typeFactory = typeFactory;
    }

    @Override
    public OptiqCatalogReader withSchemaPath(List<String> schemaPath) {
        return new OptiqCatalogReader(this.rootSchema, this.caseSensitive, schemaPath, this.typeFactory);
    }

    @Override
    public RelOptTableImpl getTable(List<String> names) {
        RelOptTableImpl table;
        if (this.defaultSchema != null && (table = this.getTableFrom(names, this.defaultSchema)) != null) {
            return table;
        }
        return this.getTableFrom(names, (List<String>)ImmutableList.of());
    }

    private RelOptTableImpl getTableFrom(List<String> names, List<String> schemaNames) {
        OptiqSchema schema = this.getSchema(Iterables.concat(schemaNames, Util.skipLast(names)));
        if (schema == null) {
            return null;
        }
        String name = Util.last(names);
        Pair<String, Table> pair = schema.getTable(name, this.caseSensitive);
        if (pair == null) {
            pair = schema.getTableBasedOnNullaryFunction(name, this.caseSensitive);
        }
        if (pair != null) {
            Table table = pair.getValue();
            String name2 = pair.getKey();
            return RelOptTableImpl.create((RelOptSchema)this, table.getRowType(this.typeFactory), schema.add(name2, table));
        }
        return null;
    }

    private Collection<Function> getFunctionsFrom(List<String> names) {
        OptiqSchema schema;
        ArrayList functions2 = Lists.newArrayList();
        Object schemaNameList = names.size() > 1 ? ImmutableList.of((Object)ImmutableList.of()) : ((schema = this.getSchema(this.defaultSchema)) == null ? ImmutableList.of() : schema.getPath());
        for (List schemaNames : schemaNameList) {
            OptiqSchema schema2 = this.getSchema(Iterables.concat((Iterable)schemaNames, Util.skipLast(names)));
            if (schema2 == null) continue;
            String name = Util.last(names);
            functions2.addAll(schema2.getFunctions(name, true));
        }
        return functions2;
    }

    private OptiqSchema getSchema(Iterable<String> schemaNames) {
        OptiqSchema schema = this.rootSchema;
        for (String schemaName : schemaNames) {
            if ((schema = schema.getSubSchema(schemaName, this.caseSensitive)) != null) continue;
            return null;
        }
        return schema;
    }

    @Override
    public RelDataType getNamedType(SqlIdentifier typeName) {
        return null;
    }

    @Override
    public List<SqlMoniker> getAllSchemaObjectNames(List<String> names) {
        OptiqSchema schema = this.getSchema(names);
        if (schema == null) {
            return ImmutableList.of();
        }
        ArrayList<SqlMoniker> result = new ArrayList<SqlMoniker>();
        NavigableMap<String, OptiqSchema> schemaMap = schema.getSubSchemaMap();
        for (String subSchema : schemaMap.keySet()) {
            result.add(new SqlMonikerImpl(schema.path(subSchema), SqlMonikerType.SCHEMA));
        }
        for (String table : schema.getTableNames()) {
            result.add(new SqlMonikerImpl(schema.path(table), SqlMonikerType.TABLE));
        }
        NavigableSet<String> functions = schema.getFunctionNames();
        for (String function : functions) {
            result.add(new SqlMonikerImpl(schema.path(function), SqlMonikerType.FUNCTION));
        }
        return result;
    }

    @Override
    public List<String> getSchemaName() {
        return this.defaultSchema;
    }

    @Override
    public RelOptTableImpl getTableForMember(List<String> names) {
        return this.getTable((List)names);
    }

    @Override
    public RelDataTypeField field(RelDataType rowType, String alias) {
        return SqlValidatorUtil.lookupField(this.caseSensitive, rowType, alias);
    }

    @Override
    public int fieldOrdinal(RelDataType rowType, String alias) {
        RelDataTypeField field = this.field(rowType, alias);
        return field != null ? field.getIndex() : -1;
    }

    @Override
    public int match(List<String> strings, String name) {
        return Util.match2(strings, name, this.caseSensitive);
    }

    @Override
    public RelDataType createTypeFromProjection(RelDataType type, List<String> columnNameList) {
        return SqlValidatorUtil.createTypeFromProjection(type, columnNameList, this.typeFactory, this.caseSensitive);
    }

    @Override
    public void lookupOperatorOverloads(final SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        if (syntax != SqlSyntax.FUNCTION) {
            return;
        }
        Collection<Function> functions = this.getFunctionsFrom((List<String>)opName.names);
        if (functions.isEmpty()) {
            return;
        }
        operatorList.addAll(Collections2.transform(functions, (com.google.common.base.Function)new com.google.common.base.Function<Function, SqlOperator>(){

            public SqlOperator apply(Function function) {
                return OptiqCatalogReader.this.toOp(opName, function);
            }
        }));
    }

    private SqlOperator toOp(SqlIdentifier name, Function function) {
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        for (FunctionParameter o : function.getParameters()) {
            RelDataType type = o.getType(this.typeFactory);
            argTypes.add(type);
            typeFamilies.add(Util.first(type.getSqlTypeName().getFamily(), SqlTypeFamily.ANY));
        }
        if (function instanceof ScalarFunction) {
            return new SqlUserDefinedFunction(name, (SqlReturnTypeInference)ReturnTypes.explicit(Schemas.proto((ScalarFunction)function)), InferTypes.explicit(argTypes), (SqlOperandTypeChecker)OperandTypes.family(typeFamilies), this.toSql(argTypes), function);
        }
        if (function instanceof AggregateFunction) {
            RelDataType returnType = ((AggregateFunction)function).getReturnType(this.typeFactory);
            return new SqlUserDefinedAggFunction(name, ReturnTypes.explicit(returnType), InferTypes.explicit(argTypes), OperandTypes.family(typeFamilies), (AggregateFunction)function);
        }
        if (function instanceof TableMacro) {
            return new SqlUserDefinedTableMacro(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), OperandTypes.family(typeFamilies), (TableMacro)function);
        }
        if (function instanceof TableFunction) {
            return new SqlUserDefinedTableFunction(name, ReturnTypes.CURSOR, InferTypes.explicit(argTypes), (SqlOperandTypeChecker)OperandTypes.family(typeFamilies), this.toSql(argTypes), (TableFunction)function);
        }
        throw new AssertionError((Object)("unknown function type " + function));
    }

    private List<RelDataType> toSql(List<RelDataType> types) {
        return Lists.transform(types, (com.google.common.base.Function)new com.google.common.base.Function<RelDataType, RelDataType>(){

            public RelDataType apply(RelDataType input) {
                if (input instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)input).getJavaClass() == Object.class) {
                    return OptiqCatalogReader.this.typeFactory.createSqlType(SqlTypeName.ANY);
                }
                return OptiqCatalogReader.this.typeFactory.toSql(input);
            }
        });
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return null;
    }

    @Override
    public RelDataTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void registerRules(RelOptPlanner planner) throws Exception {
    }
}

