/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.rules.java;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.BinaryExpression;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.ConstantExpression;
import net.hydromatic.linq4j.expressions.DeclarationStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.ForStatement;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.MethodDeclaration;
import net.hydromatic.linq4j.expressions.NewExpression;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.function.Function0;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Function2;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.ModifiableTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.rules.java.AggContext;
import net.hydromatic.optiq.rules.java.AggImpState;
import net.hydromatic.optiq.rules.java.AggImplementor;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.EnumerableRelImplementor;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import net.hydromatic.optiq.rules.java.WinAggContext;
import net.hydromatic.optiq.rules.java.WinAggFrameResultContext;
import net.hydromatic.optiq.rules.java.WinAggImplementor;
import net.hydromatic.optiq.rules.java.impl.AggAddContextImpl;
import net.hydromatic.optiq.rules.java.impl.AggResultContextImpl;
import net.hydromatic.optiq.rules.java.impl.WinAggAddContextImpl;
import net.hydromatic.optiq.rules.java.impl.WinAggResetContextImpl;
import net.hydromatic.optiq.rules.java.impl.WinAggResultContextImpl;
import net.hydromatic.optiq.runtime.SortedMultiMap;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AbstractRelNode;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.Aggregation;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.CalcRelBase;
import org.eigenbase.rel.CollectRel;
import org.eigenbase.rel.EmptyRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.IntersectRelBase;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.JoinInfo;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.MinusRel;
import org.eigenbase.rel.MinusRelBase;
import org.eigenbase.rel.OneRowRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.TableFunctionRel;
import org.eigenbase.rel.TableFunctionRelBase;
import org.eigenbase.rel.TableModificationRel;
import org.eigenbase.rel.TableModificationRelBase;
import org.eigenbase.rel.UncollectRel;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.rel.ValuesRelBase;
import org.eigenbase.rel.WindowRel;
import org.eigenbase.rel.WindowRelBase;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.rel.metadata.RelColumnMapping;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.EquiJoinRel;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;
import org.eigenbase.rex.RexWindowBound;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

public class JavaRules {
    protected static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    public static final boolean BRIDGE_METHODS = true;
    private static final List<ParameterExpression> NO_PARAMS = Collections.emptyList();
    private static final List<Expression> NO_EXPRS = Collections.emptyList();
    public static final RelOptRule ENUMERABLE_JOIN_RULE = new EnumerableJoinRule();
    public static final RelOptRule ENUMERABLE_SEMI_JOIN_RULE = new EnumerableSemiJoinRule();
    public static final String[] LEFT_RIGHT = new String[]{"left", "right"};
    private static final boolean B = false;
    public static final EnumerableProjectRule ENUMERABLE_PROJECT_RULE = new EnumerableProjectRule();
    public static final EnumerableFilterRule ENUMERABLE_FILTER_RULE = new EnumerableFilterRule();
    public static final EnumerableCalcRule ENUMERABLE_CALC_RULE = new EnumerableCalcRule();
    public static final EnumerableAggregateRule ENUMERABLE_AGGREGATE_RULE = new EnumerableAggregateRule();
    public static final EnumerableSortRule ENUMERABLE_SORT_RULE = new EnumerableSortRule();
    public static final EnumerableLimitRule ENUMERABLE_LIMIT_RULE = new EnumerableLimitRule();
    public static final EnumerableUnionRule ENUMERABLE_UNION_RULE = new EnumerableUnionRule();
    public static final EnumerableIntersectRule ENUMERABLE_INTERSECT_RULE = new EnumerableIntersectRule();
    public static final EnumerableMinusRule ENUMERABLE_MINUS_RULE = new EnumerableMinusRule();
    public static final EnumerableTableModificationRule ENUMERABLE_TABLE_MODIFICATION_RULE = new EnumerableTableModificationRule();
    public static final EnumerableValuesRule ENUMERABLE_VALUES_RULE = new EnumerableValuesRule();
    public static final EnumerableOneRowRule ENUMERABLE_ONE_ROW_RULE = new EnumerableOneRowRule();
    public static final EnumerableEmptyRule ENUMERABLE_EMPTY_RULE = new EnumerableEmptyRule();
    public static final EnumerableWindowRule ENUMERABLE_WINDOW_RULE = new EnumerableWindowRule();
    public static final EnumerableCollectRule ENUMERABLE_COLLECT_RULE = new EnumerableCollectRule();
    public static final EnumerableUncollectRule ENUMERABLE_UNCOLLECT_RULE = new EnumerableUncollectRule();
    public static final EnumerableFilterToCalcRule ENUMERABLE_FILTER_TO_CALC_RULE = new EnumerableFilterToCalcRule();
    public static final EnumerableProjectToCalcRule ENUMERABLE_PROJECT_TO_CALC_RULE = new EnumerableProjectToCalcRule();
    public static final EnumerableTableFunctionRule ENUMERABLE_TABLE_FUNCTION_RULE = new EnumerableTableFunctionRule();

    private JavaRules() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableTableFunctionRel
    extends TableFunctionRelBase
    implements EnumerableRel {
        public EnumerableTableFunctionRel(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, Type elementType, RelDataType rowType, RexNode call, Set<RelColumnMapping> columnMappings) {
            super(cluster, traits, inputs, call, elementType, rowType, columnMappings);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new EnumerableTableFunctionRel(this.getCluster(), traitSet, inputs, this.getElementType(), this.getRowType(), this.getCall(), this.getColumnMappings());
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder bb = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), this.getElementType() == null || this.getElementType() instanceof Class && Object[].class.isAssignableFrom((Class)this.getElementType()) ? JavaRowFormat.ARRAY : JavaRowFormat.CUSTOM);
            RexToLixTranslator t = RexToLixTranslator.forAggregation((JavaTypeFactory)this.getCluster().getTypeFactory(), bb, null);
            Expression translated = t.translate(this.getCall());
            bb.add((Statement)Expressions.return_(null, (Expression)translated));
            return implementor.result(physType, bb.toBlock());
        }
    }

    public static class EnumerableTableFunctionRule
    extends ConverterRule {
        public EnumerableTableFunctionRule() {
            super(TableFunctionRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableTableFunctionRule");
        }

        public RelNode convert(RelNode rel) {
            RelTraitSet traitSet = rel.getTraitSet().replace(EnumerableConvention.INSTANCE);
            TableFunctionRel tbl = (TableFunctionRel)rel;
            return new EnumerableTableFunctionRel(rel.getCluster(), traitSet, tbl.getInputs(), tbl.getElementType(), tbl.getRowType(), tbl.getCall(), tbl.getColumnMappings());
        }
    }

    public static class EnumerableProjectToCalcRule
    extends RelOptRule {
        private EnumerableProjectToCalcRule() {
            super(EnumerableProjectToCalcRule.operand(EnumerableProjectRel.class, EnumerableProjectToCalcRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            EnumerableProjectRel project = (EnumerableProjectRel)call.rel(0);
            RelNode child = project.getChild();
            RelDataType rowType = project.getRowType();
            RexProgram program = RexProgram.create(child.getRowType(), project.getProjects(), null, project.getRowType(), project.getCluster().getRexBuilder());
            EnumerableCalcRel calc = new EnumerableCalcRel(project.getCluster(), project.getTraitSet(), child, rowType, program, (List<RelCollation>)ImmutableList.of());
            call.transformTo(calc);
        }
    }

    public static class EnumerableFilterToCalcRule
    extends RelOptRule {
        private EnumerableFilterToCalcRule() {
            super(EnumerableFilterToCalcRule.operand(EnumerableFilterRel.class, EnumerableFilterToCalcRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            EnumerableFilterRel filter = (EnumerableFilterRel)call.rel(0);
            RelNode rel = filter.getChild();
            RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
            RelDataType inputRowType = rel.getRowType();
            RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
            programBuilder.addIdentity();
            programBuilder.addCondition(filter.getCondition());
            RexProgram program = programBuilder.getProgram();
            EnumerableCalcRel calc = new EnumerableCalcRel(filter.getCluster(), filter.getTraitSet(), rel, inputRowType, program, (List<RelCollation>)ImmutableList.of());
            call.transformTo(calc);
        }
    }

    public static class EnumerableUncollectRel
    extends UncollectRel
    implements EnumerableRel {
        public EnumerableUncollectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child) {
            super(cluster, traitSet, child);
            assert (this.getConvention() instanceof EnumerableConvention);
            assert (this.getConvention() == child.getConvention());
        }

        public EnumerableUncollectRel copy(RelTraitSet traitSet, RelNode newInput) {
            return new EnumerableUncollectRel(this.getCluster(), traitSet, newInput);
        }

        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
            JavaTypeFactory typeFactory = implementor.getTypeFactory();
            RelDataType inputRowType = child.getRowType();
            Expression child_ = builder.append("child", result.block);
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)child_, (Method)BuiltinMethod.SELECT_MANY.method, (Expression[])new Expression[]{Expressions.call((Method)BuiltinMethod.LIST_TO_ENUMERABLE.method, (Expression[])new Expression[0])})));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableUncollectRule
    extends ConverterRule {
        private EnumerableUncollectRule() {
            super(UncollectRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableUncollectRule");
        }

        public RelNode convert(RelNode rel) {
            UncollectRel uncollect = (UncollectRel)rel;
            RelTraitSet traitSet = uncollect.getTraitSet().replace(EnumerableConvention.INSTANCE);
            RelNode input = uncollect.getChild();
            return new EnumerableUncollectRel(rel.getCluster(), traitSet, EnumerableUncollectRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE)));
        }
    }

    public static class EnumerableCollectRel
    extends CollectRel
    implements EnumerableRel {
        public EnumerableCollectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, String fieldName) {
            super(cluster, traitSet, child, fieldName);
            assert (this.getConvention() instanceof EnumerableConvention);
            assert (this.getConvention() == child.getConvention());
        }

        public EnumerableCollectRel copy(RelTraitSet traitSet, RelNode newInput) {
            return new EnumerableCollectRel(this.getCluster(), traitSet, newInput, this.fieldName);
        }

        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
            Expression child_ = builder.append("child", result.block);
            Expression list_ = builder.append("list", (Expression)Expressions.call((Expression)child_, (Method)BuiltinMethod.ENUMERABLE_TO_LIST.method, (Expression[])new Expression[0]));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltinMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{list_})));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableCollectRule
    extends ConverterRule {
        private EnumerableCollectRule() {
            super(CollectRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableCollectRule");
        }

        public RelNode convert(RelNode rel) {
            CollectRel collect = (CollectRel)rel;
            RelTraitSet traitSet = collect.getTraitSet().replace(EnumerableConvention.INSTANCE);
            RelNode input = collect.getChild();
            return new EnumerableCollectRel(rel.getCluster(), traitSet, EnumerableCollectRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE)), collect.getFieldName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableWindowRel
    extends WindowRelBase
    implements EnumerableRel {
        EnumerableWindowRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexLiteral> constants, RelDataType rowType, List<WindowRelBase.Window> windows) {
            super(cluster, traits, child, constants, rowType, windows);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new EnumerableWindowRel(this.getCluster(), traitSet, EnumerableWindowRel.sole(inputs), this.constants, this.rowType, (List<WindowRelBase.Window>)this.windows);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            double rowsIn = RelMetadataQuery.getRowCount(this.getChild());
            int count = this.windows.size();
            for (WindowRelBase.Window window : this.windows) {
                count += window.aggCalls.size();
            }
            return planner.getCostFactory().makeCost(rowsIn, rowsIn * (double)count, 0.0);
        }

        private void sampleOfTheGeneratedWindowedAggregate() {
            Iterator iterator = null;
            Integer[] rows = (Integer[])iterator.next();
            int prevStart = -1;
            int prevEnd = -1;
            for (int i = 0; i < rows.length; ++i) {
                Integer row = rows[i];
                int start = 0;
                int end = 100;
                if (start == prevStart && end == prevEnd) continue;
                int actualStart = 0;
                actualStart = start != prevStart || end < prevEnd ? start : prevEnd + 1;
                prevStart = start;
                prevEnd = end;
                if (start == -1) continue;
                for (int j = actualStart; j <= end; ++j) {
                }
            }
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            JavaTypeFactory typeFactory = implementor.getTypeFactory();
            EnumerableRel child = (EnumerableRel)this.getChild();
            BlockBuilder builder = new BlockBuilder();
            final EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            Expression source_ = builder.append("source", result.block);
            ArrayList<Expression> translatedConstants = new ArrayList<Expression>(this.constants.size());
            for (RexLiteral constant : this.constants) {
                translatedConstants.add(RexToLixTranslator.translateLiteral(constant, constant.getType(), typeFactory, RexImpTable.NullAs.NULL));
            }
            PhysType inputPhysType = result.physType;
            ParameterExpression prevStart = Expressions.parameter(Integer.TYPE, (String)builder.newName("prevStart"));
            ParameterExpression prevEnd = Expressions.parameter(Integer.TYPE, (String)builder.newName("prevEnd"));
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)prevStart, null));
            builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)prevEnd, null));
            for (int windowIdx = 0; windowIdx < this.windows.size(); ++windowIdx) {
                ConstantExpression hasRows;
                Expression endX;
                Expression startX;
                WindowRelBase.Window window = (WindowRelBase.Window)this.windows.get(windowIdx);
                Expression comparator_ = builder.append("comparator", inputPhysType.generateComparator(window.collation()));
                Pair<Expression, Expression> partitionIterator = this.getPartitionIterator(builder, source_, inputPhysType, window, comparator_);
                Expression collectionExpr = (Expression)partitionIterator.left;
                Expression iterator_ = (Expression)partitionIterator.right;
                ArrayList<AggImpState> aggs = new ArrayList<AggImpState>();
                List<AggregateCall> aggregateCalls = window.getAggregateCalls(this);
                for (int aggIdx = 0; aggIdx < aggregateCalls.size(); ++aggIdx) {
                    AggregateCall call = aggregateCalls.get(aggIdx);
                    aggs.add(new AggImpState(aggIdx, call, true));
                }
                RelDataTypeFactory.FieldInfoBuilder typeBuilder = typeFactory.builder();
                typeBuilder.addAll(inputPhysType.getRowType().getFieldList());
                for (AggImpState agg : aggs) {
                    typeBuilder.add(agg.call.name, agg.call.type);
                }
                RelDataType outputRowType = typeBuilder.build();
                PhysType outputPhysType = PhysTypeImpl.of(typeFactory, outputRowType, pref.prefer(result.format));
                Expression list_ = builder.append("list", (Expression)Expressions.new_(ArrayList.class, (Expression[])new Expression[]{Expressions.call((Expression)collectionExpr, (Method)BuiltinMethod.COLLECTION_SIZE.method, (Expression[])new Expression[0])}), false);
                Pair<Expression, Expression> collationKey = this.getRowCollationKey(builder, inputPhysType, window, windowIdx);
                Expression keySelector = (Expression)collationKey.left;
                Expression keyComparator = (Expression)collationKey.right;
                BlockBuilder builder3 = new BlockBuilder();
                Expression rows_ = builder3.append("rows", (Expression)Expressions.convert_((Expression)Expressions.call((Expression)iterator_, (Method)BuiltinMethod.ITERATOR_NEXT.method, (Expression[])new Expression[0]), Object[].class), false);
                builder3.add(Expressions.statement((Expression)Expressions.assign((Expression)prevStart, (Expression)Expressions.constant((Object)-1))));
                builder3.add(Expressions.statement((Expression)Expressions.assign((Expression)prevEnd, (Expression)Expressions.constant((Object)Integer.MAX_VALUE))));
                BlockBuilder builder4 = new BlockBuilder();
                ParameterExpression i_ = Expressions.parameter(Integer.TYPE, (String)builder4.newName("i"));
                Expression row_ = builder4.append("row", RexToLixTranslator.convert((Expression)Expressions.arrayIndex((Expression)rows_, (Expression)i_), inputPhysType.getJavaRowType()));
                WindowRelInputGetter inputGetter = new WindowRelInputGetter(row_, inputPhysType, result.physType.getRowType().getFieldCount(), translatedConstants);
                RexToLixTranslator translator = RexToLixTranslator.forAggregation(typeFactory, builder4, inputGetter);
                ArrayList<Expression> outputRow = new ArrayList<Expression>();
                int fieldCountWithAggResults = inputPhysType.getRowType().getFieldCount();
                for (int i = 0; i < fieldCountWithAggResults; ++i) {
                    outputRow.add(inputPhysType.fieldReference(row_, i, outputPhysType.getJavaFieldType(i)));
                }
                this.declareAndResetState(typeFactory, builder, result, windowIdx, aggs, outputPhysType, outputRow);
                ConstantExpression minX = Expressions.constant((Object)0);
                Expression partitionRowCount = builder3.append("partRows", (Expression)Expressions.field((Expression)rows_, (String)"length"));
                Expression maxX = builder3.append("maxX", (Expression)Expressions.subtract((Expression)partitionRowCount, (Expression)Expressions.constant((Object)1)));
                Expression startUnchecked = builder4.append("start", this.translateBound(translator, i_, row_, (Expression)minX, maxX, rows_, window, true, inputPhysType, comparator_, keySelector, keyComparator));
                Expression endUnchecked = builder4.append("end", this.translateBound(translator, i_, row_, (Expression)minX, maxX, rows_, window, false, inputPhysType, comparator_, keySelector, keyComparator));
                if (window.isAlwaysNonEmpty()) {
                    startX = startUnchecked;
                    endX = endUnchecked;
                    hasRows = Expressions.constant((Object)true);
                } else {
                    Expression startTmp = window.lowerBound.isUnbounded() || startUnchecked == i_ ? startUnchecked : builder4.append("startTmp", (Expression)Expressions.call(null, (Method)BuiltinMethod.MATH_MAX.method, (Expression[])new Expression[]{startUnchecked, minX}));
                    Expression endTmp = window.upperBound.isUnbounded() || endUnchecked == i_ ? endUnchecked : builder4.append("endTmp", (Expression)Expressions.call(null, (Method)BuiltinMethod.MATH_MIN.method, (Expression[])new Expression[]{endUnchecked, maxX}));
                    ParameterExpression startPe = Expressions.parameter((int)0, Integer.TYPE, (String)builder4.newName("startChecked"));
                    ParameterExpression endPe = Expressions.parameter((int)0, Integer.TYPE, (String)builder4.newName("endChecked"));
                    builder4.add((Statement)Expressions.declare((int)16, (ParameterExpression)startPe, null));
                    builder4.add((Statement)Expressions.declare((int)16, (ParameterExpression)endPe, null));
                    hasRows = builder4.append("hasRows", (Expression)Expressions.lessThanOrEqual((Expression)startTmp, (Expression)endTmp));
                    builder4.add((Statement)Expressions.ifThenElse((Expression)hasRows, (Node)Expressions.block((Statement[])new Statement[]{Expressions.statement((Expression)Expressions.assign((Expression)startPe, (Expression)startTmp)), Expressions.statement((Expression)Expressions.assign((Expression)endPe, (Expression)endTmp))}), (Node)Expressions.block((Statement[])new Statement[]{Expressions.statement((Expression)Expressions.assign((Expression)startPe, (Expression)Expressions.constant((Object)-1))), Expressions.statement((Expression)Expressions.assign((Expression)endPe, (Expression)Expressions.constant((Object)-1)))})));
                    startX = startPe;
                    endX = endPe;
                }
                BlockBuilder builder5 = new BlockBuilder(true, builder4);
                BinaryExpression rowCountWhenNonEmpty = Expressions.add((Expression)(startX == minX ? endX : Expressions.subtract((Expression)endX, (Expression)startX)), (Expression)Expressions.constant((Object)1));
                Expression frameRowCount = hasRows.equals((Object)Expressions.constant((Object)true)) ? builder4.append("totalRows", (Expression)rowCountWhenNonEmpty) : builder4.append("totalRows", Expressions.condition((Expression)hasRows, (Expression)rowCountWhenNonEmpty, (Expression)Expressions.constant((Object)0)));
                ParameterExpression actualStart = Expressions.parameter((int)0, Integer.TYPE, (String)builder5.newName("actualStart"));
                BlockBuilder builder6 = new BlockBuilder(true, builder5);
                builder6.add(Expressions.statement((Expression)Expressions.assign((Expression)actualStart, (Expression)startX)));
                for (AggImpState agg : aggs) {
                    agg.implementor.implementReset(agg.context, new WinAggResetContextImpl(builder6, agg.state, (Expression)i_, startX, endX, (Expression)hasRows, partitionRowCount, frameRowCount));
                }
                BinaryExpression lowerBoundCanChange = window.lowerBound.isUnbounded() && window.lowerBound.isPreceding() ? Expressions.constant((Object)false) : Expressions.notEqual((Expression)startX, (Expression)prevStart);
                BinaryExpression needRecomputeWindow = Expressions.orElse((Expression)lowerBoundCanChange, (Expression)Expressions.lessThan((Expression)endX, (Expression)prevEnd));
                BlockStatement resetWindowState = builder6.toBlock();
                if (resetWindowState.statements.size() == 1) {
                    builder5.add((Statement)Expressions.declare((int)0, (ParameterExpression)actualStart, (Expression)Expressions.condition((Expression)needRecomputeWindow, (Expression)startX, (Expression)Expressions.add((Expression)prevEnd, (Expression)Expressions.constant((Object)1)))));
                } else {
                    builder5.add((Statement)Expressions.declare((int)0, (ParameterExpression)actualStart, null));
                    builder5.add((Statement)Expressions.ifThenElse((Expression)needRecomputeWindow, (Node)resetWindowState, (Node)Expressions.statement((Expression)Expressions.assign((Expression)actualStart, (Expression)Expressions.add((Expression)prevEnd, (Expression)Expressions.constant((Object)1))))));
                }
                if (lowerBoundCanChange instanceof BinaryExpression) {
                    builder5.add(Expressions.statement((Expression)Expressions.assign((Expression)prevStart, (Expression)startX)));
                }
                builder5.add(Expressions.statement((Expression)Expressions.assign((Expression)prevEnd, (Expression)endX)));
                BlockBuilder builder7 = new BlockBuilder(true, builder5);
                DeclarationStatement jDecl = Expressions.declare((int)0, (String)"j", (Expression)actualStart);
                PhysType inputPhysTypeFinal = inputPhysType;
                Function<BlockBuilder, WinAggFrameResultContext> resultContextBuilder = this.getBlockBuilderWinAggFrameResultContextFunction(typeFactory, result, translatedConstants, comparator_, rows_, i_, startX, endX, (Expression)minX, maxX, (Expression)hasRows, frameRowCount, partitionRowCount, jDecl, inputPhysTypeFinal);
                Function<AggImpState, List<RexNode>> rexArguments = new Function<AggImpState, List<RexNode>>(){

                    public List<RexNode> apply(AggImpState agg) {
                        List<Integer> argList = agg.call.getArgList();
                        List<RelDataType> inputTypes = EnumUtil.fieldRowTypes(result.physType.getRowType(), EnumerableWindowRel.this.constants, argList);
                        ArrayList<RexNode> args = new ArrayList<RexNode>(inputTypes.size());
                        for (int i = 0; i < argList.size(); ++i) {
                            Integer idx = argList.get(i);
                            args.add(new RexInputRef(idx, inputTypes.get(i)));
                        }
                        return args;
                    }
                };
                this.implementAdd(aggs, builder7, resultContextBuilder, rexArguments, jDecl);
                BlockStatement forBlock = builder7.toBlock();
                if (!forBlock.statements.isEmpty()) {
                    ForStatement forAggLoop = Expressions.for_(Arrays.asList(jDecl), (Expression)Expressions.lessThanOrEqual((Expression)jDecl.parameter, (Expression)endX), (Expression)Expressions.preIncrementAssign((Expression)jDecl.parameter), (Statement)forBlock);
                    if (!hasRows.equals((Object)Expressions.constant((Object)true))) {
                        forAggLoop = Expressions.ifThen((Expression)hasRows, (Node)forAggLoop);
                    }
                    builder5.add((Statement)forAggLoop);
                }
                if (this.implementResult(aggs, builder5, resultContextBuilder, rexArguments, true)) {
                    builder4.add((Statement)Expressions.ifThen((Expression)Expressions.orElse((Expression)lowerBoundCanChange, (Expression)Expressions.notEqual((Expression)endX, (Expression)prevEnd)), (Node)builder5.toBlock()));
                }
                this.implementResult(aggs, builder4, resultContextBuilder, rexArguments, false);
                builder4.add(Expressions.statement((Expression)Expressions.call((Expression)list_, (Method)BuiltinMethod.COLLECTION_ADD.method, (Expression[])new Expression[]{outputPhysType.record(outputRow)})));
                builder3.add((Statement)Expressions.for_((DeclarationStatement)Expressions.declare((int)0, (ParameterExpression)i_, (Expression)Expressions.constant((Object)0)), (Expression)Expressions.lessThan((Expression)i_, (Expression)Expressions.field((Expression)rows_, (String)"length")), (Expression)Expressions.preIncrementAssign((Expression)i_), (Statement)builder4.toBlock()));
                builder.add((Statement)Expressions.while_((Expression)Expressions.call((Expression)iterator_, (Method)BuiltinMethod.ITERATOR_HAS_NEXT.method, (Expression[])new Expression[0]), (Statement)builder3.toBlock()));
                builder.add(Expressions.statement((Expression)Expressions.call((Expression)collectionExpr, (Method)BuiltinMethod.MAP_CLEAR.method, (Expression[])new Expression[0])));
                source_ = builder.append("source", (Expression)Expressions.call((Method)BuiltinMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{list_}));
                inputPhysType = outputPhysType;
            }
            builder.add((Statement)Expressions.return_(null, (Expression)source_));
            return implementor.result(inputPhysType, builder.toBlock());
        }

        private Function<BlockBuilder, WinAggFrameResultContext> getBlockBuilderWinAggFrameResultContextFunction(final JavaTypeFactory typeFactory, final EnumerableRel.Result result, final List<Expression> translatedConstants, final Expression comparator_, final Expression rows_, final ParameterExpression i_, final Expression startX, final Expression endX, final Expression minX, final Expression maxX, final Expression hasRows, final Expression frameRowCount, final Expression partitionRowCount, final DeclarationStatement jDecl, final PhysType inputPhysType) {
            return new Function<BlockBuilder, WinAggFrameResultContext>(){

                public WinAggFrameResultContext apply(final BlockBuilder block) {
                    return new WinAggFrameResultContext(){

                        public RexToLixTranslator rowTranslator(Expression rowIndex) {
                            Expression row = this.getRow(rowIndex);
                            WindowRelInputGetter inputGetter = new WindowRelInputGetter(row, inputPhysType, result.physType.getRowType().getFieldCount(), translatedConstants);
                            return RexToLixTranslator.forAggregation(typeFactory, block, inputGetter);
                        }

                        public Expression computeIndex(Expression offset, WinAggImplementor.SeekType seekType) {
                            ParameterExpression index;
                            if (seekType == WinAggImplementor.SeekType.AGG_INDEX) {
                                index = jDecl.parameter;
                            } else if (seekType == WinAggImplementor.SeekType.SET) {
                                index = i_;
                            } else if (seekType == WinAggImplementor.SeekType.START) {
                                index = startX;
                            } else if (seekType == WinAggImplementor.SeekType.END) {
                                index = endX;
                            } else {
                                throw new IllegalArgumentException("SeekSet " + (Object)((Object)seekType) + " is not supported");
                            }
                            if (!Expressions.constant((Object)0).equals((Object)offset)) {
                                index = block.append("idx", (Expression)Expressions.add((Expression)index, (Expression)offset));
                            }
                            return index;
                        }

                        private Expression checkBounds(Expression rowIndex, Expression minIndex, Expression maxIndex) {
                            if (rowIndex == i_ || rowIndex == startX || rowIndex == endX) {
                                return hasRows;
                            }
                            Expression res = block.append("rowInFrame", Expressions.foldAnd((List)ImmutableList.of((Object)hasRows, (Object)Expressions.greaterThanOrEqual((Expression)rowIndex, (Expression)minIndex), (Object)Expressions.lessThanOrEqual((Expression)rowIndex, (Expression)maxIndex))));
                            return res;
                        }

                        public Expression rowInFrame(Expression rowIndex) {
                            return this.checkBounds(rowIndex, startX, endX);
                        }

                        public Expression rowInPartition(Expression rowIndex) {
                            return this.checkBounds(rowIndex, minX, maxX);
                        }

                        public Expression compareRows(Expression a, Expression b) {
                            return Expressions.call((Expression)comparator_, (Method)BuiltinMethod.COMPARATOR_COMPARE.method, (Expression[])new Expression[]{this.getRow(a), this.getRow(b)});
                        }

                        public Expression getRow(Expression rowIndex) {
                            return block.append("jRow", RexToLixTranslator.convert((Expression)Expressions.arrayIndex((Expression)rows_, (Expression)rowIndex), inputPhysType.getJavaRowType()));
                        }

                        public Expression index() {
                            return i_;
                        }

                        public Expression startIndex() {
                            return startX;
                        }

                        public Expression endIndex() {
                            return endX;
                        }

                        public Expression hasRows() {
                            return hasRows;
                        }

                        public Expression getFrameRowCount() {
                            return frameRowCount;
                        }

                        public Expression getPartitionRowCount() {
                            return partitionRowCount;
                        }
                    };
                }
            };
        }

        private Pair<Expression, Expression> getPartitionIterator(BlockBuilder builder, Expression source_, PhysType inputPhysType, WindowRelBase.Window window, Expression comparator_) {
            if (window.groupSet.isEmpty()) {
                Expression tempList_ = builder.append("tempList", (Expression)Expressions.convert_((Expression)Expressions.call((Expression)source_, (Method)BuiltinMethod.INTO.method, (Expression[])new Expression[]{Expressions.new_(ArrayList.class)}), List.class));
                return Pair.of(tempList_, builder.append("iterator", (Expression)Expressions.call(null, (Method)BuiltinMethod.SORTED_MULTI_MAP_SINGLETON.method, (Expression[])new Expression[]{comparator_, tempList_})));
            }
            Expression multiMap_ = builder.append("multiMap", (Expression)Expressions.new_(SortedMultiMap.class));
            BlockBuilder builder2 = new BlockBuilder();
            ParameterExpression v_ = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)builder2.newName("v"));
            DeclarationStatement declare = Expressions.declare((int)0, (String)"key", (Expression)inputPhysType.selector(v_, BitSets.toList(window.groupSet), JavaRowFormat.CUSTOM));
            builder2.add((Statement)declare);
            ParameterExpression key_ = declare.parameter;
            builder2.add(Expressions.statement((Expression)Expressions.call((Expression)multiMap_, (Method)BuiltinMethod.SORTED_MULTI_MAP_PUT_MULTI.method, (Expression[])new Expression[]{key_, v_})));
            builder2.add((Statement)Expressions.return_(null, (Expression)Expressions.constant(null)));
            builder.add(Expressions.statement((Expression)Expressions.call((Expression)source_, (Method)BuiltinMethod.ENUMERABLE_FOREACH.method, (Expression[])new Expression[]{Expressions.lambda((BlockStatement)builder2.toBlock(), (ParameterExpression[])new ParameterExpression[]{v_})})));
            return Pair.of(multiMap_, builder.append("iterator", (Expression)Expressions.call((Expression)multiMap_, (Method)BuiltinMethod.SORTED_MULTI_MAP_ARRAYS.method, (Expression[])new Expression[]{comparator_})));
        }

        private Pair<Expression, Expression> getRowCollationKey(BlockBuilder builder, PhysType inputPhysType, WindowRelBase.Window window, int windowIdx) {
            if (!(window.isRows || window.upperBound.isUnbounded() && window.lowerBound.isUnbounded())) {
                Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(window.collation().getFieldCollations());
                return Pair.of(builder.append("keySelector" + windowIdx, (Expression)pair.left, false), builder.append("keyComparator" + windowIdx, (Expression)pair.right, false));
            }
            return Pair.of(null, null);
        }

        private void declareAndResetState(final JavaTypeFactory typeFactory, BlockBuilder builder, final EnumerableRel.Result result, int windowIdx, List<AggImpState> aggs, PhysType outputPhysType, List<Expression> outputRow) {
            for (final AggImpState agg : aggs) {
                ParameterExpression aggRes;
                agg.context = new WinAggContext(){

                    @Override
                    public Aggregation aggregation() {
                        return agg.call.getAggregation();
                    }

                    @Override
                    public RelDataType returnRelType() {
                        return agg.call.type;
                    }

                    @Override
                    public Type returnType() {
                        return EnumUtil.javaClass(typeFactory, this.returnRelType());
                    }

                    @Override
                    public List<? extends Type> parameterTypes() {
                        return EnumUtil.fieldTypes(typeFactory, this.parameterRelTypes());
                    }

                    @Override
                    public List<? extends RelDataType> parameterRelTypes() {
                        return EnumUtil.fieldRowTypes(result.physType.getRowType(), EnumerableWindowRel.this.constants, agg.call.getArgList());
                    }
                };
                String aggName = "a" + agg.aggIdx;
                if (OptiqPrepareImpl.DEBUG) {
                    aggName = Util.toJavaId(agg.call.getAggregation().getName(), 0).substring("ID$0$".length()) + aggName;
                }
                List<Type> state = agg.implementor.getStateType(agg.context);
                ArrayList<Expression> decls = new ArrayList<Expression>(state.size());
                for (int i = 0; i < state.size(); ++i) {
                    Type type = state.get(i);
                    ParameterExpression pe = Expressions.parameter((Type)type, (String)builder.newName(aggName + "s" + i + "w" + windowIdx));
                    builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)pe, null));
                    decls.add((Expression)pe);
                }
                agg.state = decls;
                Type aggHolderType = agg.context.returnType();
                Type aggStorageType = outputPhysType.getJavaFieldType(outputRow.size());
                if (Primitive.is((Type)aggHolderType) && !Primitive.is((Type)aggStorageType)) {
                    aggHolderType = Primitive.box((Type)aggHolderType);
                }
                builder.add((Statement)Expressions.declare((int)0, (ParameterExpression)aggRes, (Expression)Expressions.constant((Object)(Primitive.is((Type)(aggRes = Expressions.parameter((int)0, (Type)aggHolderType, (String)builder.newName(aggName + "w" + windowIdx))).getType()) ? Primitive.of((Type)aggRes.getType()).defaultValue : null), (Type)aggRes.getType())));
                agg.result = aggRes;
                outputRow.add((Expression)aggRes);
                agg.implementor.implementReset(agg.context, new WinAggResetContextImpl(builder, agg.state, null, null, null, null, null, null));
            }
        }

        private void implementAdd(List<AggImpState> aggs, BlockBuilder builder7, Function<BlockBuilder, WinAggFrameResultContext> frame, final Function<AggImpState, List<RexNode>> rexArguments, final DeclarationStatement jDecl) {
            for (final AggImpState agg : aggs) {
                WinAggAddContextImpl addContext = new WinAggAddContextImpl(builder7, agg.state, frame){

                    @Override
                    public Expression currentPosition() {
                        return jDecl.parameter;
                    }

                    @Override
                    public List<RexNode> rexArguments() {
                        return (List)rexArguments.apply((Object)agg);
                    }
                };
                agg.implementor.implementAdd(agg.context, addContext);
            }
        }

        private boolean implementResult(List<AggImpState> aggs, BlockBuilder builder, Function<BlockBuilder, WinAggFrameResultContext> frame, final Function<AggImpState, List<RexNode>> rexArguments, boolean cachedBlock) {
            boolean nonEmpty = false;
            for (final AggImpState agg : aggs) {
                boolean needCache = true;
                if (agg.implementor instanceof WinAggImplementor) {
                    WinAggImplementor imp = (WinAggImplementor)agg.implementor;
                    needCache = imp.needCacheWhenFrameIntact();
                }
                if (needCache ^ cachedBlock) continue;
                nonEmpty = true;
                Expression res = agg.implementor.implementResult(agg.context, new WinAggResultContextImpl(builder, agg.state, frame){

                    @Override
                    public List<RexNode> rexArguments() {
                        return (List)rexArguments.apply((Object)agg);
                    }
                });
                Expression aggRes = builder.append("a" + agg.aggIdx + "res", RexToLixTranslator.convert(res, agg.result.getType()));
                builder.add(Expressions.statement((Expression)Expressions.assign((Expression)agg.result, (Expression)aggRes)));
            }
            return nonEmpty;
        }

        private Expression translateBound(RexToLixTranslator translator, ParameterExpression i_, Expression row_, Expression min_, Expression max_, Expression rows_, WindowRelBase.Window window, boolean lower, PhysType physType, Expression rowComparator, Expression keySelector, Expression keyComparator) {
            RexWindowBound bound;
            RexWindowBound rexWindowBound = bound = lower ? window.lowerBound : window.upperBound;
            if (bound.isUnbounded()) {
                return bound.isPreceding() ? min_ : max_;
            }
            if (window.isRows) {
                if (bound.isCurrentRow()) {
                    return i_;
                }
                RexNode node = bound.getOffset();
                Expression offs = translator.translate(node);
                offs = RexToLixTranslator.convert(offs, Integer.TYPE);
                ParameterExpression b = i_;
                b = bound.isFollowing() ? Expressions.add((Expression)b, (Expression)offs) : Expressions.subtract((Expression)b, (Expression)offs);
                return b;
            }
            Expression searchLower = min_;
            Expression searchUpper = max_;
            if (bound.isCurrentRow()) {
                if (lower) {
                    searchUpper = i_;
                } else {
                    searchLower = i_;
                }
            }
            List<RelFieldCollation> fieldCollations = window.collation().getFieldCollations();
            if (bound.isCurrentRow() && fieldCollations.size() != 1) {
                return Expressions.call((Method)(lower ? BuiltinMethod.BINARY_SEARCH5_LOWER : BuiltinMethod.BINARY_SEARCH5_UPPER).method, (Expression[])new Expression[]{rows_, row_, searchLower, searchUpper, keySelector, keyComparator});
            }
            assert (fieldCollations.size() == 1) : "When using range window specification, ORDER BY should have exactly one expression. Actual collation is " + window.collation();
            int orderKey = fieldCollations.get(0).getFieldIndex();
            RelDataType keyType = physType.getRowType().getFieldList().get(orderKey).getType();
            Type desiredKeyType = translator.typeFactory.getJavaClass(keyType);
            if (bound.getOffset() == null) {
                desiredKeyType = Primitive.box((Type)desiredKeyType);
            }
            Expression val = translator.translate((RexNode)new RexInputRef(orderKey, keyType), desiredKeyType);
            if (!bound.isCurrentRow()) {
                RexNode node = bound.getOffset();
                Expression offs = translator.translate(node);
                val = bound.isFollowing() ? Expressions.add((Expression)val, (Expression)offs) : Expressions.subtract((Expression)val, (Expression)offs);
            }
            return Expressions.call((Method)(lower ? BuiltinMethod.BINARY_SEARCH6_LOWER : BuiltinMethod.BINARY_SEARCH6_UPPER).method, (Expression[])new Expression[]{rows_, val, searchLower, searchUpper, keySelector, keyComparator});
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class WindowRelInputGetter
        implements RexToLixTranslator.InputGetter {
            private final Expression row;
            private final PhysType rowPhysType;
            private final int actualInputFieldCount;
            private final List<Expression> constants;

            private WindowRelInputGetter(Expression row, PhysType rowPhysType, int actualInputFieldCount, List<Expression> constants) {
                this.row = row;
                this.rowPhysType = rowPhysType;
                this.actualInputFieldCount = actualInputFieldCount;
                this.constants = constants;
            }

            @Override
            public Expression field(BlockBuilder list, int index, Type storageType) {
                if (index < this.actualInputFieldCount) {
                    Expression current = list.append("current", this.row);
                    return this.rowPhysType.fieldReference(current, index, storageType);
                }
                return this.constants.get(index - this.actualInputFieldCount);
            }
        }
    }

    private static class EnumerableWindowRule
    extends ConverterRule {
        private EnumerableWindowRule() {
            super(WindowRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableWindowRule");
        }

        public RelNode convert(RelNode rel) {
            WindowRel winAgg = (WindowRel)rel;
            RelTraitSet traitSet = winAgg.getTraitSet().replace(EnumerableConvention.INSTANCE);
            RelNode child = winAgg.getChild();
            RelNode convertedChild = EnumerableWindowRule.convert(child, child.getTraitSet().replace(EnumerableConvention.INSTANCE));
            return new EnumerableWindowRel(rel.getCluster(), traitSet, convertedChild, winAgg.getConstants(), winAgg.getRowType(), (List<WindowRelBase.Window>)winAgg.windows);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableValuesRel
    extends ValuesRelBase
    implements EnumerableRel {
        EnumerableValuesRel(RelOptCluster cluster, RelDataType rowType, List<List<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new EnumerableValuesRel(this.getCluster(), this.rowType, this.tuples, traitSet);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferCustom());
            Type rowClass = physType.getJavaRowType();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            List<RelDataTypeField> fields = this.rowType.getFieldList();
            for (List tuple : this.tuples) {
                ArrayList<Expression> literals = new ArrayList<Expression>();
                for (Pair pair : Pair.zip(fields, tuple)) {
                    literals.add(RexToLixTranslator.translateLiteral((RexNode)pair.right, ((RelDataTypeField)pair.left).getType(), typeFactory, RexImpTable.NullAs.NULL));
                }
                expressions.add(physType.record(literals));
            }
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltinMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)Primitive.box((Type)rowClass), expressions)})));
            return implementor.result(physType, builder.toBlock());
        }
    }

    public static class EnumerableEmptyRule
    extends ConverterRule {
        private EnumerableEmptyRule() {
            super(EmptyRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableEmptyRule");
        }

        public RelNode convert(RelNode rel) {
            EmptyRel empty = (EmptyRel)rel;
            return new EnumerableValuesRel(empty.getCluster(), empty.getRowType(), (List<List<RexLiteral>>)ImmutableList.of(), empty.getTraitSet().replace(EnumerableConvention.INSTANCE));
        }
    }

    public static class EnumerableOneRowRule
    extends ConverterRule {
        private EnumerableOneRowRule() {
            super(OneRowRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableOneRowRule");
        }

        public RelNode convert(RelNode rel) {
            OneRowRel oneRow = (OneRowRel)rel;
            RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
            return new EnumerableValuesRel(oneRow.getCluster(), oneRow.getRowType(), Collections.singletonList(Collections.singletonList(rexBuilder.makeExactLiteral(BigDecimal.ZERO))), oneRow.getTraitSet().replace(EnumerableConvention.INSTANCE));
        }
    }

    public static class EnumerableValuesRule
    extends ConverterRule {
        private EnumerableValuesRule() {
            super(ValuesRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableValuesRule");
        }

        public RelNode convert(RelNode rel) {
            ValuesRel valuesRel = (ValuesRel)rel;
            return new EnumerableValuesRel(valuesRel.getCluster(), valuesRel.getRowType(), valuesRel.getTuples(), valuesRel.getTraitSet().replace(EnumerableConvention.INSTANCE));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableTableModificationRel
    extends TableModificationRelBase
    implements EnumerableRel {
        public EnumerableTableModificationRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModificationRelBase.Operation operation, List<String> updateColumnList, boolean flattened) {
            super(cluster, traits, table, catalogReader, child, operation, updateColumnList, flattened);
            assert (child.getConvention() instanceof EnumerableConvention);
            assert (this.getConvention() instanceof EnumerableConvention);
            ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                throw new AssertionError();
            }
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new EnumerableTableModificationRel(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), EnumerableTableModificationRel.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.isFlattened());
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            Expression convertedChildExp;
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel.Result result = implementor.visitChild(this, 0, (EnumerableRel)this.getChild(), pref);
            Expression childExp = builder.append("child", result.block);
            ParameterExpression collectionParameter = Expressions.parameter(Collection.class, (String)builder.newName("collection"));
            Expression expression = this.table.getExpression(ModifiableTable.class);
            assert (expression != null);
            assert (ModifiableTable.class.isAssignableFrom(Types.toClass((Type)expression.getType()))) : expression.getType();
            builder.add((Statement)Expressions.declare((int)16, (ParameterExpression)collectionParameter, (Expression)Expressions.call((Expression)expression, (Method)BuiltinMethod.MODIFIABLE_TABLE_GET_MODIFIABLE_COLLECTION.method, (Expression[])new Expression[0])));
            Expression countParameter = builder.append("count", (Expression)Expressions.call((Expression)collectionParameter, (String)"size", (Expression[])new Expression[0]), false);
            if (!this.getChild().getRowType().equals(this.getRowType())) {
                JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
                PhysType physType = PhysTypeImpl.of(typeFactory, this.table.getRowType(), JavaRowFormat.CUSTOM);
                ArrayList<Expression> expressionList = new ArrayList<Expression>();
                PhysType childPhysType = result.physType;
                ParameterExpression o_ = Expressions.parameter((Type)childPhysType.getJavaRowType(), (String)"o");
                int fieldCount = childPhysType.getRowType().getFieldCount();
                for (int i = 0; i < fieldCount; ++i) {
                    expressionList.add(childPhysType.fieldReference((Expression)o_, i, physType.getJavaFieldType(i)));
                }
                convertedChildExp = builder.append("convertedChild", (Expression)Expressions.call((Expression)childExp, (Method)BuiltinMethod.SELECT.method, (Expression[])new Expression[]{Expressions.lambda((Expression)physType.record(expressionList), (ParameterExpression[])new ParameterExpression[]{o_})}));
            } else {
                convertedChildExp = childExp;
            }
            builder.add(Expressions.statement((Expression)Expressions.call((Expression)convertedChildExp, (String)"into", (Expression[])new Expression[]{collectionParameter})));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltinMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)Expressions.subtract((Expression)Expressions.call((Expression)collectionParameter, (String)"size", (Expression[])new Expression[0]), (Expression)countParameter), Long.TYPE)})));
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref == EnumerableRel.Prefer.ARRAY ? JavaRowFormat.ARRAY : JavaRowFormat.SCALAR);
            return implementor.result(physType, builder.toBlock());
        }
    }

    public static class EnumerableTableModificationRule
    extends ConverterRule {
        private EnumerableTableModificationRule() {
            super(TableModificationRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableTableModificationRule");
        }

        public RelNode convert(RelNode rel) {
            TableModificationRel modify = (TableModificationRel)rel;
            ModifiableTable modifiableTable = modify.getTable().unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                return null;
            }
            RelTraitSet traitSet = modify.getTraitSet().replace(EnumerableConvention.INSTANCE);
            return new EnumerableTableModificationRel(modify.getCluster(), traitSet, modify.getTable(), modify.getCatalogReader(), EnumerableTableModificationRule.convert(modify.getChild(), traitSet), modify.getOperation(), modify.getUpdateColumnList(), modify.isFlattened());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableMinusRel
    extends MinusRelBase
    implements EnumerableRel {
        public EnumerableMinusRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public EnumerableMinusRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new EnumerableMinusRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            Object minusExp = null;
            for (Ord ord : Ord.zip((List)this.inputs)) {
                EnumerableRel input = (EnumerableRel)ord.e;
                EnumerableRel.Result result = implementor.visitChild(this, ord.i, input, pref);
                Expression childExp = builder.append("child" + ord.i, result.block);
                minusExp = minusExp == null ? childExp : Expressions.call((Expression)minusExp, (Method)BuiltinMethod.EXCEPT.method, (Expression[])new Expression[]{childExp});
                pref = pref.of(result.format);
            }
            builder.add(minusExp);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableMinusRule
    extends ConverterRule {
        private EnumerableMinusRule() {
            super(MinusRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableMinusRule");
        }

        public RelNode convert(RelNode rel) {
            MinusRel minus = (MinusRel)rel;
            if (minus.all) {
                return null;
            }
            EnumerableConvention out = EnumerableConvention.INSTANCE;
            RelTraitSet traitSet = rel.getTraitSet().replace(EnumerableConvention.INSTANCE);
            return new EnumerableMinusRel(rel.getCluster(), traitSet, EnumerableMinusRule.convertList(minus.getInputs(), out), minus.all);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableIntersectRel
    extends IntersectRelBase
    implements EnumerableRel {
        public EnumerableIntersectRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public EnumerableIntersectRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new EnumerableIntersectRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            Object intersectExp = null;
            for (Ord ord : Ord.zip((List)this.inputs)) {
                EnumerableRel input = (EnumerableRel)ord.e;
                EnumerableRel.Result result = implementor.visitChild(this, ord.i, input, pref);
                Expression childExp = builder.append("child" + ord.i, result.block);
                intersectExp = intersectExp == null ? childExp : Expressions.call((Expression)intersectExp, (Method)(this.all ? BuiltinMethod.CONCAT.method : BuiltinMethod.INTERSECT.method), (Expression[])new Expression[]{childExp});
                pref = pref.of(result.format);
            }
            builder.add(intersectExp);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableIntersectRule
    extends ConverterRule {
        private EnumerableIntersectRule() {
            super(IntersectRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableIntersectRule");
        }

        public RelNode convert(RelNode rel) {
            IntersectRel intersect = (IntersectRel)rel;
            if (intersect.all) {
                return null;
            }
            EnumerableConvention out = EnumerableConvention.INSTANCE;
            RelTraitSet traitSet = intersect.getTraitSet().replace(out);
            return new EnumerableIntersectRel(rel.getCluster(), traitSet, EnumerableIntersectRule.convertList(intersect.getInputs(), out), intersect.all);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableUnionRel
    extends UnionRelBase
    implements EnumerableRel {
        public EnumerableUnionRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public EnumerableUnionRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new EnumerableUnionRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            Object unionExp = null;
            for (Ord ord : Ord.zip((List)this.inputs)) {
                EnumerableRel input = (EnumerableRel)ord.e;
                EnumerableRel.Result result = implementor.visitChild(this, ord.i, input, pref);
                Expression childExp = builder.append("child" + ord.i, result.block);
                unionExp = unionExp == null ? childExp : Expressions.call((Expression)unionExp, (Method)(this.all ? BuiltinMethod.CONCAT.method : BuiltinMethod.UNION.method), (Expression[])new Expression[]{childExp});
                pref = pref.of(result.format);
            }
            builder.add(unionExp);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(JavaRowFormat.CUSTOM));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableUnionRule
    extends ConverterRule {
        private EnumerableUnionRule() {
            super(UnionRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableUnionRule");
        }

        public RelNode convert(RelNode rel) {
            UnionRel union = (UnionRel)rel;
            EnumerableConvention out = EnumerableConvention.INSTANCE;
            RelTraitSet traitSet = union.getTraitSet().replace(out);
            return new EnumerableUnionRel(rel.getCluster(), traitSet, EnumerableUnionRule.convertList(union.getInputs(), out), union.all);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableLimitRel
    extends SingleRel
    implements EnumerableRel {
        private final RexNode offset;
        private final RexNode fetch;

        public EnumerableLimitRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
            super(cluster, traitSet, child);
            this.offset = offset;
            this.fetch = fetch;
            assert (this.getConvention() instanceof EnumerableConvention);
            assert (this.getConvention() == child.getConvention());
        }

        @Override
        public EnumerableLimitRel copy(RelTraitSet traitSet, List<RelNode> newInputs) {
            return new EnumerableLimitRel(this.getCluster(), traitSet, EnumerableLimitRel.sole(newInputs), this.offset, this.fetch);
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return super.explainTerms(pw).itemIf("offset", this.offset, this.offset != null).itemIf("fetch", this.fetch, this.fetch != null);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            Expression childExp;
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
            Expression v = childExp = builder.append("child", result.block);
            if (this.offset != null) {
                v = builder.append("offset", (Expression)Expressions.call((Expression)v, (Method)BuiltinMethod.SKIP.method, (Expression[])new Expression[]{Expressions.constant((Object)RexLiteral.intValue(this.offset))}));
            }
            if (this.fetch != null) {
                v = builder.append("fetch", (Expression)Expressions.call((Expression)v, (Method)BuiltinMethod.TAKE.method, (Expression[])new Expression[]{Expressions.constant((Object)RexLiteral.intValue(this.fetch))}));
            }
            builder.add((Statement)Expressions.return_(null, (Expression)v));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableLimitRule
    extends RelOptRule {
        private EnumerableLimitRule() {
            super(EnumerableLimitRule.operand(SortRel.class, EnumerableLimitRule.any()), "EnumerableLimitRule");
        }

        public void onMatch(RelOptRuleCall call) {
            SortRel sort = (SortRel)call.rel(0);
            if (sort.offset == null && sort.fetch == null) {
                return;
            }
            RelTraitSet traitSet = sort.getTraitSet().replace(EnumerableConvention.INSTANCE);
            RelNode input = sort.getChild();
            if (!sort.getCollation().getFieldCollations().isEmpty()) {
                input = sort.copy(sort.getTraitSet(), input, sort.getCollation(), null, null);
            }
            RelNode x = EnumerableLimitRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
            call.transformTo(new EnumerableLimitRel(sort.getCluster(), traitSet, x, sort.offset, sort.fetch));
        }
    }

    public static class EnumerableSortRel
    extends SortRel
    implements EnumerableRel {
        public EnumerableSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
            super(cluster, traitSet, child, collation, offset, fetch);
            assert (this.getConvention() instanceof EnumerableConvention);
            assert (this.getConvention() == child.getConvention());
        }

        public EnumerableSortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
            return new EnumerableSortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
        }

        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
            Expression childExp = builder.append("child", result.block);
            PhysType inputPhysType = result.physType;
            Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(this.collation.getFieldCollations());
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltinMethod.ORDER_BY.method, (Iterable)Expressions.list((Object[])new Expression[]{builder.append("keySelector", (Expression)pair.left)}).appendIfNotNull((Object)builder.appendIfNotNull("comparator", (Expression)pair.right)))));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableSortRule
    extends ConverterRule {
        private EnumerableSortRule() {
            super(SortRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableSortRule");
        }

        public RelNode convert(RelNode rel) {
            SortRel sort = (SortRel)rel;
            if (sort.offset != null || sort.fetch != null) {
                return null;
            }
            RelTraitSet traitSet = sort.getTraitSet().replace(EnumerableConvention.INSTANCE);
            RelNode input = sort.getChild();
            return new EnumerableSortRel(rel.getCluster(), traitSet, EnumerableSortRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE)), sort.getCollation(), null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableAggregateRel
    extends AggregateRelBase
    implements EnumerableRel {
        private static final List<Aggregation> SUPPORTED_AGGREGATIONS = ImmutableList.of((Object)SqlStdOperatorTable.COUNT, (Object)SqlStdOperatorTable.MIN, (Object)SqlStdOperatorTable.MAX, (Object)SqlStdOperatorTable.SUM);

        public EnumerableAggregateRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, BitSet groupSet, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, child, groupSet, aggCalls);
            assert (this.getConvention() instanceof EnumerableConvention);
            for (AggregateCall aggCall : aggCalls) {
                if (aggCall.isDistinct()) {
                    throw new InvalidRelException("distinct aggregation not supported");
                }
                AggImplementor implementor2 = RexImpTable.INSTANCE.get(aggCall.getAggregation(), false);
                if (implementor2 != null) continue;
                throw new InvalidRelException("aggregation " + aggCall.getAggregation() + " not supported");
            }
        }

        @Override
        public EnumerableAggregateRel copy(RelTraitSet traitSet, RelNode input, BitSet groupSet, List<AggregateCall> aggCalls) {
            try {
                return new EnumerableAggregateRel(this.getCluster(), traitSet, input, groupSet, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            Expression resultSelector;
            ParameterExpression key_;
            final JavaTypeFactory typeFactory = implementor.getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            Expression childExp = builder.append("child", result.block);
            final RelDataType inputRowType = this.getChild().getRowType();
            PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.preferCustom());
            final PhysType inputPhysType = result.physType;
            ParameterExpression parameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"a0");
            Expressions.FluentList keyExpressions = Expressions.list();
            PhysType keyPhysType = inputPhysType.project(BitSets.toList(this.groupSet), JavaRowFormat.LIST);
            int keyArity = this.groupSet.cardinality();
            for (int groupKey : BitSets.toIter(this.groupSet)) {
                keyExpressions.add(inputPhysType.fieldReference((Expression)parameter, groupKey));
            }
            Expression keySelector = builder.append("keySelector", inputPhysType.generateSelector(parameter, BitSets.toList(this.groupSet), keyPhysType.getFormat()));
            ArrayList<AggImpState> aggs = new ArrayList<AggImpState>(this.aggCalls.size());
            for (int i = 0; i < this.aggCalls.size(); ++i) {
                AggregateCall call = (AggregateCall)this.aggCalls.get(i);
                aggs.add(new AggImpState(i, call, false));
            }
            ArrayList<Expression> initExpressions = new ArrayList<Expression>();
            BlockBuilder initBlock = new BlockBuilder();
            ArrayList<Type> aggStateTypes = new ArrayList<Type>();
            for (final AggImpState agg : aggs) {
                agg.context = new AggContext(){

                    @Override
                    public Aggregation aggregation() {
                        return agg.call.getAggregation();
                    }

                    @Override
                    public RelDataType returnRelType() {
                        return agg.call.type;
                    }

                    @Override
                    public Type returnType() {
                        return EnumUtil.javaClass(typeFactory, this.returnRelType());
                    }

                    @Override
                    public List<? extends RelDataType> parameterRelTypes() {
                        return EnumUtil.fieldRowTypes(inputRowType, null, agg.call.getArgList());
                    }

                    @Override
                    public List<? extends Type> parameterTypes() {
                        return EnumUtil.fieldTypes(typeFactory, this.parameterRelTypes());
                    }
                };
                List<Type> state = agg.implementor.getStateType(agg.context);
                if (state.isEmpty()) continue;
                aggStateTypes.addAll(state);
                ArrayList<Expression> decls = new ArrayList<Expression>(state.size());
                for (int i = 0; i < state.size(); ++i) {
                    String aggName = "a" + agg.aggIdx;
                    if (OptiqPrepareImpl.DEBUG) {
                        aggName = Util.toJavaId(agg.call.getAggregation().getName(), 0).substring("ID$0$".length()) + aggName;
                    }
                    Type type = state.get(i);
                    ParameterExpression pe = Expressions.parameter((Type)type, (String)initBlock.newName(aggName + "s" + i));
                    initBlock.add((Statement)Expressions.declare((int)0, (ParameterExpression)pe, null));
                    decls.add((Expression)pe);
                }
                agg.state = decls;
                initExpressions.addAll(decls);
                agg.implementor.implementReset(agg.context, new AggResultContextImpl(initBlock, decls));
            }
            PhysType accPhysType = PhysTypeImpl.of(typeFactory, typeFactory.createSyntheticType(aggStateTypes));
            initBlock.add(accPhysType.record(initExpressions));
            Expression accumulatorInitializer = builder.append("accumulatorInitializer", (Expression)Expressions.lambda(Function0.class, (BlockStatement)initBlock.toBlock(), (ParameterExpression[])new ParameterExpression[0]));
            BlockBuilder builder2 = new BlockBuilder();
            final ParameterExpression inParameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)"in");
            ParameterExpression acc_ = Expressions.parameter((Type)accPhysType.getJavaRowType(), (String)"acc");
            int stateOffset = 0;
            for (int i = 0; i < aggs.size(); ++i) {
                final AggImpState agg = (AggImpState)aggs.get(i);
                int stateSize = agg.state.size();
                ArrayList<Expression> accumulator = new ArrayList<Expression>(stateSize);
                for (int j = 0; j < stateSize; ++j) {
                    accumulator.add(accPhysType.fieldReference((Expression)acc_, j + stateOffset));
                }
                agg.state = accumulator;
                stateOffset += stateSize;
                AggAddContextImpl addContext = new AggAddContextImpl(builder2, accumulator){

                    @Override
                    public List<RexNode> rexArguments() {
                        List<RelDataTypeField> inputTypes = inputPhysType.getRowType().getFieldList();
                        ArrayList<RexNode> args = new ArrayList<RexNode>();
                        for (Integer index : agg.call.getArgList()) {
                            args.add(new RexInputRef(index, inputTypes.get(index).getType()));
                        }
                        return args;
                    }

                    @Override
                    public RexToLixTranslator rowTranslator() {
                        return RexToLixTranslator.forAggregation(typeFactory, this.currentBlock(), new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(inParameter, inputPhysType)))).setNullable(this.currentNullables());
                    }
                };
                agg.implementor.implementAdd(agg.context, addContext);
            }
            builder2.add((Expression)acc_);
            Expression accumulatorAdder = builder.append("accumulatorAdder", (Expression)Expressions.lambda(Function2.class, (BlockStatement)builder2.toBlock(), (ParameterExpression[])new ParameterExpression[]{acc_, inParameter}));
            BlockBuilder resultBlock = new BlockBuilder();
            Expressions.FluentList results = Expressions.list();
            if (keyArity == 0) {
                key_ = null;
            } else {
                Type keyType = keyPhysType.getJavaRowType();
                key_ = Expressions.parameter((Type)keyType, (String)"key");
                for (int j = 0; j < keyArity; ++j) {
                    results.add(keyPhysType.fieldReference((Expression)key_, j));
                }
            }
            for (AggImpState agg : aggs) {
                results.add(agg.implementor.implementResult(agg.context, new AggResultContextImpl(resultBlock, agg.state)));
            }
            resultBlock.add(physType.record((List<Expression>)results));
            if (keyArity == 0) {
                resultSelector = builder.append("resultSelector", (Expression)Expressions.lambda(Function1.class, (BlockStatement)resultBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{acc_}));
                builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltinMethod.SINGLETON_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.call((Expression)childExp, (Method)BuiltinMethod.AGGREGATE.method, (Expression[])new Expression[]{Expressions.call((Expression)accumulatorInitializer, (String)"apply", (Expression[])new Expression[0]), accumulatorAdder, resultSelector})})));
            } else if (this.aggCalls.isEmpty()) {
                builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltinMethod.DISTINCT.method, (Iterable)Expressions.list().appendIfNotNull((Object)physType.comparer()))));
            } else {
                resultSelector = builder.append("resultSelector", (Expression)Expressions.lambda(Function2.class, (BlockStatement)resultBlock.toBlock(), (ParameterExpression[])new ParameterExpression[]{key_, acc_}));
                builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)childExp, (Method)BuiltinMethod.GROUP_BY2.method, (Iterable)Expressions.list((Object[])new Expression[]{keySelector, accumulatorInitializer, accumulatorAdder, resultSelector}).appendIfNotNull((Object)keyPhysType.comparer()))));
            }
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class EnumerableAggregateRule
    extends ConverterRule {
        private EnumerableAggregateRule() {
            super(AggregateRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            AggregateRel agg = (AggregateRel)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace(EnumerableConvention.INSTANCE);
            try {
                return new EnumerableAggregateRel(rel.getCluster(), traitSet, EnumerableAggregateRule.convert(agg.getChild(), traitSet), agg.getGroupSet(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableCalcRel
    extends CalcRelBase
    implements EnumerableRel {
        private final RexProgram program;

        public EnumerableCalcRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelDataType rowType, RexProgram program, List<RelCollation> collationList) {
            super(cluster, traitSet, child, rowType, program, collationList);
            assert (this.getConvention() instanceof EnumerableConvention);
            assert (!program.containsAggs());
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        @Override
        public EnumerableCalcRel copy(RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
            return new EnumerableCalcRel(this.getCluster(), traitSet, child, program.getOutputRowType(), program, collationList);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockStatement moveNextBody;
            JavaTypeFactory typeFactory = implementor.getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel child = (EnumerableRel)this.getChild();
            EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
            PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.prefer(result.format));
            Type outputJavaType = physType.getJavaRowType();
            Type enumeratorType = Types.of(Enumerator.class, (Type[])new Type[]{outputJavaType});
            Type inputJavaType = result.physType.getJavaRowType();
            ParameterExpression inputEnumerator = Expressions.parameter((Type)Types.of(Enumerator.class, (Type[])new Type[]{inputJavaType}), (String)"inputEnumerator");
            Expression input = RexToLixTranslator.convert((Expression)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_CURRENT.method, (Expression[])new Expression[0]), inputJavaType);
            if (this.program.getCondition() == null) {
                moveNextBody = Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_MOVE_NEXT.method, (Expression[])new Expression[0]));
            } else {
                BlockBuilder builder2 = new BlockBuilder();
                Expression condition = RexToLixTranslator.translateCondition(this.program, typeFactory, builder2, new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(input, result.physType))));
                builder2.add((Statement)Expressions.ifThen((Expression)condition, (Node)Expressions.return_(null, (Expression)Expressions.constant((Object)true))));
                moveNextBody = Expressions.block((Statement[])new Statement[]{Expressions.while_((Expression)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_MOVE_NEXT.method, (Expression[])new Expression[0]), (Statement)builder2.toBlock()), Expressions.return_(null, (Expression)Expressions.constant((Object)false))});
            }
            BlockBuilder builder3 = new BlockBuilder();
            List<Expression> expressions = RexToLixTranslator.translateProjects(this.program, typeFactory, builder3, physType, new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of(input, result.physType))));
            builder3.add((Statement)Expressions.return_(null, (Expression)physType.record(expressions)));
            BlockStatement currentBody = builder3.toBlock();
            Expression inputEnumerable = builder.append("inputEnumerable", result.block, false);
            NewExpression body = Expressions.new_((Type)enumeratorType, (Iterable)NO_EXPRS, (Iterable)Expressions.list((Object[])new MemberDeclaration[]{Expressions.fieldDecl((int)17, (ParameterExpression)inputEnumerator, (Expression)Expressions.call((Expression)inputEnumerable, (Method)BuiltinMethod.ENUMERABLE_ENUMERATOR.method, (Expression[])new Expression[0])), EnumUtil.overridingMethodDecl(BuiltinMethod.ENUMERATOR_RESET.method, NO_PARAMS, Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_RESET.method, (Expression[])new Expression[0]))), EnumUtil.overridingMethodDecl(BuiltinMethod.ENUMERATOR_MOVE_NEXT.method, NO_PARAMS, moveNextBody), EnumUtil.overridingMethodDecl(BuiltinMethod.ENUMERATOR_CLOSE.method, NO_PARAMS, Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltinMethod.ENUMERATOR_CLOSE.method, (Expression[])new Expression[0]))), Expressions.methodDecl((int)1, Object.class, (String)"current", (Iterable)NO_PARAMS, (BlockStatement)currentBody)}));
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.new_((Constructor)BuiltinMethod.ABSTRACT_ENUMERABLE_CTOR.constructor, (Iterable)NO_EXPRS, (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, (Type)enumeratorType, (String)BuiltinMethod.ENUMERABLE_ENUMERATOR.method.getName(), (Iterable)NO_PARAMS, (BlockStatement)Blocks.toFunctionBlock((Node)body))))));
            return implementor.result(physType, builder.toBlock());
        }

        @Override
        public RexProgram getProgram() {
            return this.program;
        }
    }

    private static class EnumerableCalcRule
    extends ConverterRule {
        private EnumerableCalcRule() {
            super(CalcRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableCalcRule");
        }

        public RelNode convert(RelNode rel) {
            CalcRel calc = (CalcRel)rel;
            RexProgram program = calc.getProgram();
            if (program.containsAggs()) {
                return null;
            }
            return new EnumerableCalcRel(rel.getCluster(), rel.getTraitSet().replace(EnumerableConvention.INSTANCE), EnumerableCalcRule.convert(calc.getChild(), calc.getChild().getTraitSet().replace(EnumerableConvention.INSTANCE)), calc.getRowType(), program, calc.getCollationList());
        }
    }

    public static class EnumerableFilterRel
    extends FilterRelBase
    implements EnumerableRel {
        public EnumerableFilterRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
            super(cluster, traitSet, child, condition);
            assert (this.getConvention() instanceof EnumerableConvention);
        }

        public EnumerableFilterRel copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new EnumerableFilterRel(this.getCluster(), traitSet, input, condition);
        }

        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EnumerableFilterRule
    extends ConverterRule {
        private EnumerableFilterRule() {
            super(FilterRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableFilterRule");
        }

        public RelNode convert(RelNode rel) {
            FilterRel filter = (FilterRel)rel;
            if (RexOver.containsOver(filter.getCondition())) {
                return null;
            }
            return new EnumerableFilterRel(rel.getCluster(), rel.getTraitSet().replace(EnumerableConvention.INSTANCE), EnumerableFilterRule.convert(filter.getChild(), filter.getChild().getTraitSet().replace(EnumerableConvention.INSTANCE)), filter.getCondition());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableProjectRel
    extends ProjectRelBase
    implements EnumerableRel {
        public EnumerableProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType, int flags) {
            super(cluster, traitSet, child, exps, rowType, flags);
            assert (this.getConvention() instanceof EnumerableConvention);
        }

        @Override
        public EnumerableProjectRel copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
            return new EnumerableProjectRel(this.getCluster(), traitSet, input, exps, rowType, this.flags);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EnumerableProjectRule
    extends ConverterRule {
        private EnumerableProjectRule() {
            super(ProjectRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableProjectRule");
        }

        public RelNode convert(RelNode rel) {
            ProjectRel project = (ProjectRel)rel;
            if (RexOver.containsOver(project.getProjects(), null)) {
                return null;
            }
            return new EnumerableProjectRel(rel.getCluster(), rel.getTraitSet().replace(EnumerableConvention.INSTANCE), EnumerableProjectRule.convert(project.getChild(), project.getChild().getTraitSet().replace(EnumerableConvention.INSTANCE)), project.getProjects(), project.getRowType(), 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableTableAccessRel
    extends TableAccessRelBase
    implements EnumerableRel {
        private final Class elementType;

        public EnumerableTableAccessRel(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Class elementType) {
            super(cluster, traitSet, table);
            assert (this.getConvention() instanceof EnumerableConvention);
            this.elementType = elementType;
        }

        private Expression getExpression() {
            Expression expression = this.table.getExpression(Queryable.class);
            Type type = expression.getType();
            if (Types.isArray((Type)type)) {
                if (Types.toClass((Type)type).getComponentType().isPrimitive()) {
                    expression = Expressions.call((Method)BuiltinMethod.AS_LIST.method, (Expression[])new Expression[]{expression});
                }
                expression = Expressions.call((Method)BuiltinMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{expression});
            } else if (Types.isAssignableFrom(Iterable.class, (Type)type) && !Types.isAssignableFrom(Enumerable.class, (Type)type)) {
                expression = Expressions.call((Method)BuiltinMethod.AS_ENUMERABLE2.method, (Expression[])new Expression[]{expression});
            } else if (Types.isAssignableFrom(Queryable.class, (Type)type)) {
                expression = Expressions.call((Expression)expression, (Method)BuiltinMethod.QUERYABLE_AS_ENUMERABLE.method, (Expression[])new Expression[0]);
            }
            return expression;
        }

        private JavaRowFormat format() {
            if (Object[].class.isAssignableFrom(this.elementType)) {
                return JavaRowFormat.ARRAY;
            }
            return JavaRowFormat.CUSTOM;
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new EnumerableTableAccessRel(this.getCluster(), traitSet, this.table, this.elementType);
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), this.format());
            Expression expression = this.getExpression();
            return implementor.result(physType, Blocks.toBlock((Node)expression));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumUtil {
        public static MethodDeclaration overridingMethodDecl(Method method, Iterable<ParameterExpression> parameters, BlockStatement body) {
            return Expressions.methodDecl((int)(method.getModifiers() & 0xFFFFFBFF), method.getReturnType(), (String)method.getName(), parameters, (BlockStatement)body);
        }

        static Type javaClass(JavaTypeFactory typeFactory, RelDataType type) {
            Type clazz = typeFactory.getJavaClass(type);
            return clazz instanceof Class ? clazz : Object[].class;
        }

        static Class javaRowClass(JavaTypeFactory typeFactory, RelDataType type) {
            Type clazz;
            if (type.isStruct() && type.getFieldCount() == 1) {
                type = type.getFieldList().get(0).getType();
            }
            return (clazz = typeFactory.getJavaClass(type)) instanceof Class ? (Class)clazz : Object[].class;
        }

        static List<Type> fieldTypes(final JavaTypeFactory typeFactory, final List<? extends RelDataType> inputTypes) {
            return new AbstractList<Type>(){

                @Override
                public Type get(int index) {
                    return EnumUtil.javaClass(typeFactory, (RelDataType)inputTypes.get(index));
                }

                @Override
                public int size() {
                    return inputTypes.size();
                }
            };
        }

        static List<RelDataType> fieldRowTypes(RelDataType inputRowType, final List<? extends RexNode> extraInputs, final List<Integer> argList) {
            final List<RelDataTypeField> inputFields = inputRowType.getFieldList();
            return new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    int arg = (Integer)argList.get(index);
                    return arg < inputFields.size() ? ((RelDataTypeField)inputFields.get(arg)).getType() : ((RexNode)extraInputs.get(arg - inputFields.size())).getType();
                }

                @Override
                public int size() {
                    return argList.size();
                }
            };
        }
    }

    public static class EnumerableSemiJoinRel
    extends SemiJoinRel
    implements EnumerableRel {
        protected EnumerableSemiJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) throws InvalidRelException {
            super(cluster, traits, left, right, condition, leftKeys, rightKeys);
        }

        public SemiJoinRel copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            assert (joinType == JoinRelType.INNER);
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            assert (joinInfo.isEqui());
            try {
                return new EnumerableSemiJoinRel(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            double rowCount = RelMetadataQuery.getRowCount(this);
            double rightRowCount = this.right.getRows();
            double leftRowCount = this.left.getRows();
            rowCount = Double.isInfinite(leftRowCount) ? leftRowCount : (rowCount += Util.nLogN(leftRowCount));
            rowCount = Double.isInfinite(rightRowCount) ? rightRowCount : (rowCount += rightRowCount);
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0).multiplyBy(0.01);
        }

        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
            Expression leftExpression = builder.append("left", leftResult.block);
            EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
            Expression rightExpression = builder.append("right", rightResult.block);
            PhysType physType = leftResult.physType;
            return implementor.result(physType, builder.append((Expression)Expressions.call((Method)BuiltinMethod.SEMI_JOIN.method, (Iterable)Expressions.list((Object[])new Expression[]{leftExpression, rightExpression, leftResult.physType.generateAccessor(this.leftKeys), rightResult.physType.generateAccessor(this.rightKeys)}))).toBlock());
        }
    }

    private static class EnumerableSemiJoinRule
    extends ConverterRule {
        private EnumerableSemiJoinRule() {
            super(SemiJoinRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableSemiJoinRule");
        }

        public RelNode convert(RelNode rel) {
            SemiJoinRel semiJoin = (SemiJoinRel)rel;
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : semiJoin.getInputs()) {
                if (!(input.getConvention() instanceof EnumerableConvention)) {
                    input = EnumerableSemiJoinRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
                }
                newInputs.add(input);
            }
            try {
                return new EnumerableSemiJoinRel(semiJoin.getCluster(), semiJoin.getTraitSet().replace(EnumerableConvention.INSTANCE), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), semiJoin.getCondition(), semiJoin.leftKeys, semiJoin.rightKeys);
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumerableJoinRel
    extends EquiJoinRel
    implements EnumerableRel {
        protected EnumerableJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
            super(cluster, traits, left, right, condition, leftKeys, rightKeys, joinType, variablesStopped);
        }

        @Override
        public EnumerableJoinRel copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            assert (joinInfo.isEqui());
            try {
                return new EnumerableJoinRel(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys, joinType, (Set<String>)this.variablesStopped);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            double rowCount = RelMetadataQuery.getRowCount(this);
            switch (this.joinType) {
                case RIGHT: {
                    rowCount = this.addEpsilon(rowCount);
                    break;
                }
                default: {
                    if (this.left.getId() <= this.right.getId()) break;
                    rowCount = this.addEpsilon(rowCount);
                }
            }
            double rightRowCount = this.right.getRows();
            double leftRowCount = this.left.getRows();
            rowCount = Double.isInfinite(leftRowCount) ? leftRowCount : (rowCount += Util.nLogN(leftRowCount));
            rowCount = Double.isInfinite(rightRowCount) ? rightRowCount : (rowCount += rightRowCount);
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
        }

        private double addEpsilon(double d) {
            assert (d >= 0.0);
            double d0 = d;
            if (d < 10.0 && (d *= 1.001) != d0) {
                return d;
            }
            if ((d += 1.0) != d0) {
                return d;
            }
            return d *= 1.001;
        }

        @Override
        public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
            BlockBuilder builder = new BlockBuilder();
            EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
            Expression leftExpression = builder.append("left", leftResult.block);
            EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
            Expression rightExpression = builder.append("right", rightResult.block);
            PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
            PhysType keyPhysType = leftResult.physType.project(this.leftKeys, JavaRowFormat.LIST);
            return implementor.result(physType, builder.append((Expression)Expressions.call((Expression)leftExpression, (Method)BuiltinMethod.JOIN.method, (Iterable)Expressions.list((Object[])new Expression[]{rightExpression, leftResult.physType.generateAccessor(this.leftKeys), rightResult.physType.generateAccessor(this.rightKeys), this.generateSelector(physType, (List<PhysType>)ImmutableList.of((Object)leftResult.physType, (Object)rightResult.physType))}).append((Object)Util.first(keyPhysType.comparer(), Expressions.constant(null))).append((Object)Expressions.constant((Object)this.joinType.generatesNullsOnLeft())).append((Object)Expressions.constant((Object)this.joinType.generatesNullsOnRight())))).toBlock());
        }

        Expression generateSelector(PhysType physType, List<PhysType> inputPhysTypes) {
            ArrayList<ParameterExpression> parameters = new ArrayList<ParameterExpression>();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (Ord ord : Ord.zip(inputPhysTypes)) {
                PhysType inputPhysType = ((PhysType)ord.e).makeNullable(this.joinType.generatesNullsOn(ord.i));
                ParameterExpression parameter = Expressions.parameter((Type)inputPhysType.getJavaRowType(), (String)LEFT_RIGHT[ord.i]);
                parameters.add(parameter);
                int fieldCount = inputPhysType.getRowType().getFieldCount();
                for (int i = 0; i < fieldCount; ++i) {
                    Expression expression = inputPhysType.fieldReference((Expression)parameter, i, physType.getJavaFieldType(i));
                    if (this.joinType.generatesNullsOn(ord.i)) {
                        expression = Expressions.condition((Expression)Expressions.equal((Expression)parameter, (Expression)Expressions.constant(null)), (Expression)Expressions.constant(null), (Expression)expression);
                    }
                    expressions.add(expression);
                }
            }
            return Expressions.lambda(Function2.class, (Expression)physType.record(expressions), parameters);
        }
    }

    private static class EnumerableJoinRule
    extends ConverterRule {
        private EnumerableJoinRule() {
            super(JoinRel.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableJoinRule");
        }

        public RelNode convert(RelNode rel) {
            AbstractRelNode newRel;
            RelNode right;
            JoinRel join = (JoinRel)rel;
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : join.getInputs()) {
                if (!(input.getConvention() instanceof EnumerableConvention)) {
                    input = EnumerableJoinRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
                }
                newInputs.add(input);
            }
            RelNode left = (RelNode)newInputs.get(0);
            JoinInfo info = JoinInfo.of(left, right = (RelNode)newInputs.get(1), join.getCondition());
            if (!info.isEqui() && join.getJoinType() != JoinRelType.INNER) {
                return null;
            }
            RelOptCluster cluster = join.getCluster();
            try {
                newRel = new EnumerableJoinRel(cluster, join.getTraitSet().replace(EnumerableConvention.INSTANCE), left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), info.leftKeys, info.rightKeys, join.getJoinType(), join.getVariablesStopped());
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
            if (!info.isEqui()) {
                newRel = new EnumerableFilterRel(cluster, newRel.getTraitSet(), newRel, info.getRemaining(cluster.getRexBuilder()));
            }
            return newRel;
        }
    }
}

