/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.runtime;

import net.hydromatic.linq4j.AbstractEnumerable;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.function.EqualityComparer;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Predicate1;
import org.eigenbase.util.Bug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enumerables {
    private Enumerables() {
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> semiJoin(Enumerable<TSource> outer, Enumerable<TInner> inner, Function1<TSource, TKey> outerKeySelector, Function1<TInner, TKey> innerKeySelector) {
        Bug.upgrade("move into linq4j");
        return Enumerables.semiJoin(outer, inner, outerKeySelector, innerKeySelector, null);
    }

    public static <TSource, TInner, TKey> Enumerable<TSource> semiJoin(final Enumerable<TSource> outer, final Enumerable<TInner> inner, final Function1<TSource, TKey> outerKeySelector, final Function1<TInner, TKey> innerKeySelector, final EqualityComparer<TKey> comparer) {
        return new AbstractEnumerable<TSource>(){

            public Enumerator<TSource> enumerator() {
                final Enumerable innerLookup = comparer == null ? inner.select(innerKeySelector).distinct() : inner.select(innerKeySelector).distinct(comparer);
                return Enumerables.where(outer.enumerator(), new Predicate1<TSource>(){

                    public boolean apply(TSource v0) {
                        Object key = outerKeySelector.apply(v0);
                        return innerLookup.contains(key);
                    }
                });
            }
        };
    }

    public static <TSource> Enumerable<TSource> where(final Enumerable<TSource> source, final Predicate1<TSource> predicate) {
        assert (predicate != null);
        return new AbstractEnumerable<TSource>(){

            public Enumerator<TSource> enumerator() {
                Enumerator enumerator = source.enumerator();
                return Enumerables.where(enumerator, predicate);
            }
        };
    }

    private static <TSource> Enumerator<TSource> where(final Enumerator<TSource> enumerator, final Predicate1<TSource> predicate) {
        return new Enumerator<TSource>(){

            public TSource current() {
                return enumerator.current();
            }

            public boolean moveNext() {
                while (enumerator.moveNext()) {
                    if (!predicate.apply(enumerator.current())) continue;
                    return true;
                }
                return false;
            }

            public void reset() {
                enumerator.reset();
            }

            public void close() {
                enumerator.close();
            }
        };
    }
}

