/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.prepare.PlannerImpl;
import net.hydromatic.optiq.server.OptiqServerStatement;
import net.hydromatic.optiq.tools.FrameworkConfig;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.Program;
import net.hydromatic.optiq.tools.Programs;
import net.hydromatic.optiq.tools.RuleSet;
import org.eigenbase.relopt.Context;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCostFactory;
import org.eigenbase.relopt.RelOptSchema;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.sql.SqlOperatorTable;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.sql2rel.SqlRexConvertletTable;
import org.eigenbase.sql2rel.StandardConvertletTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frameworks {
    private Frameworks() {
    }

    public static Planner getPlanner(FrameworkConfig config) {
        return new PlannerImpl(config);
    }

    public static <R> R withPlanner(final PlannerAction<R> action, FrameworkConfig config) {
        return Frameworks.withPrepare(new PrepareAction<R>(config){

            @Override
            public R apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, OptiqServerStatement statement) {
                return action.apply(cluster, relOptSchema, rootSchema);
            }
        });
    }

    public static <R> R withPlanner(PlannerAction<R> action) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        return Frameworks.withPlanner(action, config);
    }

    public static <R> R withPrepare(PrepareAction<R> action) {
        try {
            Class.forName("net.hydromatic.optiq.jdbc.Driver");
            Connection connection = DriverManager.getConnection("jdbc:optiq:");
            OptiqConnection optiqConnection = connection.unwrap(OptiqConnection.class);
            OptiqServerStatement statement = optiqConnection.createStatement().unwrap(OptiqServerStatement.class);
            return new OptiqPrepareImpl().perform(statement, action);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SchemaPlus createRootSchema(boolean addMetadataSchema) {
        return OptiqSchema.createRootSchema(addMetadataSchema).plus();
    }

    public static ConfigBuilder newConfigBuilder() {
        return new ConfigBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StdFrameworkConfig
    implements FrameworkConfig {
        private final Context context;
        private final SqlRexConvertletTable convertletTable;
        private final SqlOperatorTable operatorTable;
        private final ImmutableList<Program> programs;
        private final ImmutableList<RelTraitDef> traitDefs;
        private final Lex lex;
        private final SchemaPlus defaultSchema;
        private final RelOptCostFactory costFactory;
        private final SqlParserImplFactory parserFactory;

        public StdFrameworkConfig(Context context, SqlRexConvertletTable convertletTable, SqlOperatorTable operatorTable, ImmutableList<Program> programs, ImmutableList<RelTraitDef> traitDefs, Lex lex, SchemaPlus defaultSchema, RelOptCostFactory costFactory, SqlParserImplFactory parserFactory) {
            this.context = context;
            this.convertletTable = convertletTable;
            this.operatorTable = operatorTable;
            this.programs = programs;
            this.traitDefs = traitDefs;
            this.lex = lex;
            this.defaultSchema = defaultSchema;
            this.costFactory = costFactory;
            this.parserFactory = parserFactory;
        }

        @Override
        public Lex getLex() {
            return this.lex;
        }

        @Override
        public SqlParserImplFactory getParserFactory() {
            return this.parserFactory;
        }

        @Override
        public SchemaPlus getDefaultSchema() {
            return this.defaultSchema;
        }

        @Override
        public ImmutableList<Program> getPrograms() {
            return this.programs;
        }

        @Override
        public RelOptCostFactory getCostFactory() {
            return this.costFactory;
        }

        @Override
        public ImmutableList<RelTraitDef> getTraitDefs() {
            return this.traitDefs;
        }

        @Override
        public SqlRexConvertletTable getConvertletTable() {
            return this.convertletTable;
        }

        @Override
        public Context getContext() {
            return this.context;
        }

        @Override
        public SqlOperatorTable getOperatorTable() {
            return this.operatorTable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigBuilder {
        private SqlRexConvertletTable convertletTable = StandardConvertletTable.INSTANCE;
        private SqlOperatorTable operatorTable = SqlStdOperatorTable.instance();
        private ImmutableList<Program> programs = ImmutableList.of();
        private Context context;
        private ImmutableList<RelTraitDef> traitDefs;
        private Lex lex = Lex.ORACLE;
        private SchemaPlus defaultSchema;
        private RelOptCostFactory costFactory;
        private SqlParserImplFactory parserFactory = SqlParserImpl.FACTORY;

        private ConfigBuilder() {
        }

        public FrameworkConfig build() {
            return new StdFrameworkConfig(this.context, this.convertletTable, this.operatorTable, this.programs, this.traitDefs, this.lex, this.defaultSchema, this.costFactory, this.parserFactory);
        }

        public ConfigBuilder context(Context c) {
            this.context = (Context)Preconditions.checkNotNull((Object)c);
            return this;
        }

        public ConfigBuilder convertletTable(SqlRexConvertletTable convertletTable) {
            this.convertletTable = (SqlRexConvertletTable)Preconditions.checkNotNull((Object)convertletTable);
            return this;
        }

        public ConfigBuilder operatorTable(SqlOperatorTable operatorTable) {
            this.operatorTable = (SqlOperatorTable)Preconditions.checkNotNull((Object)operatorTable);
            return this;
        }

        public ConfigBuilder traitDefs(List<RelTraitDef> traitDefs) {
            this.traitDefs = traitDefs == null ? null : ImmutableList.copyOf(traitDefs);
            return this;
        }

        public ConfigBuilder traitDefs(RelTraitDef ... traitDefs) {
            this.traitDefs = ImmutableList.copyOf((Object[])traitDefs);
            return this;
        }

        public ConfigBuilder lex(Lex lex) {
            this.lex = (Lex)((Object)Preconditions.checkNotNull((Object)((Object)lex)));
            return this;
        }

        public ConfigBuilder defaultSchema(SchemaPlus defaultSchema) {
            this.defaultSchema = defaultSchema;
            return this;
        }

        public ConfigBuilder costFactory(RelOptCostFactory costFactory) {
            this.costFactory = costFactory;
            return this;
        }

        public ConfigBuilder ruleSets(RuleSet ... ruleSets) {
            return this.programs(Programs.listOf(ruleSets));
        }

        public ConfigBuilder ruleSets(List<RuleSet> ruleSets) {
            return this.programs(Programs.listOf((List)Preconditions.checkNotNull(ruleSets)));
        }

        public ConfigBuilder programs(List<Program> programs) {
            this.programs = ImmutableList.copyOf(programs);
            return this;
        }

        public ConfigBuilder programs(Program ... programs) {
            this.programs = ImmutableList.copyOf((Object[])programs);
            return this;
        }

        public ConfigBuilder parserFactory(SqlParserImplFactory parserFactory) {
            this.parserFactory = (SqlParserImplFactory)Preconditions.checkNotNull((Object)parserFactory);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PrepareAction<R> {
        private final FrameworkConfig config;

        public PrepareAction() {
            this.config = Frameworks.newConfigBuilder().defaultSchema(Frameworks.createRootSchema(true)).build();
        }

        public PrepareAction(FrameworkConfig config) {
            this.config = config;
        }

        public FrameworkConfig getConfig() {
            return this.config;
        }

        public abstract R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3, OptiqServerStatement var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PlannerAction<R> {
        public R apply(RelOptCluster var1, RelOptSchema var2, SchemaPlus var3);
    }
}

