/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.tools;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.rules.java.JavaRules;
import net.hydromatic.optiq.tools.Program;
import net.hydromatic.optiq.tools.RuleSet;
import net.hydromatic.optiq.tools.RuleSets;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.ChainedRelMetadataProvider;
import org.eigenbase.rel.metadata.DefaultRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.rules.CommutativeJoinRule;
import org.eigenbase.rel.rules.ConvertMultiJoinRule;
import org.eigenbase.rel.rules.FilterToCalcRule;
import org.eigenbase.rel.rules.LoptOptimizeJoinRule;
import org.eigenbase.rel.rules.MergeCalcRule;
import org.eigenbase.rel.rules.MergeFilterOntoCalcRule;
import org.eigenbase.rel.rules.MergeProjectOntoCalcRule;
import org.eigenbase.rel.rules.MergeProjectRule;
import org.eigenbase.rel.rules.OptimizeBushyJoinRule;
import org.eigenbase.rel.rules.ProjectToCalcRule;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.rel.rules.PushFilterPastProjectRule;
import org.eigenbase.rel.rules.PushJoinThroughJoinRule;
import org.eigenbase.rel.rules.PushSortPastProjectRule;
import org.eigenbase.rel.rules.ReduceAggregatesRule;
import org.eigenbase.rel.rules.RemoveDistinctAggregateRule;
import org.eigenbase.rel.rules.SemiJoinRule;
import org.eigenbase.rel.rules.SwapJoinRule;
import org.eigenbase.rel.rules.TableAccessRule;
import org.eigenbase.relopt.RelOptCostImpl;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.hep.HepMatchOrder;
import org.eigenbase.relopt.hep.HepPlanner;
import org.eigenbase.relopt.hep.HepProgram;
import org.eigenbase.relopt.hep.HepProgramBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Programs {
    private static final Function<RuleSet, Program> RULE_SET_TO_PROGRAM = new Function<RuleSet, Program>(){

        public Program apply(RuleSet ruleSet) {
            return Programs.of(ruleSet);
        }
    };
    public static final ImmutableList<RelOptRule> CALC_RULES = ImmutableList.of((Object)JavaRules.ENUMERABLE_CALC_RULE, (Object)JavaRules.ENUMERABLE_FILTER_TO_CALC_RULE, (Object)JavaRules.ENUMERABLE_PROJECT_TO_CALC_RULE, (Object)MergeCalcRule.INSTANCE, (Object)MergeFilterOntoCalcRule.INSTANCE, (Object)MergeProjectOntoCalcRule.INSTANCE, (Object)FilterToCalcRule.INSTANCE, (Object)ProjectToCalcRule.INSTANCE, (Object)MergeCalcRule.INSTANCE, (Object)MergeFilterOntoCalcRule.INSTANCE, (Object)MergeProjectOntoCalcRule.INSTANCE);
    public static final Program CALC_PROGRAM = Programs.hep(CALC_RULES, true, new DefaultRelMetadataProvider());
    public static final ImmutableSet<RelOptRule> RULE_SET = ImmutableSet.of((Object)JavaRules.ENUMERABLE_JOIN_RULE, (Object)JavaRules.ENUMERABLE_SEMI_JOIN_RULE, (Object)JavaRules.ENUMERABLE_PROJECT_RULE, (Object)JavaRules.ENUMERABLE_FILTER_RULE, (Object)JavaRules.ENUMERABLE_AGGREGATE_RULE, (Object)JavaRules.ENUMERABLE_SORT_RULE, (Object[])new RelOptRule[]{JavaRules.ENUMERABLE_LIMIT_RULE, JavaRules.ENUMERABLE_UNION_RULE, JavaRules.ENUMERABLE_INTERSECT_RULE, JavaRules.ENUMERABLE_MINUS_RULE, JavaRules.ENUMERABLE_TABLE_MODIFICATION_RULE, JavaRules.ENUMERABLE_VALUES_RULE, JavaRules.ENUMERABLE_WINDOW_RULE, JavaRules.ENUMERABLE_ONE_ROW_RULE, JavaRules.ENUMERABLE_EMPTY_RULE, SemiJoinRule.INSTANCE, TableAccessRule.INSTANCE, OptiqPrepareImpl.COMMUTE ? CommutativeJoinRule.INSTANCE : MergeProjectRule.INSTANCE, PushFilterPastProjectRule.INSTANCE, PushFilterPastJoinRule.FILTER_ON_JOIN, RemoveDistinctAggregateRule.INSTANCE, ReduceAggregatesRule.INSTANCE, SwapJoinRule.INSTANCE, PushJoinThroughJoinRule.RIGHT, PushJoinThroughJoinRule.LEFT, PushSortPastProjectRule.INSTANCE});

    private Programs() {
    }

    public static Program of(RuleSet ruleSet) {
        return new RuleSetProgram(ruleSet);
    }

    public static List<Program> listOf(RuleSet ... ruleSets) {
        return Lists.transform(Arrays.asList(ruleSets), RULE_SET_TO_PROGRAM);
    }

    public static List<Program> listOf(List<RuleSet> ruleSets) {
        return Lists.transform(ruleSets, RULE_SET_TO_PROGRAM);
    }

    public static Program ofRules(RelOptRule ... rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program ofRules(Collection<RelOptRule> rules) {
        return Programs.of(RuleSets.ofList(rules));
    }

    public static Program sequence(Program ... programs) {
        return new SequenceProgram((ImmutableList<Program>)ImmutableList.copyOf((Object[])programs));
    }

    public static Program hep(ImmutableList<RelOptRule> rules, boolean noDag, RelMetadataProvider metadataProvider) {
        HepProgramBuilder builder = HepProgram.builder();
        for (RelOptRule rule : rules) {
            builder.addRuleInstance(rule);
        }
        return Programs.of(builder.build(), noDag, metadataProvider);
    }

    public static Program of(final HepProgram hepProgram, final boolean noDag, final RelMetadataProvider metadataProvider) {
        return new Program(){

            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                HepPlanner hepPlanner = new HepPlanner(hepProgram, null, noDag, null, RelOptCostImpl.FACTORY);
                if (metadataProvider != null) {
                    ArrayList list = Lists.newArrayList();
                    list.add(metadataProvider);
                    hepPlanner.registerMetadataProviders(list);
                    RelMetadataProvider plannerChain = ChainedRelMetadataProvider.of(list);
                    rel.getCluster().setMetadataProvider(plannerChain);
                }
                hepPlanner.setRoot(rel);
                return hepPlanner.findBestExp();
            }
        };
    }

    public static Program heuristicJoinOrder(final Collection<RelOptRule> rules, final boolean bushy) {
        return new Program(){

            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                Program program;
                int joinCount = RelOptUtil.countJoins(rel);
                if (joinCount < (bushy ? 2 : 6)) {
                    program = Programs.ofRules(rules);
                } else {
                    HepProgram hep = new HepProgramBuilder().addRuleInstance(PushFilterPastJoinRule.FILTER_ON_JOIN).addMatchOrder(HepMatchOrder.BOTTOM_UP).addRuleInstance(ConvertMultiJoinRule.INSTANCE).build();
                    Program program1 = Programs.of(hep, false, null);
                    ArrayList<RelOptRule> list = new ArrayList<RelOptRule>(rules);
                    list.removeAll((Collection<?>)ImmutableList.of((Object)SwapJoinRule.INSTANCE, (Object)CommutativeJoinRule.INSTANCE, (Object)PushJoinThroughJoinRule.LEFT, (Object)PushJoinThroughJoinRule.RIGHT));
                    list.add(bushy ? OptimizeBushyJoinRule.INSTANCE : LoptOptimizeJoinRule.INSTANCE);
                    Program program2 = Programs.ofRules(list);
                    program = Programs.sequence(program1, program2);
                }
                return program.run(planner, rel, requiredOutputTraits);
            }
        };
    }

    public static Program getProgram() {
        return new Program(){

            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                return null;
            }
        };
    }

    public static Program standard() {
        Program program1 = new Program(){

            public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
                RelNode rootRel2 = planner.changeTraits(rel, requiredOutputTraits);
                assert (rootRel2 != null);
                planner.setRoot(rootRel2);
                RelOptPlanner planner2 = planner.chooseDelegate();
                RelNode rootRel3 = planner2.findBestExp();
                assert (rootRel3 != null) : "could not implement exp";
                return rootRel3;
            }
        };
        Program program2 = CALC_PROGRAM;
        return Programs.sequence(program1, program2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SequenceProgram
    implements Program {
        private final ImmutableList<Program> programs;

        SequenceProgram(ImmutableList<Program> programs) {
            this.programs = programs;
        }

        @Override
        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            for (Program program : this.programs) {
                rel = program.run(planner, rel, requiredOutputTraits);
            }
            return rel;
        }
    }

    static class RuleSetProgram
    implements Program {
        final RuleSet ruleSet;

        private RuleSetProgram(RuleSet ruleSet) {
            this.ruleSet = ruleSet;
        }

        public RelNode run(RelOptPlanner planner, RelNode rel, RelTraitSet requiredOutputTraits) {
            planner.clear();
            for (RelOptRule rule : this.ruleSet) {
                planner.addRule(rule);
            }
            if (!rel.getTraitSet().equals(requiredOutputTraits)) {
                rel = planner.changeTraits(rel, requiredOutputTraits);
            }
            planner.setRoot(rel);
            return planner.findBestExp();
        }
    }
}

