/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.metadata;

import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.ValuesRelBase;
import org.eigenbase.rel.metadata.ReflectiveRelMetadataProvider;
import org.eigenbase.rel.metadata.RelMdUtil;
import org.eigenbase.rel.metadata.RelMetadataProvider;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.rex.RexNode;

public class RelMdPopulationSize {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltinMethod.POPULATION_SIZE.method, new RelMdPopulationSize());

    private RelMdPopulationSize() {
    }

    public Double getPopulationSize(FilterRelBase rel, BitSet groupKey) {
        return RelMetadataQuery.getPopulationSize(rel.getChild(), groupKey);
    }

    public Double getPopulationSize(SortRel rel, BitSet groupKey) {
        return RelMetadataQuery.getPopulationSize(rel.getChild(), groupKey);
    }

    public Double getPopulationSize(UnionRelBase rel, BitSet groupKey) {
        Double population = 0.0;
        for (RelNode input : rel.getInputs()) {
            Double subPop = RelMetadataQuery.getPopulationSize(input, groupKey);
            if (subPop == null) {
                return null;
            }
            population = population + subPop;
        }
        return population;
    }

    public Double getPopulationSize(JoinRelBase rel, BitSet groupKey) {
        return RelMdUtil.getJoinPopulationSize(rel, groupKey);
    }

    public Double getPopulationSize(SemiJoinRel rel, BitSet groupKey) {
        return RelMetadataQuery.getPopulationSize(rel.getLeft(), groupKey);
    }

    public Double getPopulationSize(AggregateRelBase rel, BitSet groupKey) {
        BitSet childKey = new BitSet();
        RelMdUtil.setAggChildKeys(groupKey, rel, childKey);
        return RelMetadataQuery.getPopulationSize(rel.getChild(), childKey);
    }

    public Double getPopulationSize(ValuesRelBase rel, BitSet groupKey) {
        return rel.getRows() / 2.0;
    }

    public Double getPopulationSize(ProjectRelBase rel, BitSet groupKey) {
        BitSet baseCols = new BitSet();
        BitSet projCols = new BitSet();
        List<RexNode> projExprs = rel.getProjects();
        RelMdUtil.splitCols(projExprs, groupKey, baseCols, projCols);
        Double population = RelMetadataQuery.getPopulationSize(rel.getChild(), baseCols);
        if (population == null) {
            return null;
        }
        if (projCols.cardinality() == 0) {
            return population;
        }
        for (int bit : BitSets.toIter(projCols)) {
            Double subRowCount = RelMdUtil.cardOfProjExpr(rel, projExprs.get(bit));
            if (subRowCount == null) {
                return null;
            }
            population = population * subRowCount;
        }
        return RelMdUtil.numDistinctVals(population, RelMetadataQuery.getRowCount(rel));
    }

    public Double getPopulationSize(RelNode rel, BitSet groupKey) {
        boolean uniq = RelMdUtil.areColumnsDefinitelyUnique(rel, groupKey);
        if (uniq) {
            return RelMetadataQuery.getRowCount(rel);
        }
        return null;
    }
}

