/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.PushJoinThroughJoinRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.volcano.RelSubset;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexPermuteInputsShuttle;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.mapping.Mappings;

public class CommutativeJoinRule
extends RelOptRule {
    public static final CommutativeJoinRule INSTANCE = new CommutativeJoinRule();

    private CommutativeJoinRule() {
        super(CommutativeJoinRule.operand(JoinRelBase.class, CommutativeJoinRule.operand(JoinRelBase.class, CommutativeJoinRule.any()), CommutativeJoinRule.operand(RelSubset.class, CommutativeJoinRule.any())));
    }

    public void onMatch(RelOptRuleCall call) {
        JoinRelBase topJoin = (JoinRelBase)call.rel(0);
        JoinRelBase bottomJoin = (JoinRelBase)call.rel(1);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelSubset relC = (RelSubset)call.rel(2);
        RelOptCluster cluster = topJoin.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (relC.getConvention() != relA.getConvention()) {
            return;
        }
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        BitSet aBitSet = BitSets.range(0, aCount);
        BitSet bBitSet = BitSets.range(aCount, aCount + bCount);
        if (!topJoin.getSystemFieldList().isEmpty()) {
            return;
        }
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList top = Lists.newArrayList();
        ArrayList bottom = Lists.newArrayList();
        PushJoinThroughJoinRule.split(topJoin.getCondition(), aBitSet, top, bottom);
        PushJoinThroughJoinRule.split(bottomJoin.getCondition(), aBitSet, top, bottom);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, aCount, bCount, bCount, aCount + bCount, cCount);
        ArrayList newBottomList = Lists.newArrayList();
        new RexPermuteInputsShuttle(bottomMapping, relB, relC).visitList((List<? extends RexNode>)bottom, newBottomList);
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        JoinRelBase newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relB, relC, JoinRelType.INNER, false);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, top, false);
        JoinRelBase newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, relA, newBottomJoin, JoinRelType.INNER, false);
        call.transformTo(newTopJoin);
    }
}

