/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import org.eigenbase.rel.FilterRel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.rex.RexProgramBuilder;

public class MergeFilterRule
extends RelOptRule {
    public static final MergeFilterRule INSTANCE = new MergeFilterRule();

    private MergeFilterRule() {
        super(MergeFilterRule.operand(FilterRel.class, MergeFilterRule.operand(FilterRel.class, MergeFilterRule.any()), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        FilterRel topFilter = (FilterRel)call.rel(0);
        FilterRel bottomFilter = (FilterRel)call.rel(1);
        RexBuilder rexBuilder = topFilter.getCluster().getRexBuilder();
        RexProgram bottomProgram = this.createProgram(bottomFilter);
        RexProgram topProgram = this.createProgram(topFilter);
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topProgram, bottomProgram, rexBuilder);
        RexNode newCondition = mergedProgram.expandLocalRef(mergedProgram.getCondition());
        FilterRel newFilterRel = new FilterRel(topFilter.getCluster(), bottomFilter.getChild(), newCondition);
        call.transformTo(newFilterRel);
    }

    private RexProgram createProgram(FilterRel filterRel) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(filterRel.getRowType(), filterRel.getCluster().getRexBuilder());
        programBuilder.addIdentity();
        programBuilder.addCondition(filterRel.getCondition());
        return programBuilder.getProgram();
    }
}

