/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.Correlation;
import org.eigenbase.rel.CorrelatorRel;
import org.eigenbase.rel.JoinInfo;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptQuery;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.util.Util;
import org.eigenbase.util.mapping.IntPair;

public class NestedLoopsJoinRule
extends RelOptRule {
    public static final NestedLoopsJoinRule INSTANCE = new NestedLoopsJoinRule();

    private NestedLoopsJoinRule() {
        super(NestedLoopsJoinRule.operand(JoinRel.class, NestedLoopsJoinRule.any()));
    }

    public boolean matches(RelOptRuleCall call) {
        JoinRel join = (JoinRel)call.rel(0);
        switch (join.getJoinType()) {
            case INNER: 
            case LEFT: {
                return true;
            }
            case FULL: 
            case RIGHT: {
                return false;
            }
        }
        throw Util.unexpected(join.getJoinType());
    }

    public void onMatch(RelOptRuleCall call) {
        assert (this.matches(call));
        JoinRel join = (JoinRel)call.rel(0);
        RelNode right = join.getRight();
        RelNode left = join.getLeft();
        JoinInfo joinInfo = join.analyzeCondition();
        ArrayList correlationList = Lists.newArrayList();
        if (joinInfo.leftKeys.size() > 0) {
            RelOptCluster cluster = join.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RexNode condition = null;
            for (IntPair p : joinInfo.pairs()) {
                String dynInIdStr = cluster.getQuery().createCorrel();
                int dynInId = RelOptQuery.getCorrelOrdinal(dynInIdStr);
                correlationList.add(new Correlation(dynInId, p.source));
                condition = RelOptUtil.andJoinFilters(rexBuilder, condition, rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, rexBuilder.makeInputRef(right, p.target), rexBuilder.makeCorrel(left.getRowType().getFieldList().get(p.source).getType(), dynInIdStr)));
            }
            right = CalcRel.createFilter(right, condition);
        }
        CorrelatorRel newRel = new CorrelatorRel(join.getCluster(), left, right, joinInfo.getRemaining(join.getCluster().getRexBuilder()), correlationList, join.getJoinType());
        call.transformTo(newRel);
    }
}

