/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.EquiJoinRel;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.Holder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PushFilterPastJoinRule
extends RelOptRule {
    public static final PushFilterPastJoinRule FILTER_ON_JOIN = new PushFilterIntoJoinRule(true);
    public static final PushFilterPastJoinRule DUMB_FILTER_ON_JOIN = new PushFilterIntoJoinRule(false);
    public static final PushFilterPastJoinRule JOIN = new PushDownJoinConditionRule(RelFactories.DEFAULT_FILTER_FACTORY);
    private final boolean smart;
    private final RelFactories.FilterFactory filterFactory;

    protected PushFilterPastJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelFactories.FilterFactory filterFactory) {
        super(operand, "PushFilterRule: " + id);
        this.smart = smart;
        this.filterFactory = filterFactory;
    }

    protected void perform(RelOptRuleCall call, FilterRelBase filter, JoinRelBase join) {
        if (join instanceof SemiJoinRel) {
            return;
        }
        List<RexNode> joinFilters = RelOptUtil.conjunctions(join.getCondition());
        if (filter == null && joinFilters.isEmpty()) {
            return;
        }
        ImmutableList aboveFilters = filter != null ? RelOptUtil.conjunctions(filter.getCondition()) : ImmutableList.of();
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        boolean filterPushed = false;
        Holder<JoinRelType> joinTypeHolder = Holder.of(join.getJoinType());
        if (RelOptUtil.classifyFilters(join, (List<RexNode>)aboveFilters, join.getJoinType(), !(join instanceof EquiJoinRel), !join.getJoinType().generatesNullsOnLeft(), !join.getJoinType().generatesNullsOnRight(), joinFilters, leftFilters, rightFilters, joinTypeHolder, this.smart)) {
            filterPushed = true;
        }
        if (RelOptUtil.classifyFilters(join, joinFilters, join.getJoinType(), false, !join.getJoinType().generatesNullsOnRight(), !join.getJoinType().generatesNullsOnLeft(), joinFilters, leftFilters, rightFilters, joinTypeHolder, false)) {
            filterPushed = true;
        }
        if (!filterPushed) {
            return;
        }
        if (joinFilters.isEmpty() && leftFilters.isEmpty() && rightFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelNode leftRel = this.createFilterOnRel(rexBuilder, join.getLeft(), leftFilters);
        RelNode rightRel = this.createFilterOnRel(rexBuilder, join.getRight(), rightFilters);
        RexNode joinFilter = RexUtil.composeConjunction(rexBuilder, joinFilters, false);
        if (joinFilter.isAlwaysTrue() && leftFilters.isEmpty() && rightFilters.isEmpty() && joinTypeHolder.get() == join.getJoinType()) {
            return;
        }
        RelNode newJoinRel = join.copy(join.getCluster().traitSetOf(Convention.NONE), joinFilter, leftRel, rightRel, joinTypeHolder.get(), join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newJoinRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, rightRel);
        }
        newJoinRel = RelOptUtil.createCastRel(newJoinRel, join.getRowType(), false);
        RelNode newRel = this.createFilterOnRel(rexBuilder, newJoinRel, (List<RexNode>)aboveFilters);
        call.transformTo(newRel);
    }

    private RelNode createFilterOnRel(RexBuilder rexBuilder, RelNode rel, List<RexNode> filters) {
        RexNode andFilters = RexUtil.composeConjunction(rexBuilder, filters, false);
        if (andFilters.isAlwaysTrue()) {
            return rel;
        }
        return this.filterFactory.createFilter(rel, andFilters);
    }

    public static class PushFilterIntoJoinRule
    extends PushFilterPastJoinRule {
        public PushFilterIntoJoinRule(boolean smart) {
            this(smart, RelFactories.DEFAULT_FILTER_FACTORY);
        }

        public PushFilterIntoJoinRule(boolean smart, RelFactories.FilterFactory filterFactory) {
            super(RelOptRule.operand(FilterRelBase.class, RelOptRule.operand(JoinRelBase.class, RelOptRule.any()), new RelOptRuleOperand[0]), "PushFilterPastJoinRule:filter", smart, filterFactory);
        }

        public void onMatch(RelOptRuleCall call) {
            FilterRelBase filter = (FilterRelBase)call.rel(0);
            JoinRelBase join = (JoinRelBase)call.rel(1);
            this.perform(call, filter, join);
        }
    }

    public static class PushDownJoinConditionRule
    extends PushFilterPastJoinRule {
        public PushDownJoinConditionRule(RelFactories.FilterFactory filterFactory) {
            super(RelOptRule.operand(JoinRelBase.class, RelOptRule.any()), "PushFilterPastJoinRule:no-filter", true, filterFactory);
        }

        public void onMatch(RelOptRuleCall call) {
            JoinRelBase join = (JoinRelBase)call.rel(0);
            this.perform(call, null, join);
        }
    }
}

