/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.SemiJoinRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.ImmutableIntList;

public class PushSemiJoinPastJoinRule
extends RelOptRule {
    public static final PushSemiJoinPastJoinRule INSTANCE = new PushSemiJoinPastJoinRule();

    private PushSemiJoinPastJoinRule() {
        super(PushSemiJoinPastJoinRule.operand(SemiJoinRel.class, PushSemiJoinPastJoinRule.some(PushSemiJoinPastJoinRule.operand(JoinRelBase.class, PushSemiJoinPastJoinRule.any()), new RelOptRuleOperand[0])));
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode rightJoinRel;
        RelNode leftJoinRel;
        List<Integer> newLeftKeys;
        RexNode newSemiJoinFilter;
        int i;
        SemiJoinRel semiJoin = (SemiJoinRel)call.rel(0);
        JoinRelBase join = (JoinRelBase)call.rel(1);
        if (join instanceof SemiJoinRel) {
            return;
        }
        ImmutableIntList leftKeys = semiJoin.getLeftKeys();
        ImmutableIntList rightKeys = semiJoin.getRightKeys();
        int nFieldsX = join.getLeft().getRowType().getFieldList().size();
        int nFieldsY = join.getRight().getRowType().getFieldList().size();
        int nFieldsZ = semiJoin.getRight().getRowType().getFieldList().size();
        int nTotalFields = nFieldsX + nFieldsY + nFieldsZ;
        ArrayList<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();
        List<RelDataTypeField> joinFields = semiJoin.getRowType().getFieldList();
        for (i = 0; i < nFieldsX + nFieldsY; ++i) {
            fields.add(joinFields.get(i));
        }
        joinFields = semiJoin.getRight().getRowType().getFieldList();
        for (i = 0; i < nFieldsZ; ++i) {
            fields.add(joinFields.get(i));
        }
        int nKeysFromX = 0;
        for (int leftKey : leftKeys) {
            if (leftKey >= nFieldsX) continue;
            ++nKeysFromX;
        }
        assert (nKeysFromX == 0 || nKeysFromX == leftKeys.size());
        int[] adjustments = new int[nTotalFields];
        if (nKeysFromX > 0) {
            this.setJoinAdjustments(adjustments, nFieldsX, nFieldsY, nFieldsZ, 0, -nFieldsY);
            newSemiJoinFilter = semiJoin.getCondition().accept(new RelOptUtil.RexInputConverter(semiJoin.getCluster().getRexBuilder(), fields, adjustments));
            newLeftKeys = leftKeys;
        } else {
            this.setJoinAdjustments(adjustments, nFieldsX, nFieldsY, nFieldsZ, -nFieldsX, -nFieldsX);
            newSemiJoinFilter = semiJoin.getCondition().accept(new RelOptUtil.RexInputConverter(semiJoin.getCluster().getRexBuilder(), fields, adjustments));
            newLeftKeys = RelOptUtil.adjustKeys(leftKeys, -nFieldsX);
        }
        RelNode leftSemiJoinOp = nKeysFromX > 0 ? join.getLeft() : join.getRight();
        SemiJoinRel newSemiJoin = new SemiJoinRel(semiJoin.getCluster(), semiJoin.getCluster().traitSetOf(Convention.NONE), leftSemiJoinOp, semiJoin.getRight(), newSemiJoinFilter, ImmutableIntList.copyOf(newLeftKeys), rightKeys);
        if (nKeysFromX > 0) {
            leftJoinRel = newSemiJoin;
            rightJoinRel = join.getRight();
        } else {
            leftJoinRel = join.getLeft();
            rightJoinRel = newSemiJoin;
        }
        JoinRelBase newJoinRel = join.copy(join.getTraitSet(), join.getCondition(), leftJoinRel, rightJoinRel, join.getJoinType(), join.isSemiJoinDone());
        call.transformTo(newJoinRel);
    }

    private void setJoinAdjustments(int[] adjustments, int nFieldsX, int nFieldsY, int nFieldsZ, int adjustY, int adjustZ) {
        int i;
        for (i = 0; i < nFieldsX; ++i) {
            adjustments[i] = 0;
        }
        for (i = nFieldsX; i < nFieldsX + nFieldsY; ++i) {
            adjustments[i] = adjustY;
        }
        for (i = nFieldsX + nFieldsY; i < nFieldsX + nFieldsY + nFieldsZ; ++i) {
            adjustments[i] = adjustZ;
        }
    }
}

