/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.eigenbase.rel.JoinInfo;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.EquiJoinRel;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.ImmutableIntList;

public class SemiJoinRel
extends EquiJoinRel {
    public SemiJoinRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        super(cluster, traitSet, left, right, condition, leftKeys, rightKeys, JoinRelType.INNER, (Set<String>)ImmutableSet.of());
    }

    public SemiJoinRel copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (joinType == JoinRelType.INNER);
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        assert (joinInfo.isEqui());
        return new SemiJoinRel(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return planner.getCostFactory().makeTinyCost();
    }

    public double getRows() {
        return RelMetadataQuery.getRowCount(this.left) * RexUtil.getSelectivity(this.condition);
    }

    public RelDataType deriveRowType() {
        return SemiJoinRel.deriveJoinRowType(this.left.getRowType(), null, JoinRelType.INNER, this.getCluster().getTypeFactory(), null, Collections.<RelDataTypeField>emptyList());
    }
}

