/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.relopt.RelOptPredicateList;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransitivePredicatesOnJoinRule
extends RelOptRule {
    private final RelFactories.FilterFactory filterFactory;
    public static final TransitivePredicatesOnJoinRule INSTANCE = new TransitivePredicatesOnJoinRule(JoinRelBase.class, RelFactories.DEFAULT_FILTER_FACTORY);

    public TransitivePredicatesOnJoinRule(Class<? extends JoinRelBase> clazz, RelFactories.FilterFactory filterFactory) {
        super(TransitivePredicatesOnJoinRule.operand(clazz, TransitivePredicatesOnJoinRule.any()));
        this.filterFactory = filterFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode curr;
        JoinRelBase join = (JoinRelBase)call.rel(0);
        RelOptPredicateList preds = RelMetadataQuery.getPulledUpPredicates(join);
        if (preds.leftInferredPredicates.isEmpty() && preds.rightInferredPredicates.isEmpty()) {
            return;
        }
        RexBuilder rB = join.getCluster().getRexBuilder();
        RelNode lChild = join.getLeft();
        RelNode rChild = join.getRight();
        if (preds.leftInferredPredicates.size() > 0) {
            curr = lChild;
            lChild = this.filterFactory.createFilter(lChild, RexUtil.composeConjunction(rB, preds.leftInferredPredicates, false));
            call.getPlanner().onCopy(curr, lChild);
        }
        if (preds.rightInferredPredicates.size() > 0) {
            curr = rChild;
            rChild = this.filterFactory.createFilter(rChild, RexUtil.composeConjunction(rB, preds.rightInferredPredicates, false));
            call.getPlanner().onCopy(curr, rChild);
        }
        JoinRelBase newRel = join.copy(join.getTraitSet(), join.getCondition(), lChild, rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newRel);
        call.transformTo(newRel);
    }
}

