/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptCostFactory;
import org.eigenbase.util.Util;

public class RelOptCostImpl
implements RelOptCost {
    public static final RelOptCostFactory FACTORY = new Factory();
    private final double value;

    public RelOptCostImpl(double value) {
        this.value = value;
    }

    public double getRows() {
        return this.value;
    }

    public double getIo() {
        return 0.0;
    }

    public double getCpu() {
        return 0.0;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public boolean isLe(RelOptCost other) {
        return this.getRows() <= other.getRows();
    }

    public boolean isLt(RelOptCost other) {
        return this.getRows() < other.getRows();
    }

    public int hashCode() {
        return Util.hashCode(this.getRows());
    }

    public boolean equals(RelOptCost other) {
        return this.getRows() == other.getRows();
    }

    public boolean isEqWithEpsilon(RelOptCost other) {
        return Math.abs(this.getRows() - other.getRows()) < 1.0E-5;
    }

    public RelOptCost minus(RelOptCost other) {
        return new RelOptCostImpl(this.getRows() - other.getRows());
    }

    public RelOptCost plus(RelOptCost other) {
        return new RelOptCostImpl(this.getRows() + other.getRows());
    }

    public RelOptCost multiplyBy(double factor) {
        return new RelOptCostImpl(this.getRows() * factor);
    }

    public double divideBy(RelOptCost cost) {
        RelOptCostImpl that = (RelOptCostImpl)cost;
        return this.getRows() / that.getRows();
    }

    public String toString() {
        if (this.value == Double.MAX_VALUE) {
            return "huge";
        }
        return Double.toString(this.value);
    }

    private static class Factory
    implements RelOptCostFactory {
        private Factory() {
        }

        public RelOptCost makeCost(double dRows, double dCpu, double dIo) {
            return new RelOptCostImpl(dRows);
        }

        public RelOptCost makeHugeCost() {
            return new RelOptCostImpl(Double.MAX_VALUE);
        }

        public RelOptCost makeInfiniteCost() {
            return new RelOptCostImpl(Double.POSITIVE_INFINITY);
        }

        public RelOptCost makeTinyCost() {
            return new RelOptCostImpl(1.0);
        }

        public RelOptCost makeZeroCost() {
            return new RelOptCostImpl(0.0);
        }
    }
}

