/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resource;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.Constable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    private static final ThreadLocal<Locale> MAP_THREAD_TO_LOCALE = new ThreadLocal();

    private Resources() {
    }

    protected static Locale getThreadOrDefaultLocale() {
        Locale locale = Resources.getThreadLocale();
        if (locale == null) {
            return Locale.getDefault();
        }
        return locale;
    }

    public static void setThreadLocale(Locale locale) {
        MAP_THREAD_TO_LOCALE.set(locale);
    }

    public static Locale getThreadLocale() {
        return MAP_THREAD_TO_LOCALE.get();
    }

    public static <T> T create(final String base, Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.equals(BuiltinMethod.OBJECT_TO_STRING.method)) {
                    return this.toString();
                }
                Class<?> returnType = method.getReturnType();
                Class[] types = new Class[]{String.class, Locale.class, Method.class, Object[].class};
                Constructor<?> constructor = returnType.getConstructor(types);
                return constructor.newInstance(base, Resources.getThreadOrDefaultLocale(), method, args != null ? args : new Object[]{});
            }
        });
    }

    public static void validate(Object o) {
        Resources.validate(o, EnumSet.allOf(Validation.class));
    }

    public static void validate(Object o, EnumSet<Validation> validations) {
        int count = 0;
        for (Method method : o.getClass().getMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || !Inst.class.isAssignableFrom(method.getReturnType())) continue;
            ++count;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] args = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                args[i] = Resources.zero(parameterTypes[i]);
            }
            try {
                Inst inst = (Inst)method.invoke(o, args);
                inst.validate(validations);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("in " + method, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("in " + method, e.getCause());
            }
        }
        if (count == 0 && validations.contains((Object)Validation.AT_LEAST_ONE)) {
            throw new AssertionError((Object)("resource object " + o + " contains no resources"));
        }
    }

    private static Object zero(Class<?> clazz) {
        return clazz == String.class ? "" : (clazz == Byte.TYPE ? Byte.valueOf((byte)0) : (clazz == Character.TYPE ? Character.valueOf('\u0000') : (clazz == Short.TYPE ? Short.valueOf((short)0) : (clazz == Integer.TYPE ? Integer.valueOf(0) : (clazz == Long.TYPE ? Long.valueOf(0L) : (clazz == Float.TYPE ? Float.valueOf(0.0f) : (clazz == Double.TYPE ? (Constable)Double.valueOf(0.0) : (Constable)(clazz == Boolean.TYPE ? Boolean.valueOf(false) : null))))))));
    }

    private static boolean equal(Object o0, Object o1) {
        return o0 == o1 || o0 != null && o0.equals(o1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum BuiltinMethod {
        OBJECT_TO_STRING(Object.class, "toString", new Class[0]);

        public final Method method;

        private BuiltinMethod(Class clazz, String methodName, Class ... argumentTypes) {
            this.method = BuiltinMethod.lookupMethod(clazz, methodName, argumentTypes);
        }

        public static Method lookupMethod(Class clazz, String methodName, Class ... argumentTypes) {
            try {
                return clazz.getMethod(methodName, argumentTypes);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("while resolving method '" + methodName + Arrays.toString(argumentTypes) + "' in class " + clazz, e);
            }
        }
    }

    static class MyPropertyResourceBundle
    extends PropertyResourceBundle {
        public MyPropertyResourceBundle(InputStream stream) throws IOException {
            super(stream);
        }

        void setParentTrojan(ResourceBundle parent) {
            super.setParent(parent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ShadowResourceBundle
    extends ResourceBundle {
        private PropertyResourceBundle bundle;

        protected ShadowResourceBundle() throws IOException {
            Class<?> clazz = this.getClass();
            InputStream stream = ShadowResourceBundle.openPropertiesFile(clazz);
            if (stream == null) {
                throw new IOException("could not open properties file for " + this.getClass());
            }
            MyPropertyResourceBundle previousBundle = new MyPropertyResourceBundle(stream);
            this.bundle = previousBundle;
            stream.close();
            while ((clazz = clazz.getSuperclass()) != null && clazz != ShadowResourceBundle.class && ResourceBundle.class.isAssignableFrom(clazz)) {
                stream = ShadowResourceBundle.openPropertiesFile(clazz);
                if (stream == null) continue;
                MyPropertyResourceBundle newBundle = new MyPropertyResourceBundle(stream);
                stream.close();
                previousBundle.setParentTrojan(newBundle);
                previousBundle = newBundle;
            }
        }

        private static InputStream openPropertiesFile(Class clazz) {
            final ClassLoader loader = clazz.getClassLoader();
            final String resName = clazz.getName().replace('.', '/') + ".properties";
            return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (loader != null) {
                        return loader.getResourceAsStream(resName);
                    }
                    return ClassLoader.getSystemResourceAsStream(resName);
                }
            });
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.bundle.getKeys();
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.bundle.getObject(key);
        }

        protected static ShadowResourceBundle instance(String baseName, Locale locale, ResourceBundle bundle) {
            if (bundle instanceof PropertyResourceBundle) {
                throw new ClassCastException("ShadowResourceBundle.instance('" + baseName + "','" + locale + "') found " + baseName + "_" + locale + ".properties but not " + baseName + "_" + locale + ".class");
            }
            return (ShadowResourceBundle)bundle;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Property {
        public String name();

        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Resource {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BaseMessage {
        public String value();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Validation {
        BUNDLE_HAS_RESOURCE,
        AT_LEAST_ONE,
        MESSAGE_SPECIFIED,
        EVEN_QUOTES,
        MESSAGE_MATCH,
        CREATE_EXCEPTION,
        ARGUMENT_MATCH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExInst<T extends Exception>
    extends ExInstWithCause<T> {
        public ExInst(String base, Locale locale, Method method, Object ... args) {
            super(base, locale, method, args);
        }

        public T ex() {
            return this.ex(null);
        }

        @Override
        public void validate(EnumSet<Validation> validations) {
            super.validate(validations);
            if (validations.contains((Object)Validation.CREATE_EXCEPTION)) {
                this.validateException(new Callable<Exception>(){

                    @Override
                    public Exception call() throws Exception {
                        return ExInst.this.ex();
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExInstWithCause<T extends Exception>
    extends Inst {
        public ExInstWithCause(String base, Locale locale, Method method, Object ... args) {
            super(base, locale, method, args);
        }

        @Override
        public Inst localize(Locale locale) {
            return new ExInstWithCause<T>(this.base, locale, this.method, this.args);
        }

        public T ex(Throwable cause) {
            try {
                Constructor constructor;
                Class exceptionClass = ExInstWithCause.getExceptionClass(this.method.getGenericReturnType());
                String str = this.str();
                boolean causeInConstructor = false;
                try {
                    constructor = exceptionClass.getConstructor(String.class, Throwable.class);
                    causeInConstructor = true;
                }
                catch (NoSuchMethodException nsmStringThrowable) {
                    try {
                        constructor = exceptionClass.getConstructor(String.class);
                    }
                    catch (NoSuchMethodException nsmString) {
                        throw nsmStringThrowable;
                    }
                }
                if (causeInConstructor) {
                    return (T)((Exception)constructor.newInstance(str, cause));
                }
                Exception ex = (Exception)constructor.newInstance(str);
                if (cause != null) {
                    try {
                        ex.initCause(cause);
                    }
                    catch (IllegalStateException iae) {
                        // empty catch block
                    }
                }
                return (T)ex;
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }

        public static Class getExceptionClass(Type type) {
            Type type0 = type;
            do {
                if (!(type instanceof ParameterizedType)) continue;
                Type[] types = ((ParameterizedType)type).getActualTypeArguments();
                if (types.length >= 1 && types[0] instanceof Class && Throwable.class.isAssignableFrom((Class)types[0])) {
                    return (Class)types[0];
                }
                throw new IllegalStateException("Unable to find superclass ExInstWithCause for " + type);
            } while (!(type instanceof Class) || (type = ((Class)type).getGenericSuperclass()) != null);
            throw new IllegalStateException("Unable to find superclass ExInstWithCause for " + type0);
        }

        protected void validateException(Callable<Exception> exSupplier) {
            Object cause = null;
            try {
                Exception ex = exSupplier.call();
                if (ex == null) {
                    cause = new NullPointerException();
                }
            }
            catch (AssertionError e) {
                cause = e;
            }
            catch (RuntimeException e) {
                cause = e;
            }
            catch (Exception e) {
                cause = e;
            }
            if (cause != null) {
                AssertionError assertionError = new AssertionError((Object)("error instantiating exception for resource '" + this.method.getName() + "'"));
                ((Throwable)((Object)assertionError)).initCause((Throwable)cause);
                throw assertionError;
            }
        }

        @Override
        public void validate(EnumSet<Validation> validations) {
            super.validate(validations);
            if (validations.contains((Object)Validation.CREATE_EXCEPTION)) {
                this.validateException(new Callable<Exception>(){

                    @Override
                    public Exception call() throws Exception {
                        return ExInstWithCause.this.ex(new NullPointerException("test"));
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Inst {
        protected final String base;
        private final Locale locale;
        protected final Method method;
        protected final Object[] args;

        public Inst(String base, Locale locale, Method method, Object ... args) {
            this.base = base;
            this.locale = locale;
            this.method = method;
            this.args = args;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && obj.getClass() == this.getClass() && this.locale == ((Inst)obj).locale && this.method == ((Inst)obj).method && Arrays.equals(this.args, ((Inst)obj).args);
        }

        public int hashCode() {
            return Arrays.asList(this.locale, this.method, Arrays.asList(this.args)).hashCode();
        }

        public ResourceBundle bundle() {
            return ResourceBundle.getBundle(this.base, this.locale);
        }

        public Inst localize(Locale locale) {
            return new Inst(this.base, locale, this.method, this.args);
        }

        public void validate(EnumSet<Validation> validations) {
            ResourceBundle bundle = this.bundle();
            block7: for (Validation validation : validations) {
                String key = this.key();
                switch (validation) {
                    case BUNDLE_HAS_RESOURCE: {
                        if (!bundle.containsKey(key)) {
                            throw new AssertionError((Object)("key '" + key + "' not found for resource '" + this.method.getName() + "' in bundle '" + bundle + "'"));
                        }
                        break;
                    }
                    case MESSAGE_SPECIFIED: {
                        BaseMessage annotation1 = this.method.getAnnotation(BaseMessage.class);
                        if (annotation1 == null) {
                            throw new AssertionError((Object)("resource '" + this.method.getName() + "' must specify BaseMessage"));
                        }
                        break;
                    }
                    case EVEN_QUOTES: {
                        String message = this.method.getAnnotation(BaseMessage.class).value();
                        if (this.countQuotesIn(message) % 2 == 1) {
                            throw new AssertionError((Object)("resource '" + this.method.getName() + "' should have even number of quotes"));
                        }
                        break;
                    }
                    case MESSAGE_MATCH: {
                        String value2;
                        BaseMessage annotation2 = this.method.getAnnotation(BaseMessage.class);
                        if (annotation2 == null) break;
                        String value = annotation2.value();
                        if (!Resources.equal(value, value2 = bundle.containsKey(key) ? bundle.getString(key) : null)) {
                            throw new AssertionError((Object)("message for resource '" + this.method.getName() + "' is different between class and resource file"));
                        }
                        continue block7;
                    }
                    case ARGUMENT_MATCH: {
                        String raw = this.raw();
                        MessageFormat format = new MessageFormat(raw);
                        Format[] formats = format.getFormatsByArgumentIndex();
                        ArrayList<Class<Date>> types = new ArrayList<Class<Date>>();
                        Class<?>[] parameterTypes = this.method.getParameterTypes();
                        for (int i = 0; i < formats.length; ++i) {
                            Format format1 = formats[i];
                            Class<?> parameterType = parameterTypes[i];
                            Class e = format1 instanceof NumberFormat ? (parameterType == Short.TYPE || parameterType == Integer.TYPE || parameterType == Long.TYPE || parameterType == Float.TYPE || parameterType == Double.TYPE || Number.class.isAssignableFrom(parameterType) ? parameterType : Number.class) : (format1 instanceof DateFormat ? Date.class : String.class);
                            types.add(e);
                        }
                        List<Class<?>> parameterTypeList = Arrays.asList(parameterTypes);
                        if (!types.equals(parameterTypeList)) {
                            throw new AssertionError((Object)("type mismatch in method '" + this.method.getName() + "' between message format elements " + types + " and method parameters " + parameterTypeList));
                        }
                        break;
                    }
                }
            }
        }

        private int countQuotesIn(String message) {
            int count = 0;
            int n = message.length();
            for (int i = 0; i < n; ++i) {
                if (message.charAt(i) != '\'') continue;
                ++count;
            }
            return count;
        }

        public String str() {
            String message = this.raw();
            MessageFormat format = new MessageFormat(message);
            format.setLocale(this.locale);
            return format.format(this.args);
        }

        public String raw() {
            try {
                return this.bundle().getString(this.key());
            }
            catch (MissingResourceException e) {
                return this.method.getAnnotation(BaseMessage.class).value();
            }
        }

        private String key() {
            Resource resource = this.method.getAnnotation(Resource.class);
            if (resource != null) {
                return resource.value();
            }
            String name = this.method.getName();
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }

        public Map<String, String> getProperties() {
            Property property = this.method.getAnnotation(Property.class);
            if (property == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(property.name(), property.value());
        }
    }
}

