/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexFieldCollation
extends Pair<RexNode, ImmutableSet<SqlKind>> {
    public RexFieldCollation(RexNode left, Set<SqlKind> right) {
        super(left, ImmutableSet.copyOf(right));
    }

    @Override
    public String toString() {
        String s = ((RexNode)this.left).toString();
        block5: for (SqlKind operator : (ImmutableSet)this.right) {
            switch (operator) {
                case DESCENDING: {
                    s = s + " DESC";
                    continue block5;
                }
                case NULLS_FIRST: {
                    s = s + " NULLS FIRST";
                    continue block5;
                }
                case NULLS_LAST: {
                    s = s + " NULLS LAST";
                    continue block5;
                }
            }
            throw new AssertionError((Object)operator);
        }
        return s;
    }

    public RelFieldCollation.Direction getDirection() {
        return ((ImmutableSet)this.right).contains((Object)SqlKind.DESCENDING) ? RelFieldCollation.Direction.DESCENDING : RelFieldCollation.Direction.ASCENDING;
    }

    public RelFieldCollation.NullDirection getNullDirection() {
        return ((ImmutableSet)this.right).contains((Object)SqlKind.NULLS_LAST) ? RelFieldCollation.NullDirection.LAST : (((ImmutableSet)this.right).contains((Object)SqlKind.NULLS_FIRST) ? RelFieldCollation.NullDirection.FIRST : RelFieldCollation.NullDirection.UNSPECIFIED);
    }
}

