/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rex;

import java.util.ArrayList;
import java.util.List;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.util.mapping.Mappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RexPermuteInputsShuttle
extends RexShuttle {
    private final Mappings.TargetMapping mapping;
    private final List<RelDataTypeField> fields = new ArrayList<RelDataTypeField>();

    public RexPermuteInputsShuttle(Mappings.TargetMapping mapping, RelNode ... inputs) {
        this.mapping = mapping;
        for (RelNode input : inputs) {
            this.fields.addAll(input.getRowType().getFieldList());
        }
    }

    @Override
    public RexNode visitInputRef(RexInputRef local) {
        int index = local.getIndex();
        int target = this.mapping.getTarget(index);
        return new RexInputRef(target, local.getType());
    }

    @Override
    public RexNode visitCall(RexCall call) {
        String name;
        int i;
        if (call.getOperator() == RexBuilder.GET_OPERATOR && (i = RexPermuteInputsShuttle.lookup(this.fields, name = (String)((RexLiteral)call.getOperands().get(1)).getValue2())) >= 0) {
            return RexInputRef.of(i, this.fields);
        }
        return super.visitCall(call);
    }

    private static int lookup(List<RelDataTypeField> fields, String name) {
        for (int i = 0; i < fields.size(); ++i) {
            RelDataTypeField field = fields.get(i);
            if (!field.getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

