/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sarg;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sarg.SargBoundType;
import org.eigenbase.sarg.SargEndpoint;
import org.eigenbase.sarg.SargFactory;
import org.eigenbase.sarg.SargMutableEndpoint;
import org.eigenbase.sarg.SargStrictness;

public abstract class SargIntervalBase {
    protected final SargFactory factory;
    protected final SargMutableEndpoint lowerBound;
    protected final SargMutableEndpoint upperBound;

    SargIntervalBase(SargFactory factory, RelDataType dataType) {
        this.factory = factory;
        this.lowerBound = factory.newEndpoint(dataType);
        this.upperBound = factory.newEndpoint(dataType);
        this.unsetLower();
        this.unsetUpper();
    }

    public SargEndpoint getLowerBound() {
        return this.lowerBound;
    }

    public SargEndpoint getUpperBound() {
        return this.upperBound;
    }

    public boolean isPoint() {
        return this.lowerBound.isClosed() && this.upperBound.isClosed() && this.lowerBound.isTouching(this.upperBound);
    }

    public boolean isEmpty() {
        return !this.lowerBound.isClosed() && !this.upperBound.isClosed() && this.lowerBound.isNull() && this.upperBound.isNull();
    }

    public boolean isRange() {
        return !this.isPoint() && !this.isEmpty();
    }

    public boolean isUnconstrained() {
        return !this.lowerBound.isFinite() && !this.upperBound.isFinite();
    }

    public SargFactory getFactory() {
        return this.factory;
    }

    void setPoint(RexNode coordinate) {
        this.setLower(coordinate, SargStrictness.CLOSED);
        this.setUpper(coordinate, SargStrictness.CLOSED);
    }

    void setNull() {
        this.setPoint(this.factory.newNullLiteral());
    }

    void setLower(RexNode coordinate, SargStrictness strictness) {
        this.lowerBound.setFinite(SargBoundType.LOWER, strictness, coordinate);
    }

    void setUpper(RexNode coordinate, SargStrictness strictness) {
        this.upperBound.setFinite(SargBoundType.UPPER, strictness, coordinate);
    }

    void unsetLower() {
        this.lowerBound.setInfinity(-1);
    }

    void unsetUpper() {
        this.upperBound.setInfinity(1);
    }

    void setUnconstrained() {
        this.unsetLower();
        this.unsetUpper();
    }

    void setEmpty() {
        this.setLower(this.factory.newNullLiteral(), SargStrictness.OPEN);
        this.setUpper(this.factory.newNullLiteral(), SargStrictness.OPEN);
    }

    public RelDataType getDataType() {
        return this.lowerBound.getDataType();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.lowerBound.isClosed()) {
            sb.append("[");
        } else {
            sb.append("(");
        }
        if (!this.isEmpty()) {
            this.printBound(sb, this.lowerBound);
            if (!this.isPoint()) {
                sb.append(", ");
                this.printBound(sb, this.upperBound);
            }
        }
        if (this.upperBound.isClosed()) {
            sb.append("]");
        } else {
            sb.append(")");
        }
        return sb.toString();
    }

    private void printBound(StringBuilder sb, SargEndpoint endpoint) {
        if (endpoint.isFinite()) {
            sb.append(endpoint.getCoordinate().toString());
        } else {
            sb.append(endpoint);
        }
    }
}

