/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.List;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.fun.SqlCase;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.util.Util;

public class SqlCoalesceFunction
extends SqlFunction {
    public SqlCoalesceFunction() {
        super("COALESCE", SqlKind.OTHER_FUNCTION, ReturnTypes.LEAST_RESTRICTIVE, null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    }

    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        this.validateQuantifier(validator, call);
        List<SqlNode> operands = call.getOperandList();
        if (operands.size() == 1) {
            return operands.get(0);
        }
        SqlParserPos pos = call.getParserPosition();
        SqlNodeList whenList = new SqlNodeList(pos);
        SqlNodeList thenList = new SqlNodeList(pos);
        int i = 0;
        while (i + 1 < operands.size()) {
            whenList.add(SqlStdOperatorTable.IS_NOT_NULL.createCall(pos, operands.get(i)));
            thenList.add(operands.get(i).clone(operands.get(i).getParserPosition()));
            ++i;
        }
        SqlNode elseExpr = Util.last(operands);
        assert (call.getFunctionQuantifier() == null);
        return SqlCase.createSwitched(pos, null, whenList, thenList, elseExpr);
    }
}

