/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCountAggFunction
extends SqlAggFunction {
    public SqlCountAggFunction() {
        super("COUNT", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, null, SqlValidator.STRICT ? OperandTypes.ANY : OperandTypes.ONE_OR_MORE, SqlFunctionCategory.NUMERIC);
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_STAR;
    }

    @Override
    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        return ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.ANY));
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createSqlType(SqlTypeName.BIGINT);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        if (call.isCountStar()) {
            return validator.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        }
        return super.deriveType(validator, scope, call);
    }
}

