/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.type.SqlOperandTypeChecker;
import org.eigenbase.sql.validate.SqlValidator;
import org.eigenbase.sql.validate.SqlValidatorScope;

public class SqlCursorConstructor
extends SqlSpecialOperator {
    public SqlCursorConstructor() {
        super("CURSOR", SqlKind.CURSOR, 200, false, ReturnTypes.CURSOR, null, (SqlOperandTypeChecker)OperandTypes.ANY);
    }

    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        SqlSelect subSelect = (SqlSelect)call.operand(0);
        validator.declareCursor(subSelect, scope);
        subSelect.validateExpr(validator, scope);
        return super.deriveType(validator, scope, call);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword("CURSOR");
        SqlWriter.Frame frame = writer.startList("(", ")");
        assert (call.operandCount() == 1);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.endList(frame);
    }

    public boolean argumentMustBeScalar(int ordinal) {
        return false;
    }
}

