/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.fun;

import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperatorBinding;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlUtil;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.util.Pair;

public class SqlRowOperator
extends SqlSpecialOperator {
    public SqlRowOperator() {
        super("ROW", SqlKind.ROW, 200, false, null, InferTypes.RETURN_TYPE, OperandTypes.VARIADIC);
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    public RelDataType inferReturnType(final SqlOperatorBinding opBinding) {
        return opBinding.getTypeFactory().createStructType((List<? extends Map.Entry<String, RelDataType>>)new AbstractList<Map.Entry<String, RelDataType>>(){

            @Override
            public Map.Entry<String, RelDataType> get(int index) {
                return Pair.of(SqlUtil.deriveAliasFromOrdinal(index), opBinding.getOperandType(index));
            }

            @Override
            public int size() {
                return opBinding.getOperandCount();
            }
        });
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlUtil.unparseFunctionSyntax(this, writer, call);
    }

    public boolean requiresDecimalExpansion() {
        return false;
    }
}

