/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.parser;

import java.io.StringReader;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.Quoting;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlAbstractParserImpl;
import org.eigenbase.sql.parser.SqlParseException;
import org.eigenbase.sql.parser.SqlParserImplFactory;
import org.eigenbase.sql.parser.impl.SqlParserImpl;
import org.eigenbase.util.EigenbaseContextException;

public class SqlParser {
    private final SqlAbstractParserImpl parser;
    private String originalInput;

    private SqlParser(String s, SqlAbstractParserImpl parser, Quoting quoting, Casing unquotedCasing, Casing quotedCasing) {
        this.originalInput = s;
        this.parser = parser;
        parser.setTabSize(1);
        parser.setQuotedCasing(quotedCasing);
        parser.setUnquotedCasing(unquotedCasing);
        switch (quoting) {
            case DOUBLE_QUOTE: {
                parser.switchTo("DQID");
                break;
            }
            case BACK_TICK: {
                parser.switchTo("BTID");
                break;
            }
            case BRACKET: {
                parser.switchTo("DEFAULT");
            }
        }
    }

    public static SqlParser create(String s) {
        return SqlParser.create(SqlParserImpl.FACTORY, s, Quoting.DOUBLE_QUOTE, Casing.TO_UPPER, Casing.UNCHANGED);
    }

    public static SqlParser create(SqlParserImplFactory parserFactory, String s, Quoting quoting, Casing unquotedCasing, Casing quotedCasing) {
        SqlAbstractParserImpl parser = parserFactory.getParser(new StringReader(s));
        return new SqlParser(s, parser, quoting, unquotedCasing, quotedCasing);
    }

    public SqlNode parseExpression() throws SqlParseException {
        try {
            return this.parser.parseSqlExpressionEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseQuery() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlNode parseStmt() throws SqlParseException {
        try {
            return this.parser.parseSqlStmtEof();
        }
        catch (Throwable ex) {
            if (ex instanceof EigenbaseContextException && this.originalInput != null) {
                ((EigenbaseContextException)ex).setOriginalStatement(this.originalInput);
            }
            throw this.parser.normalizeException(ex);
        }
    }

    public SqlAbstractParserImpl.Metadata getMetadata() {
        return this.parser.getMetadata();
    }
}

