/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.type;

import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactoryImpl;
import org.eigenbase.sql.SqlIntervalQualifier;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.AbstractSqlType;
import org.eigenbase.sql.type.SqlTypeName;

public class IntervalSqlType
extends AbstractSqlType {
    private SqlIntervalQualifier intervalQualifier;

    public IntervalSqlType(SqlIntervalQualifier intervalQualifier, boolean isNullable) {
        super(intervalQualifier.isYearMonth() ? SqlTypeName.INTERVAL_YEAR_MONTH : SqlTypeName.INTERVAL_DAY_TIME, isNullable, null);
        this.intervalQualifier = intervalQualifier;
        this.computeDigest();
    }

    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("INTERVAL ");
        sb.append(this.intervalQualifier.toString());
    }

    public SqlIntervalQualifier getIntervalQualifier() {
        return this.intervalQualifier;
    }

    public IntervalSqlType combine(RelDataTypeFactoryImpl typeFactory, IntervalSqlType that) {
        assert (this.intervalQualifier.isYearMonth() == that.intervalQualifier.isYearMonth());
        boolean nullable = this.isNullable || that.isNullable;
        SqlIntervalQualifier.TimeUnit thisStart = this.intervalQualifier.getStartUnit();
        SqlIntervalQualifier.TimeUnit thisEnd = this.intervalQualifier.getEndUnit();
        SqlIntervalQualifier.TimeUnit thatStart = that.intervalQualifier.getStartUnit();
        SqlIntervalQualifier.TimeUnit thatEnd = that.intervalQualifier.getEndUnit();
        assert (null != thisStart);
        assert (null != thatStart);
        int secondPrec = this.intervalQualifier.getStartPrecisionPreservingDefault();
        int fracPrec = SqlIntervalQualifier.combineFractionalSecondPrecisionPreservingDefault(this.intervalQualifier, that.intervalQualifier);
        if (thisStart.ordinal() > thatStart.ordinal()) {
            thisEnd = thisStart;
            thisStart = thatStart;
            secondPrec = that.intervalQualifier.getStartPrecisionPreservingDefault();
        } else if (thisStart.ordinal() == thatStart.ordinal()) {
            secondPrec = SqlIntervalQualifier.combineStartPrecisionPreservingDefault(this.intervalQualifier, that.intervalQualifier);
        } else if (null == thisEnd || thisEnd.ordinal() < thatStart.ordinal()) {
            thisEnd = thatStart;
        }
        if (null != thatEnd && (null == thisEnd || thisEnd.ordinal() < thatEnd.ordinal())) {
            thisEnd = thatEnd;
        }
        RelDataType intervalType = typeFactory.createSqlIntervalType(new SqlIntervalQualifier(thisStart, secondPrec, thisEnd, fracPrec, SqlParserPos.ZERO));
        intervalType = typeFactory.createTypeWithNullability(intervalType, nullable);
        return (IntervalSqlType)intervalType;
    }

    public int getPrecision() {
        return this.intervalQualifier.getStartPrecision();
    }

    public int getScale() {
        return this.intervalQualifier.getFractionalSecondPrecision();
    }
}

